/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.model;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.entity.monster.AnuBoss;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;

public class AnuBossModel
extends EntityModel<AnuBoss>
implements ArmedModel {
    public static final ResourceLocation TEXTURE = FossilMod.location("textures/entity/anu_boss.png");
    private final ModelPart model = AnuBossModel.createBodyLayer().m_171564_();
    private final ModelPart rightArm = this.model.m_171324_("right_arm");
    private final ModelPart leftArm = this.model.m_171324_("left_arm");
    private final ModelPart rightLeg = this.model.m_171324_("right_leg");
    private final ModelPart leftLeg = this.model.m_171324_("left_leg");
    private final ModelPart head = this.model.m_171324_("head");
    private final ModelPart rightWing1 = this.model.m_171324_("right_wing_1");
    private final ModelPart rightWing2 = this.rightWing1.m_171324_("right_wing_2");
    private final ModelPart rightWing3 = this.rightWing2.m_171324_("right_wing_3");
    private final ModelPart leftWing1 = this.model.m_171324_("left_wing_1");
    private final ModelPart leftWing2 = this.leftWing1.m_171324_("left_wing_2");
    private final ModelPart leftWing3 = this.leftWing2.m_171324_("left_wing_3");

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition root = meshDefinition.m_171576_();
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)0.0f));
        head.m_171599_("right_horn", CubeListBuilder.m_171558_().m_171514_(0, 6).m_171481_(-1.0f, -6.0f, -0.5f, 2.0f, 6.0f, 1.0f), PartPose.m_171419_((float)-3.0f, (float)-8.0f, (float)3.5f));
        head.m_171599_("left_horn", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171481_(-1.0f, -6.0f, -0.5f, 2.0f, 6.0f, 1.0f), PartPose.m_171419_((float)3.0f, (float)-8.0f, (float)3.5f));
        head.m_171599_("head_thing", CubeListBuilder.m_171558_().m_171514_(24, 2).m_171480_().m_171481_(-2.0f, -3.0f, -8.0f, 4.0f, 3.0f, 12.0f), PartPose.m_171419_((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition mouth = head.m_171599_("mouth", CubeListBuilder.m_171558_().m_171514_(26, 17).m_171481_(-3.0f, -3.0f, -2.0f, 6.0f, 3.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-4.0f));
        mouth.m_171599_("right_tusk", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-0.5f, -1.0f, -0.5f, 1.0f, 1.0f, 1.0f), PartPose.m_171419_((float)-2.5f, (float)-3.0f, (float)-1.5f));
        mouth.m_171599_("left_tusk", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-0.5f, -1.0f, -0.5f, 1.0f, 1.0f, 1.0f), PartPose.m_171419_((float)2.5f, (float)-3.0f, (float)-1.5f));
        root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(40, 18).m_171481_(-4.0f, -4.0f, -2.0f, 8.0f, 10.0f, 4.0f), PartPose.m_171419_((float)0.0f, (float)8.0f, (float)0.0f));
        root.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(47, 0).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 4.0f), PartPose.m_171419_((float)-2.0f, (float)14.0f, (float)0.0f));
        root.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(47, 0).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 10.0f, 4.0f), PartPose.m_171419_((float)2.0f, (float)14.0f, (float)0.0f));
        root.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -1.0f, -2.0f, 4.0f, 10.0f, 4.0f), PartPose.m_171419_((float)-4.0f, (float)5.0f, (float)0.0f));
        root.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(16, 0).m_171481_(0.0f, -1.0f, -2.0f, 4.0f, 10.0f, 4.0f), PartPose.m_171419_((float)4.0f, (float)5.0f, (float)0.0f));
        PartDefinition leftWing1 = root.m_171599_("left_wing_1", CubeListBuilder.m_171558_().m_171514_(0, 42).m_171481_(0.0f, -3.0f, 0.0f, 6.0f, 10.0f, 0.0f), PartPose.m_171423_((float)2.0f, (float)7.5f, (float)1.9f, (float)0.0f, (float)-0.43633232f, (float)0.0f));
        PartDefinition leftWing2 = leftWing1.m_171599_("left_wing_2", CubeListBuilder.m_171558_().m_171514_(12, 43).m_171481_(0.0f, -4.0f, 0.0f, 12.0f, 12.0f, 0.0f), PartPose.m_171423_((float)6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.43633232f, (float)0.0f));
        leftWing2.m_171599_("left_wing_3", CubeListBuilder.m_171558_().m_171514_(36, 43).m_171481_(0.0f, -4.0f, 0.0f, 6.0f, 10.0f, 0.0f), PartPose.m_171419_((float)12.0f, (float)1.0f, (float)0.0f));
        PartDefinition rightWing1 = root.m_171599_("right_wing_1", CubeListBuilder.m_171558_().m_171480_().m_171514_(0, 42).m_171481_(-6.0f, -3.0f, 0.0f, 6.0f, 10.0f, 0.0f), PartPose.m_171423_((float)-2.0f, (float)7.5f, (float)1.9f, (float)0.0f, (float)0.43633232f, (float)0.0f));
        PartDefinition rightWing2 = rightWing1.m_171599_("right_wing_2", CubeListBuilder.m_171558_().m_171480_().m_171514_(12, 43).m_171481_(-12.0f, -4.0f, 0.0f, 12.0f, 12.0f, 0.0f), PartPose.m_171423_((float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.43633232f, (float)0.0f));
        rightWing2.m_171599_("right_wing_3", CubeListBuilder.m_171558_().m_171480_().m_171514_(36, 43).m_171481_(-6.0f, -4.0f, 0.0f, 6.0f, 10.0f, 0.0f), PartPose.m_171419_((float)-12.0f, (float)1.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public void prepareMobModel(AnuBoss entity, float limbSwing, float limbSwingAmount, float partialTick) {
        boolean wingsVisible;
        this.leftWing1.f_104207_ = wingsVisible = entity.phaseSystem.getCurrentPhase().isFlying();
        this.rightWing1.f_104207_ = wingsVisible;
    }

    public void setupAnim(AnuBoss entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.phaseSystem.getCurrentPhase().isFlying()) {
            this.head.m_171327_((float)Math.toRadians(-35.0), 0.0f, this.head.f_104205_);
            this.rightArm.f_104203_ = 0.0f;
            this.leftArm.f_104203_ = (float)Math.toRadians(-125.0);
            this.rightLeg.f_104203_ = 0.0f;
            this.leftLeg.f_104203_ = 0.0f;
        } else {
            this.rightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
            this.leftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + 1.0f)) * limbSwingAmount;
            this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + 1.0f)) * limbSwingAmount;
            this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI + 2.0f)) * limbSwingAmount;
            this.head.m_171327_(headPitch * ((float)Math.PI / 180), netHeadYaw * ((float)Math.PI / 180), this.head.f_104205_);
        }
        this.leftWing2.f_104204_ = 0.5f * Mth.m_14031_((float)(limbSwingAmount * 0.1f + limbSwing));
        this.leftWing3.f_104204_ = -0.5f * Mth.m_14031_((float)(limbSwingAmount * 0.1f + limbSwing));
        this.rightWing2.f_104204_ = 0.5f * Mth.m_14031_((float)(limbSwingAmount * 0.1f + (limbSwing + 1.0f)));
        this.rightWing3.f_104204_ = -0.5f * Mth.m_14031_((float)(limbSwingAmount * 0.1f + (limbSwing + 1.0f)));
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.model.m_104306_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void m_6002_(HumanoidArm side, PoseStack poseStack) {
        this.getArm(side).m_104299_(poseStack);
    }

    protected ModelPart getArm(HumanoidArm side) {
        if (side == HumanoidArm.LEFT) {
            return this.leftArm;
        }
        return this.rightArm;
    }
}

