/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.model;

import com.github.teamfossilsarcheology.fossil.entity.monster.FriendlyPiglin;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public class FriendlyPiglinModel
extends PlayerModel<FriendlyPiglin> {
    private final ModelPart rightEar;
    private final ModelPart leftEar;
    private final PartPose bodyDefault;
    private final PartPose headDefault;
    private final PartPose leftArmDefault;
    private final PartPose rightArmDefault;

    public FriendlyPiglinModel() {
        super(FriendlyPiglinModel.createBodyLayer().m_171564_(), false);
        this.rightEar = this.f_102808_.m_171324_("right_ear");
        this.leftEar = this.f_102808_.m_171324_("left_ear");
        this.bodyDefault = this.f_102810_.m_171308_();
        this.headDefault = this.f_102808_.m_171308_();
        this.leftArmDefault = this.f_102812_.m_171308_();
        this.rightArmDefault = this.f_102811_.m_171308_();
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = PlayerModel.m_170825_((CubeDeformation)CubeDeformation.f_171458_, (boolean)false);
        PartDefinition root = meshDefinition.m_171576_();
        root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171481_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f), PartPose.f_171404_);
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171481_(-5.0f, -8.0f, -4.0f, 10.0f, 8.0f, 8.0f).m_171514_(31, 1).m_171481_(-2.0f, -4.0f, -5.0f, 4.0f, 4.0f, 1.0f).m_171514_(2, 4).m_171481_(2.0f, -2.0f, -5.0f, 1.0f, 2.0f, 1.0f).m_171514_(2, 0).m_171481_(-3.0f, -2.0f, -5.0f, 1.0f, 2.0f, 1.0f), PartPose.f_171404_);
        head.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(51, 6).m_171481_(0.0f, 0.0f, -2.0f, 1.0f, 5.0f, 4.0f), PartPose.m_171423_((float)4.5f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5235988f));
        head.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(39, 6).m_171481_(-1.0f, 0.0f, -2.0f, 1.0f, 5.0f, 4.0f), PartPose.m_171423_((float)-4.5f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5235988f));
        root.m_171599_("hat", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public void setupAnim(FriendlyPiglin entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.f_102810_.m_171322_(this.bodyDefault);
        this.f_102808_.m_171322_(this.headDefault);
        this.f_102812_.m_171322_(this.leftArmDefault);
        this.f_102811_.m_171322_(this.rightArmDefault);
        super.m_6973_((LivingEntity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        float f = 0.5235988f;
        float g = ageInTicks * 0.1f + limbSwing * 0.5f;
        float h = 0.08f + limbSwingAmount * 0.4f;
        this.leftEar.f_104205_ = -f - Mth.m_14089_((float)(g * 1.2f)) * h;
        this.rightEar.f_104205_ = f + Mth.m_14089_((float)g) * h;
        AnimationUtils.m_102102_((ModelPart)this.f_102812_, (ModelPart)this.f_102811_, (boolean)entity.m_5912_(), (float)this.f_102608_, (float)ageInTicks);
        if (entity.m_21825_()) {
            this.f_102813_.m_171327_(-1.2566371f, 0.31415927f, this.f_102813_.f_104205_);
            this.f_102814_.m_171327_(-1.2566371f, -0.31415927f, this.f_102813_.f_104205_);
        }
        this.f_103376_.m_104315_(this.f_102814_);
        this.f_103377_.m_104315_(this.f_102813_);
        this.f_103374_.m_104315_(this.f_102812_);
        this.f_103375_.m_104315_(this.f_102811_);
        this.f_103378_.m_104315_(this.f_102810_);
        this.f_102809_.m_104315_(this.f_102808_);
    }

    protected void setupAttackAnimation(FriendlyPiglin livingEntity, float ageInTicks) {
        if (this.f_102608_ > 0.0f) {
            AnimationUtils.m_102091_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, (Mob)livingEntity, (float)this.f_102608_, (float)ageInTicks);
            return;
        }
        super.m_7884_((LivingEntity)livingEntity, ageInTicks);
    }
}

