/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.renderer;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.config.FossilConfig;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import com.github.teamfossilsarcheology.fossil.material.ModFluids;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import org.joml.Vector4f;

public class OverlayRenderer {
    private static final ResourceLocation ANCIENT_HELMET = FossilMod.location("textures/gui/ancient_helmet_blur.png");
    private static final ResourceLocation BONE_HELMET = FossilMod.location("textures/gui/bone_helmet_blur.png");
    private static final ResourceLocation TAR = FossilMod.location("textures/block/tar_still.png");

    public static void renderHelmet(int screenWidth, int screenHeight) {
        ItemStack helmet;
        boolean ancient;
        Minecraft mc = Minecraft.m_91087_();
        if (FossilConfig.isEnabled("helmetOverlays") && mc.f_91066_.m_92176_().m_90612_() && ((ancient = (helmet = mc.f_91074_.m_6844_(EquipmentSlot.HEAD)).m_150930_((Item)ModItems.ANCIENT_HELMET.get())) || helmet.m_150930_((Item)ModItems.BONE_HELMET.get()))) {
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableBlend();
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)(ancient ? ANCIENT_HELMET : BONE_HELMET));
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferbuilder.m_5483_(0.0, (double)screenHeight, -90.0).m_7421_(0.0f, 1.0f).m_5752_();
            bufferbuilder.m_5483_((double)screenWidth, (double)screenHeight, -90.0).m_7421_(1.0f, 1.0f).m_5752_();
            bufferbuilder.m_5483_((double)screenWidth, 0.0, -90.0).m_7421_(1.0f, 0.0f).m_5752_();
            bufferbuilder.m_5483_(0.0, 0.0, -90.0).m_7421_(0.0f, 0.0f).m_5752_();
            tesselator.m_85914_();
            RenderSystem.disableBlend();
        }
    }

    public static void renderTar(PoseStack poseStack) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_.m_204029_(ModFluids.TAR_FLUID)) {
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TAR);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tesselator.m_85915_();
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            OverlayRenderer.vertex(bufferbuilder, matrix4f, -1.0f, -1.0f, -0.5f).m_7421_(0.0f, 1.0f).m_5752_();
            OverlayRenderer.vertex(bufferbuilder, matrix4f, 1.0f, -1.0f, -0.5f).m_7421_(1.0f, 1.0f).m_5752_();
            OverlayRenderer.vertex(bufferbuilder, matrix4f, 1.0f, 1.0f, -0.5f).m_7421_(1.0f, 0.0f).m_5752_();
            OverlayRenderer.vertex(bufferbuilder, matrix4f, -1.0f, 1.0f, -0.5f).m_7421_(0.0f, 0.0f).m_5752_();
            tesselator.m_85914_();
            RenderSystem.disableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private static VertexConsumer vertex(BufferBuilder bufferBuilder, Matrix4f matrix4f, float x, float y, float z) {
        Vector4f vector4f = new Vector4f(x, y, z, 1.0f);
        matrix4f.transform(vector4f);
        return bufferBuilder.m_5483_((double)vector4f.x(), (double)vector4f.y(), (double)vector4f.z());
    }
}

