/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.renderer.entity;

import com.github.teamfossilsarcheology.fossil.client.renderer.entity.PrehistoricGeoRenderer;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.swimming.Meganeura;
import com.github.teamfossilsarcheology.fossil.entity.util.Util;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class MeganeuraRenderer
extends PrehistoricGeoRenderer<Meganeura> {
    public MeganeuraRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, "meganeura", RenderType::m_110473_);
    }

    @Override
    public void render(Meganeura meganeura, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        if (meganeura.getAttachSystem().attachStarted()) {
            Direction face = meganeura.getAttachSystem().getAttachmentFace();
            Vec3i normal = face.m_122436_();
            float yRot = MeganeuraRenderer.toPoseStackRotation(face.m_122424_().m_122435_());
            float xRot = (float)(-Mth.m_14136_((double)Mth.m_14116_((float)(normal.m_123341_() * normal.m_123341_() + normal.m_123343_() * normal.m_123343_())), (double)0.0)) * 57.295776f;
            float translate = meganeura.m_20205_() / 2.0f;
            float yTranslate = 0.2f;
            if (!meganeura.getAttachSystem().isAttached()) {
                Vec3 pos = meganeura.getAttachSystem().getAttachmentPos();
                double dist = pos.m_82554_(meganeura.m_20182_());
                if (dist < 1.0) {
                    xRot *= (float)Math.min((-dist + 1.0) * 1.2, 1.0);
                    translate *= (float)Math.min((-dist + 1.0) * 1.2, 1.0);
                    yTranslate *= (float)Math.min((-dist + 1.0) * 1.2, 1.0);
                } else {
                    xRot = 0.0f;
                    translate = 0.0f;
                    yTranslate = 0.0f;
                }
                Vec3 offset = pos.m_82546_(meganeura.m_20182_());
                double yawDiff = Mth.m_14136_((double)offset.f_82481_, (double)offset.f_82479_) * 57.2957763671875;
                yRot = MeganeuraRenderer.toPoseStackRotation(Util.clampTo360(Util.yawToYRot(yawDiff)));
            }
            poseStack.m_252880_((float)(-normal.m_123341_()) * translate, yTranslate, (float)(-normal.m_123343_()) * translate);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(yRot += entityYaw));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(xRot));
        }
        super.render(meganeura, entityYaw, partialTick, poseStack, buffer, packedLight);
        poseStack.m_85849_();
    }

    private static float toPoseStackRotation(float rot) {
        return -rot;
    }
}

