/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.renderer.entity;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.InstructionTab;
import com.github.teamfossilsarcheology.fossil.client.model.PrehistoricGeoModel;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.Arthropleura;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.util.Version;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.joml.Vector3f;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.core.object.Color;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class PrehistoricGeoRenderer<T extends Prehistoric>
extends GeoEntityRenderer<T> {
    public PrehistoricGeoRenderer(EntityRendererProvider.Context renderManager, String model, Function<ResourceLocation, RenderType> renderType) {
        super(renderManager, new PrehistoricGeoModel(model, renderType));
    }

    public void preRender(PoseStack poseStack, T animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.withScale(((Prehistoric)animatable).m_6134_());
        super.preRender(poseStack, animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void render(T entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        this.f_114477_ = entity.m_20205_() * 0.45f;
        poseStack.m_85836_();
        if (((Prehistoric)entity).getClimbingDirection() != Direction.UP || ((Prehistoric)entity).prevClimbDirection != Direction.UP && ((Prehistoric)entity).climbTick > 0) {
            float progress = Mth.m_14179_((float)partialTick, (float)((Prehistoric)entity).prevClimbTick, (float)((Prehistoric)entity).climbTick) / 5.0f;
            Direction dir = ((Prehistoric)entity).getClimbingDirection() != Direction.UP ? ((Prehistoric)entity).getClimbingDirection() : ((Prehistoric)entity).prevClimbDirection;
            float offset = entity.m_20205_() / 2.0f * progress;
            poseStack.m_85837_((double)((float)dir.m_122429_() * offset), 0.5 * (double)progress, (double)((float)dir.m_122431_() * offset));
            Direction dirRot = dir.m_122427_();
            poseStack.m_252781_(Axis.m_253057_((Vector3f)new Vector3f((float)dirRot.m_122429_(), 0.0f, (float)dirRot.m_122431_())).m_252977_(90.0f * progress));
        }
        super.m_7392_(entity, entityYaw, partialTick, poseStack, buffer, packedLight);
        poseStack.m_85849_();
    }

    public Color getRenderColor(T animatable, float partialTick, int packedLight) {
        Arthropleura arthropleura;
        if (Version.debugEnabled()) {
            if (InstructionTab.entityListHighlight != null && InstructionTab.entityListHighlight.m_19879_() == animatable.m_19879_()) {
                return Color.RED;
            }
            if (InstructionTab.highlightInstructionEntity != null && InstructionTab.highlightInstructionEntity.m_19879_() == animatable.m_19879_()) {
                return Color.RED;
            }
        }
        if (animatable instanceof Arthropleura && (arthropleura = (Arthropleura)animatable).isBee()) {
            return Color.YELLOW;
        }
        return super.getRenderColor(animatable, partialTick, packedLight);
    }

    public float getMotionAnimThreshold(T animatable) {
        return 0.008f;
    }

    protected void applyRotations(T animatable, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick) {
        String name;
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - rotationYaw));
        if (((Prehistoric)animatable).f_20919_ > 0) {
            float deathRotation = ((float)((Prehistoric)animatable).f_20919_ + partialTick - 1.0f) / 20.0f * 1.6f;
            poseStack.m_252781_(Axis.f_252403_.m_252977_(Math.min(Mth.m_14116_((float)deathRotation), 1.0f) * this.getDeathMaxRotation((Entity)animatable)));
        } else if (animatable.m_8077_() && (name = ChatFormatting.m_126649_((String)animatable.m_7755_().getString())) != null && (name.equals("Dinnerbone") || name.equalsIgnoreCase("Grumm"))) {
            poseStack.m_252880_(0.0f, animatable.m_20206_() + 0.1f, 0.0f);
            poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        }
    }
}

