/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.compat.geckolib;

import com.github.teamfossilsarcheology.fossil.mixin.AnimatableManagerAccessor;
import com.github.teamfossilsarcheology.fossil.mixin.AnimationControllerAccessor;
import java.util.Map;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animatable.model.CoreGeoModel;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.EasingType;
import software.bernie.geckolib.core.keyframe.AnimationPoint;
import software.bernie.geckolib.core.keyframe.BoneAnimationQueue;
import software.bernie.geckolib.core.state.BoneSnapshot;

public class AnimationProcessorOverride {
    public static <T extends GeoAnimatable> void tickAdditiveAnimations(T animatable, CoreGeoModel<T> model, double animTime, AnimationState<T> state, boolean reloadAnimations, Map<String, CoreGeoBone> bones, boolean crashWhenCantFindBone, AnimatableManager<T> manager, Map<String, BoneSnapshot> boneSnapshots) {
        for (AnimationController controller : manager.getAnimationControllers().values()) {
            if (reloadAnimations) {
                controller.forceAnimationReset();
                controller.getBoneAnimationQueues().clear();
            }
            ((AnimationControllerAccessor)controller).setIsJustStarting(((AnimatableManagerAccessor)manager).isFirstTick());
            state.withController(controller);
            controller.process(model, state, bones, boneSnapshots, animTime, crashWhenCantFindBone);
        }
        for (CoreGeoBone bone : bones.values()) {
            boolean firstRot = true;
            boolean firstPos = true;
            boolean firstScale = true;
            BoneSnapshot snapshot = boneSnapshots.get(bone.getName());
            BoneSnapshot initialSnapshot = bone.getInitialSnapshot();
            for (AnimationController controller : manager.getAnimationControllers().values()) {
                if (controller.getBoneAnimationQueues().isEmpty()) continue;
                BoneAnimationQueue boneAnimation = (BoneAnimationQueue)controller.getBoneAnimationQueues().get(bone.getName());
                AnimationPoint rotXPoint = (AnimationPoint)boneAnimation.rotationXQueue().poll();
                AnimationPoint rotYPoint = (AnimationPoint)boneAnimation.rotationYQueue().poll();
                AnimationPoint rotZPoint = (AnimationPoint)boneAnimation.rotationZQueue().poll();
                AnimationPoint posXPoint = (AnimationPoint)boneAnimation.positionXQueue().poll();
                AnimationPoint posYPoint = (AnimationPoint)boneAnimation.positionYQueue().poll();
                AnimationPoint posZPoint = (AnimationPoint)boneAnimation.positionZQueue().poll();
                AnimationPoint scaleXPoint = (AnimationPoint)boneAnimation.scaleXQueue().poll();
                AnimationPoint scaleYPoint = (AnimationPoint)boneAnimation.scaleYQueue().poll();
                AnimationPoint scaleZPoint = (AnimationPoint)boneAnimation.scaleZQueue().poll();
                EasingType easingType = ((AnimationControllerAccessor)controller).getOverrideEasingTypeFunction().apply(animatable);
                if (rotXPoint != null && rotYPoint != null && rotZPoint != null) {
                    bone.setRotX((float)EasingType.lerpWithOverride((AnimationPoint)rotXPoint, (EasingType)easingType) + (firstRot ? initialSnapshot.getRotX() : bone.getRotX()));
                    bone.setRotY((float)EasingType.lerpWithOverride((AnimationPoint)rotYPoint, (EasingType)easingType) + (firstRot ? initialSnapshot.getRotY() : bone.getRotY()));
                    bone.setRotZ((float)EasingType.lerpWithOverride((AnimationPoint)rotZPoint, (EasingType)easingType) + (firstRot ? initialSnapshot.getRotZ() : bone.getRotZ()));
                    snapshot.updateRotation(bone.getRotX(), bone.getRotY(), bone.getRotZ());
                    snapshot.startRotAnim();
                    bone.markRotationAsChanged();
                    firstRot = false;
                }
                if (posXPoint != null && posYPoint != null && posZPoint != null) {
                    bone.setPosX((float)EasingType.lerpWithOverride((AnimationPoint)posXPoint, (EasingType)easingType) + (firstPos ? 0.0f : bone.getPosX()));
                    bone.setPosY((float)EasingType.lerpWithOverride((AnimationPoint)posYPoint, (EasingType)easingType) + (firstPos ? 0.0f : bone.getPosY()));
                    bone.setPosZ((float)EasingType.lerpWithOverride((AnimationPoint)posZPoint, (EasingType)easingType) + (firstPos ? 0.0f : bone.getPosZ()));
                    snapshot.updateOffset(bone.getPosX(), bone.getPosY(), bone.getPosZ());
                    snapshot.startPosAnim();
                    bone.markPositionAsChanged();
                    firstPos = false;
                }
                if (scaleXPoint == null || scaleYPoint == null || scaleZPoint == null) continue;
                bone.setScaleX((float)EasingType.lerpWithOverride((AnimationPoint)scaleXPoint, (EasingType)easingType) * (firstScale ? 1.0f : bone.getScaleX()));
                bone.setScaleY((float)EasingType.lerpWithOverride((AnimationPoint)scaleYPoint, (EasingType)easingType) * (firstScale ? 1.0f : bone.getScaleY()));
                bone.setScaleZ((float)EasingType.lerpWithOverride((AnimationPoint)scaleZPoint, (EasingType)easingType) * (firstScale ? 1.0f : bone.getScaleZ()));
                snapshot.updateScale(bone.getScaleX(), bone.getScaleY(), bone.getScaleZ());
                snapshot.startScaleAnim();
                bone.markScaleAsChanged();
                firstScale = false;
            }
        }
    }
}

