/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai;

import com.github.teamfossilsarcheology.fossil.entity.ai.MoveToFoodGoal;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationCategory;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.util.Util;
import com.github.teamfossilsarcheology.fossil.food.FoodMappings;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.entity.EntityTypeTest;

public class EatItemEntityGoal
extends MoveToFoodGoal {
    private ItemEntity targetItem;
    private boolean recentlyAte;

    public EatItemEntityGoal(Prehistoric entity) {
        super(entity, 1.0, 16);
    }

    @Override
    protected int nextStartTick() {
        if (this.recentlyAte) {
            this.recentlyAte = false;
            return 20;
        }
        return super.nextStartTick();
    }

    @Override
    protected boolean checkReachedTarget() {
        if (Math.abs(this.entity.m_20186_() - this.targetItem.m_20186_()) > 3.0) {
            return false;
        }
        return Util.directionVecTo((Entity)this.targetItem, (Entity)this.entity).m_165924_() <= this.acceptedDistance();
    }

    @Override
    public void m_8037_() {
        super.m_8037_();
        if (this.isReachedTarget()) {
            if (this.entity.getHunger() < this.entity.getMaxHunger()) {
                this.entity.feed(FoodMappings.getFoodAmount((ItemLike)this.targetItem.m_32055_().m_41720_(), this.entity.data().diet()));
                this.targetItem.m_32055_().m_41774_(1);
            }
            this.recentlyAte = true;
            if (this.entity.m_9236_().m_46467_() > this.animEndTick) {
                AnimationInfo animationInfo = this.entity.nextEatingAnimation();
                this.entity.getAnimationLogic().triggerAnimation("Movement/Idle", animationInfo, AnimationCategory.EAT);
                this.animEndTick = (long)((double)this.entity.m_9236_().m_46467_() + animationInfo.animation.length());
            }
        }
    }

    @Override
    protected boolean isValidTarget(LevelReader level, BlockPos pos) {
        if (!super.isValidTarget(level, pos)) {
            return false;
        }
        return this.targetItem != null && this.targetItem.m_6084_();
    }

    @Override
    protected boolean findNearestBlock() {
        List nearbyItems = this.entity.m_9236_().m_142425_(EntityTypeTest.m_156916_(ItemEntity.class), this.entity.m_20191_().m_82400_((double)this.searchRange), itemEntity -> FoodMappings.getFoodAmount((ItemLike)itemEntity.m_32055_().m_41720_(), this.entity.data().diet()) > 0 && !this.avoidCache.contains(itemEntity.m_20183_().m_121878_()));
        this.targetItem = nearbyItems.stream().min((o1, o2) -> Double.compare(this.entity.m_20280_((Entity)o1), this.entity.m_20280_((Entity)o2))).orElse(null);
        if (this.targetItem == null) {
            this.clearTicks = !this.avoidCache.isEmpty() ? 400 : 0;
            return false;
        }
        this.setTargetPos(this.targetItem.m_20183_());
        return true;
    }
}

