/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai;

import com.github.teamfossilsarcheology.fossil.entity.ToyBall;
import com.github.teamfossilsarcheology.fossil.entity.ToyBase;
import com.github.teamfossilsarcheology.fossil.entity.ai.PlayGoal;
import com.github.teamfossilsarcheology.fossil.entity.animation.ServerAnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfoAI;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.SwimmingAnimal;
import com.github.teamfossilsarcheology.fossil.entity.util.Util;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public class WaterPlayGoal<T extends Prehistoric>
extends PlayGoal {
    private static final int ATTACK = 0;
    private static final int GRAB = 1;
    private static final int GRAB_DURATION = 55;
    private final T swimming;
    private int attackType = -1;
    private long grabStartTick = -1L;

    public WaterPlayGoal(T dino, double speedModifier) {
        super((Prehistoric)dino, speedModifier);
        this.swimming = dino;
    }

    @Override
    public boolean m_8045_() {
        if (this.attackType == 1 && !((SwimmingAnimal)this.swimming).isDoingGrabAttack()) {
            return false;
        }
        return super.m_8045_();
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.attackType = -1;
        this.grabStartTick = -1L;
    }

    @Override
    protected ToyBase findPlayTarget() {
        if (this.dino.m_20069_()) {
            return Util.getNearestEntity(ToyBall.class, (Mob)this.dino, this.getTargetSearchArea(this.getFollowDistance()), Entity::m_20069_);
        }
        return Util.getNearestEntity(ToyBase.class, (Mob)this.dino, this.getTargetSearchArea(this.getFollowDistance()), toyBase -> true);
    }

    @Override
    public void m_8037_() {
        if (this.attackType != 1) {
            this.dino.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
            if (this.dino.m_21573_().m_26571_() && !Util.canReachPrey(this.dino, this.target)) {
                this.dino.m_21573_().m_5624_((Entity)this.target, this.speedModifier);
            }
        }
        this.checkAndPerformAttack(this.target);
    }

    @Override
    protected void checkAndPerformAttack(ToyBase target) {
        long currentTime = this.dino.m_9236_().m_46467_();
        if (this.attackType == 1) {
            for (Entity passenger : this.swimming.m_20197_()) {
                if (!(passenger instanceof ToyBase)) continue;
                ToyBase toy = (ToyBase)passenger;
                if (currentTime != this.grabStartTick + 55L) continue;
                ((SwimmingAnimal)this.swimming).stopGrabAttack(passenger);
                ((Prehistoric)this.swimming).moodSystem.setToyTarget(null);
                ((Prehistoric)this.swimming).moodSystem.useToy(toy.moodBonus);
            }
        } else if (this.attackType == 0) {
            if (this.attackDamageTick > 0L && currentTime >= this.attackDamageTick) {
                target.m_6469_(this.dino.m_269291_().m_269333_((LivingEntity)this.dino), 0.0f);
                this.attackDamageTick = -1L;
                this.attackType = -1;
            }
        } else if (currentTime > this.attackEndTick + 20L && Util.canReachPrey(this.dino, target)) {
            boolean tooBig = Util.isEntityLargerThan(target, 2.0f * ((Prehistoric)this.swimming).m_6134_() / ((Prehistoric)this.swimming).data().maxScale());
            if (((Prehistoric)this.swimming).aiAttackType() != PrehistoricEntityInfoAI.Attacking.GRAB || tooBig || this.swimming.m_217043_().m_188503_(5) > 0) {
                this.attackType = 0;
                ServerAnimationInfo animationInfo = this.dino.startAttack();
                this.attackDamageTick = (long)((double)currentTime + animationInfo.actionDelay);
                this.attackEndTick = (long)((double)currentTime + animationInfo.animation.length());
                if (this.attackDamageTick > this.attackEndTick) {
                    this.attackDamageTick = this.attackEndTick;
                }
            } else {
                this.attackType = 1;
                ((SwimmingAnimal)this.swimming).startGrabAttack(target);
                this.attackEndTick = 1L;
                this.grabStartTick = currentTime;
            }
        }
    }
}

