/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.base;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.advancements.ModTriggers;
import com.github.teamfossilsarcheology.fossil.capabilities.ModCapabilities;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfoAI;
import com.github.teamfossilsarcheology.fossil.network.MessageHandler;
import com.github.teamfossilsarcheology.fossil.network.S2CMusicMessage;
import com.github.teamfossilsarcheology.fossil.sounds.ModSounds;
import com.mojang.logging.LogUtils;
import dev.architectury.extensions.network.EntitySpawnExtension;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class DinosaurEgg
extends LivingEntity
implements EntitySpawnExtension {
    public static final int TOTAL_HATCHING_TIME = 3000;
    public static final ResourceLocation GOLDEN_EGG_ADV = FossilMod.location("fossil/all_eggs");
    private static final EntityDataAccessor<Integer> HATCHING_TIME = SynchedEntityData.m_135353_(DinosaurEgg.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> GOLDEN_EGG = SynchedEntityData.m_135353_(DinosaurEgg.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Component EGG_HATCHED = Component.m_237115_((String)"entity.fossil.dinosaur_egg.hatched");
    private static final List<ItemStack> ARMOR = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    private float scaleOverride = -1.0f;
    private PrehistoricEntityInfo prehistoricEntityInfo = PrehistoricEntityInfo.TRICERATOPS;

    public DinosaurEgg(EntityType<DinosaurEgg> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 2.0);
    }

    public static Entity hatchEgg(Level level, double x, double y, double z, @Nullable ServerPlayer player, PrehistoricEntityInfo info, boolean hatchMessage) {
        Entity entity = info.entityType().m_20615_(level);
        if (entity instanceof Prehistoric) {
            Prehistoric prehistoric = (Prehistoric)entity;
            if (player != null) {
                ModTriggers.INCUBATE_EGG_TRIGGER.trigger(player, entity);
                if (prehistoric.aiTameType() == PrehistoricEntityInfoAI.Taming.IMPRINTING) {
                    prehistoric.m_21828_((Player)player);
                    if (!ModCapabilities.hasHatchedDinosaur((Player)player)) {
                        MessageHandler.SYNC_CHANNEL.sendToPlayer(player, (Object)new S2CMusicMessage((SoundEvent)ModSounds.MUSIC_FIRST_DINOSAUR.get()));
                        ModCapabilities.setHatchedDinosaur((Player)player, true);
                    }
                    if (hatchMessage) {
                        player.m_5661_(EGG_HATCHED, false);
                    }
                }
            }
            prehistoric.m_6518_((ServerLevelAccessor)level, level.m_6436_(entity.m_20183_()), MobSpawnType.BREEDING, new Prehistoric.PrehistoricGroupData(0), null);
            prehistoric.grow(0);
        }
        entity.m_7678_(x, y, z, level.f_46441_.m_188501_() * 360.0f, 0.0f);
        level.m_7967_(entity);
        return entity;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HATCHING_TIME, (Object)0);
        this.f_19804_.m_135372_(GOLDEN_EGG, (Object)false);
    }

    @NotNull
    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public boolean m_6094_() {
        return true;
    }

    public boolean m_5829_() {
        return this.m_6084_();
    }

    public void m_8119_() {
        super.m_8119_();
        int currentHatchingTime = this.getHatchingTime();
        if (!this.isGoldenEgg() && this.isTooCold() || this.m_20069_()) {
            if (currentHatchingTime > 0) {
                this.setHatchingTime(currentHatchingTime - 1);
            }
        } else {
            this.setHatchingTime(currentHatchingTime + 1);
        }
        if (this.getHatchingTime() >= this.getTotalHatchingTime() && !this.m_9236_().f_46443_) {
            Player player = this.m_9236_().m_45930_((Entity)this, 16.0);
            DinosaurEgg.hatchEgg(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), (ServerPlayer)player, this.prehistoricEntityInfo, true);
            for (int i = 0; i < 4; ++i) {
                double x = this.m_20185_() + ((double)this.f_19796_.m_188501_() - 0.5) * (double)this.m_20205_();
                double y = this.m_20191_().f_82289_ + 0.1;
                double z = this.m_20189_() + ((double)this.f_19796_.m_188501_() - 0.5) * (double)this.m_20205_();
                double motionX = (double)this.f_19796_.m_188501_() - 0.5;
                double motionZ = (double)this.f_19796_.m_188501_() - 0.5;
                this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)this.prehistoricEntityInfo.eggItem)), x, y, z, motionX, 0.5, motionZ);
            }
            this.m_146870_();
        }
    }

    public boolean isTooCold() {
        Holder biome = this.m_9236_().m_204166_(this.m_20183_());
        this.m_9236_().m_46465_();
        if (((Biome)biome.m_203334_()).m_198906_(this.m_20183_())) {
            return this.m_213856_() < 0.5f;
        }
        return this.m_213856_() < 0.75f;
    }

    public void m_6074_() {
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.m_9236_().f_46443_ && amount > 0.0f && this.m_6084_()) {
            ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.m_20185_() + 0.5, this.m_20186_() + 1.0, this.m_20189_() + 0.5, new ItemStack((ItemLike)this.getPrehistoricEntityInfo().eggItem), 0.0, 0.1, 0.0);
            this.m_9236_().m_7967_((Entity)itemEntity);
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12019_, SoundSource.NEUTRAL, 0.2f, ((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.7f + 1.0f) * 2.0f);
            this.m_6074_();
        }
        return super.m_6469_(source, amount);
    }

    @NotNull
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player.m_150109_().m_36056_().m_41619_() && !player.m_150110_().f_35937_ && player.m_150109_().m_36054_(new ItemStack((ItemLike)this.getPrehistoricEntityInfo().eggItem))) {
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12019_, SoundSource.NEUTRAL, 0.2f, ((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.7f + 1.0f) * 2.0f);
            this.m_6074_();
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)this.prehistoricEntityInfo.eggItem);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("HatchingTime", this.getHatchingTime());
        compound.m_128359_("PrehistoricEntityInfo", this.getPrehistoricEntityInfo().name());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setHatchingTime(compound.m_128451_("HatchingTime"));
        this.setPrehistoricEntityInfo(PrehistoricEntityInfo.valueOf(compound.m_128461_("PrehistoricEntityInfo")));
    }

    public int getHatchingTime() {
        return (Integer)this.f_19804_.m_135370_(HATCHING_TIME);
    }

    public void setHatchingTime(int time) {
        this.f_19804_.m_135381_(HATCHING_TIME, (Object)time);
    }

    public boolean isGoldenEgg() {
        return (Boolean)this.f_19804_.m_135370_(GOLDEN_EGG);
    }

    public void setGoldenEgg(boolean goldenEgg) {
        this.f_19804_.m_135381_(GOLDEN_EGG, (Object)goldenEgg);
    }

    public int getTotalHatchingTime() {
        return this.isGoldenEgg() ? 2700 : 3000;
    }

    public PrehistoricEntityInfo getPrehistoricEntityInfo() {
        return this.prehistoricEntityInfo;
    }

    public void setPrehistoricEntityInfo(PrehistoricEntityInfo prehistoricEntityInfo) {
        this.prehistoricEntityInfo = prehistoricEntityInfo;
    }

    public void setScaleOverride(float scaleOverride) {
        this.scaleOverride = scaleOverride;
    }

    public float getScaleOverride() {
        return this.scaleOverride;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkManager.createAddEntityPacket((Entity)this);
    }

    public void saveAdditionalSpawnData(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.getPrehistoricEntityInfo());
    }

    public void loadAdditionalSpawnData(FriendlyByteBuf buf) {
        try {
            this.setPrehistoricEntityInfo((PrehistoricEntityInfo)buf.m_130066_(PrehistoricEntityInfo.class));
        }
        catch (IndexOutOfBoundsException e) {
            LOGGER.error("Dinosaur egg {} has invalid dinosaur specified: {}", (Object)this.f_19821_, (Object)e);
            this.setPrehistoricEntityInfo(PrehistoricEntityInfo.DODO);
        }
    }

    @NotNull
    public Iterable<ItemStack> m_6168_() {
        return ARMOR;
    }

    @NotNull
    public ItemStack m_6844_(EquipmentSlot slot) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot slot, ItemStack stack) {
    }

    @NotNull
    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }
}

