/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.base;

import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationCategory;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationHolder;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationLogic;
import com.github.teamfossilsarcheology.fossil.entity.animation.ServerAnimationInfo;
import java.util.Map;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;

public interface PrehistoricAnimatable<T extends Mob>
extends GeoEntity {
    default public AnimationInfo getRandomAnimation(AnimationCategory category) {
        AnimationHolder animations = this.getAnimations().get(category);
        return animations.getRandomAnimation((Mob)this);
    }

    public Map<AnimationCategory, AnimationHolder> getAnimations();

    public Map<String, ? extends AnimationInfo> getAllAnimations();

    public AnimationInfo getAnimation(AnimationCategory var1);

    default public AnimationInfo getAnimation(String name) {
        return this.getAllAnimations().get(name);
    }

    public Map<String, ServerAnimationInfo> getServerAnimationInfos();

    public AnimationLogic<T> getAnimationLogic();

    @NotNull
    default public AnimationInfo nextEatingAnimation() {
        return this.getAnimation(AnimationCategory.EAT);
    }

    @NotNull
    default public AnimationInfo nextIdleAnimation() {
        return this.getAnimation(AnimationCategory.IDLE);
    }

    @NotNull
    default public AnimationInfo nextSittingAnimation() {
        return this.getAnimation(AnimationCategory.SIT);
    }

    @NotNull
    default public AnimationInfo nextSleepingAnimation() {
        return this.getAnimation(AnimationCategory.SLEEP);
    }

    @NotNull
    default public AnimationInfo nextSprintingAnimation() {
        return this.getAnimation(AnimationCategory.SPRINT);
    }

    @NotNull
    default public AnimationInfo nextSwimmingAnimation() {
        return this.getAnimation(AnimationCategory.SWIM);
    }

    @NotNull
    default public AnimationInfo nextSwimFastAnimation() {
        return this.getAnimation(AnimationCategory.SWIM_FAST);
    }

    @NotNull
    default public AnimationInfo nextWalkingAnimation() {
        return this.getAnimation(AnimationCategory.WALK);
    }
}

