/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.base;

import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricSwimming;
import com.github.teamfossilsarcheology.fossil.util.Gender;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public abstract class PrehistoricSwimmingBucketable
extends PrehistoricSwimming
implements Bucketable {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(PrehistoricSwimmingBucketable.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    protected PrehistoricSwimmingBucketable(EntityType<? extends Prehistoric> entityType, Level level, ResourceLocation animationLocation) {
        super(entityType, level, animationLocation);
    }

    protected PrehistoricSwimmingBucketable(EntityType<? extends Prehistoric> entityType, Level level) {
        super(entityType, level);
    }

    @NotNull
    public ItemStack m_28282_() {
        return new ItemStack((ItemLike)this.info().bucketItem);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        return Bucketable.m_148828_((Player)player, (InteractionHand)hand, (LivingEntity)this).orElse(super.m_6071_(player, hand));
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("FromBucket", this.m_27487_());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.m_27497_(compound.m_128471_("FromBucket"));
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean fromBucket) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)fromBucket);
    }

    public void m_6872_(ItemStack bucket) {
        Bucketable.m_148822_((Mob)this, (ItemStack)bucket);
        CompoundTag tag = bucket.m_41784_();
        if (this.m_21805_() != null) {
            tag.m_128362_("Owner", this.m_21805_());
        }
        this.moodSystem.saveAdditional(tag);
        tag.m_128405_("MatingCooldown", this.getMatingCooldown());
        tag.m_128405_("Hunger", this.getHunger());
        tag.m_128405_("Age", this.m_146764_());
        tag.m_128379_("AgingDisabled", this.isAgingDisabled());
        tag.m_128344_("Gender", (byte)this.getGender().ordinal());
    }

    public void m_142278_(CompoundTag tag) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)tag);
        if (tag.m_128441_("Owner")) {
            try {
                this.m_21816_(tag.m_128342_("Owner"));
                this.m_7105_(true);
            }
            catch (IllegalArgumentException e) {
                this.m_7105_(false);
            }
        }
        this.moodSystem.load(tag);
        if (tag.m_128441_("MatingCooldown")) {
            this.setMatingCooldown(tag.m_128451_("MatingCooldown"));
        }
        if (tag.m_128441_("Hunger")) {
            this.setHunger(tag.m_128451_("Hunger"));
        }
        if (tag.m_128441_("Age")) {
            this.setAgeInTicks(tag.m_128451_("Age"));
        }
        if (tag.m_128441_("AgingDisabled")) {
            this.setAgingDisabled(tag.m_128471_("AgingDisabled"));
        }
        if (tag.m_128425_("Gender", 1)) {
            this.setGender(Gender.values()[tag.m_128445_("Gender")]);
        }
    }

    @NotNull
    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }
}

