/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.system;

import com.github.teamfossilsarcheology.fossil.entity.animation.ServerAnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricLeaping;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.system.AISystem;
import com.github.teamfossilsarcheology.fossil.entity.util.Util;
import com.github.teamfossilsarcheology.fossil.network.SyncedEntityDataHelper;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.phys.Vec3;

public class LeapSystem
extends AISystem {
    public static final int JUMP_DISTANCE = 30;
    private final PrehistoricLeaping mob;
    private final SynchedEntityData entityData;
    private UUID loadedTarget;
    private LivingEntity target;
    private Vec3 blockTarget;
    private boolean leaping;
    private long jumpDelayTick = -1L;
    private long landingDelayTick = -1L;
    private long landingEndTick = -1L;
    private long lastLeapEndTick = -1L;

    public LeapSystem(PrehistoricLeaping mob) {
        super(mob);
        this.mob = mob;
        this.entityData = mob.m_20088_();
    }

    @Override
    public void serverTick() {
        ServerAnimationInfo animation;
        long currentTick = this.mob.m_9236_().m_46467_();
        if (this.mob.m_20202_() != null) {
            if (this.mob.m_20202_().m_20148_().equals(this.loadedTarget)) {
                this.setLeapTarget((LivingEntity)this.mob.m_20202_());
                this.loadedTarget = null;
            } else if (this.target == null && this.isAttackRiding()) {
                this.mob.m_8127_();
                this.stopAttackRiding();
            }
        }
        if (!this.isLeaping() && this.target != null && this.target.m_6084_()) {
            this.mob.m_21391_((Entity)this.target, 100.0f, 10.0f);
            if (this.mob.m_20280_((Entity)this.target) < 30.0) {
                this.startLeap();
                if (this.mob.hasLeapAnimation()) {
                    animation = (ServerAnimationInfo)this.mob.getLeapStartAnimation();
                    this.jumpDelayTick = (long)((double)currentTick + animation.actionDelay);
                } else {
                    this.jumpDelayTick = currentTick + 2L;
                }
                this.mob.m_20256_(Vec3.f_82478_);
            }
        }
        if (!this.isLeaping() && this.blockTarget != null && this.mob.m_20238_(this.blockTarget) < 30.0) {
            this.startLeap();
            if (this.mob.hasLeapAnimation()) {
                animation = (ServerAnimationInfo)this.mob.getLeapStartAnimation();
                this.jumpDelayTick = (long)((double)currentTick + animation.actionDelay);
            } else {
                this.jumpDelayTick = currentTick + 2L;
            }
            this.mob.m_20256_(Vec3.f_82478_);
        }
        if (this.isLeaping()) {
            if (this.target == null && this.blockTarget == null) {
                this.stopLeap();
            }
            if (this.target != null && (this.target.m_20160_() && this.mob.m_20202_() != this.target || this.target.m_21224_())) {
                if (this.jumpDelayTick != -1L) {
                    this.blockTarget = this.target.m_20182_();
                }
                this.setAttackRiding(false);
                this.setLeapTarget(null);
            }
            if (currentTick == this.jumpDelayTick) {
                Vec3 offset;
                double y;
                if (this.target != null) {
                    y = Math.min(this.target.m_20186_() + (double)this.target.m_20206_() - this.mob.m_20186_(), 5.0);
                    offset = Util.directionVecTo((Entity)this.mob, (Entity)this.target).m_82541_();
                    offset = offset.m_82520_(this.target.m_20184_().f_82479_, 0.0, this.target.m_20184_().f_82481_);
                } else if (this.blockTarget != null) {
                    y = Math.min(this.blockTarget.f_82480_ - this.mob.m_20186_(), 5.0);
                    offset = this.blockTarget.m_82546_(this.mob.m_20182_()).m_82541_();
                } else {
                    y = 0.0;
                    offset = Vec3.f_82478_;
                }
                this.mob.m_20334_(offset.f_82479_, -0.027 * Math.pow(y, 2.0) + 0.262 * y + 0.183, offset.f_82481_);
                this.setLeapStarted(false);
                this.setLeapFlying(true);
                this.landingDelayTick = this.jumpDelayTick + 5L;
                this.jumpDelayTick = -1L;
            }
            if (this.mob.m_20096_() && this.landingDelayTick != -1L && this.landingDelayTick <= currentTick) {
                if (this.mob.hasLeapAnimation()) {
                    ServerAnimationInfo animation2 = (ServerAnimationInfo)this.mob.getLandAnimation();
                    this.landingEndTick = (long)((double)currentTick + animation2.animation.length());
                } else {
                    this.landingEndTick = currentTick + 2L;
                }
                this.landingDelayTick = -1L;
                this.setLeapFlying(false);
                this.setLanding(true);
            }
            if (this.landingEndTick != -1L && this.landingEndTick <= currentTick) {
                this.setLanding(false);
                this.setLeaping(false);
                this.landingEndTick = -1L;
                this.setBlockLeapTarget(null);
                this.setLeapTarget(null);
            }
            if (this.isAttackRiding() && this.target != null) {
                if (this.mob.f_19797_ % 20 == 0) {
                    this.target.m_6469_(this.mob.m_269291_().m_269333_((LivingEntity)this.mob), (float)this.mob.m_21133_(Attributes.f_22281_));
                }
                if (this.target.m_21224_()) {
                    this.stopAttackRiding();
                }
            }
            if (!(this.isLeapFlying() || this.hasLeapStarted() || this.isLanding() || this.isAttackRiding())) {
                this.setLeaping(false);
            }
        }
    }

    public void startLeap() {
        this.jumpDelayTick = -1L;
        this.landingDelayTick = -1L;
        this.landingEndTick = -1L;
        this.setLeapFlying(false);
        this.setLeaping(true);
        this.setLeapStarted(true);
    }

    public void stopLeap() {
        this.setLeaping(false);
        this.setLeapFlying(false);
        this.setLeapStarted(false);
        this.setLanding(false);
        this.setLeapTarget(null);
    }

    public boolean isLeapingAt(Entity entity) {
        return this.target == entity && this.isLeapFlying();
    }

    public void tryAttackRiding(Entity target) {
        if (target.m_20197_().isEmpty() && this.mob.hasLeapAnimation()) {
            this.setLeapFlying(false);
            this.setAttackRiding(true);
        } else {
            target.m_6469_(this.mob.m_269291_().m_269333_((LivingEntity)this.mob), (float)this.mob.m_21133_(Attributes.f_22281_));
        }
    }

    public void stopAttackRiding() {
        this.setLeaping(false);
        this.setAttackRiding(false);
        this.setLeapTarget(null);
    }

    public boolean isLeaping() {
        return this.leaping;
    }

    private void setLeaping(boolean leaping) {
        this.leaping = leaping;
    }

    public boolean isLeapFlying() {
        return (Boolean)this.entityData.m_135370_(PrehistoricLeaping.LEAP_FLYING);
    }

    private void setLeapFlying(boolean leapFlying) {
        this.entityData.m_135381_(PrehistoricLeaping.LEAP_FLYING, (Object)leapFlying);
    }

    public void setBlockLeapTarget(Vec3 target) {
        this.blockTarget = target;
    }

    public void setLeapTarget(LivingEntity target) {
        this.target = target;
        this.entityData.m_135381_(PrehistoricLeaping.LEAP_TARGET_ID, (Object)(target == null ? -1 : target.m_19879_()));
        ((SyncedEntityDataHelper)this.entityData).fossilsArcheologyRevival$markDirty(PrehistoricLeaping.LEAP_TARGET_ID);
    }

    public boolean isLanding() {
        return (Boolean)this.entityData.m_135370_(PrehistoricLeaping.LEAP_LANDING);
    }

    private void setLanding(boolean landing) {
        this.entityData.m_135381_(PrehistoricLeaping.LEAP_LANDING, (Object)landing);
    }

    public boolean isAttackRiding() {
        return (Boolean)this.entityData.m_135370_(PrehistoricLeaping.LEAP_RIDING);
    }

    public void setAttackRiding(boolean attackRiding) {
        if (((Boolean)this.entityData.m_135370_(PrehistoricLeaping.LEAP_RIDING)).booleanValue() && !attackRiding) {
            this.lastLeapEndTick = this.mob.m_9236_().m_46467_();
        }
        this.entityData.m_135381_(PrehistoricLeaping.LEAP_RIDING, (Object)attackRiding);
    }

    public long getLastLeapEndTick() {
        return this.lastLeapEndTick;
    }

    public void setLastLeapEndTick(long lastLeapEndTick) {
        this.lastLeapEndTick = lastLeapEndTick;
    }

    public boolean hasLeapStarted() {
        return (Boolean)this.entityData.m_135370_(PrehistoricLeaping.LEAP_STARTED);
    }

    public void setLeapStarted(boolean value) {
        this.entityData.m_135381_(PrehistoricLeaping.LEAP_STARTED, (Object)value);
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        tag.m_128379_("AttackRiding", this.isAttackRiding());
        if (this.target != null) {
            tag.m_128362_("AttackRidingVehicle", this.target.m_20148_());
        }
    }

    @Override
    public void load(CompoundTag tag) {
        if (tag.m_128471_("AttackRiding") && tag.m_128441_("AttackRidingVehicle")) {
            this.setAttackRiding(true);
            this.setLeaping(true);
            this.loadedTarget = tag.m_128342_("AttackRidingVehicle");
        }
    }
}

