/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.system;

import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.OrderType;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfoAI;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.system.AISystem;
import net.minecraft.nbt.CompoundTag;

public class SleepSystem
extends AISystem {
    private static final int MAX_SLEEP_DURATION = 6000;
    private boolean sleepForced;
    private int ticksSlept;
    private int cathermalSleepCooldown;

    public SleepSystem(Prehistoric mob) {
        super(mob);
        this.cathermalSleepCooldown = 5000 + this.mob.m_217043_().m_188503_(3000);
    }

    @Override
    public void serverTick() {
        if (this.cathermalSleepCooldown > 0) {
            --this.cathermalSleepCooldown;
        }
        this.trySleeping();
        if (this.mob.m_5803_() && !this.sleepForced) {
            ++this.ticksSlept;
            if (this.ticksSlept > 100 && this.mob.m_217043_().m_188503_(100) == 0 && !this.wantsToSleep()) {
                this.setSleeping(false);
            }
            if (this.ticksSlept > 6000) {
                this.setSleeping(false);
            }
            if (this.mob.f_19797_ % 10 == 0 && !this.canSleep()) {
                this.setSleeping(false);
            }
        }
    }

    protected void trySleeping() {
        if (this.mob.m_5803_()) {
            return;
        }
        if (this.mob.aiActivityType() == PrehistoricEntityInfoAI.Activity.BOTH) {
            if (this.mob.m_217043_().m_188503_(1200) == 0 && this.wantsToSleep() && this.canSleep()) {
                this.setSleeping(true);
                this.ticksSlept = 0;
            }
        } else if (this.mob.aiActivityType() != PrehistoricEntityInfoAI.Activity.NO_SLEEP && this.mob.m_217043_().m_188503_(200) == 0 && this.wantsToSleep() && this.canSleep()) {
            this.setSleeping(true);
            this.ticksSlept = 0;
        }
    }

    protected boolean canSleep() {
        if (this.isDisabled() || this.mob.hasTarget() || this.mob.m_21188_() != null || this.mob.getCurrentOrder() == OrderType.FOLLOW || this.mob.m_20160_()) {
            return false;
        }
        if (this.mob.isDeadlyHungry()) {
            return false;
        }
        if (this.mob.aiMovingType() == PrehistoricEntityInfoAI.Moving.AQUATIC) {
            return this.mob.m_20069_();
        }
        if (this.mob.aiMovingType() == PrehistoricEntityInfoAI.Moving.SEMI_AQUATIC) {
            return this.mob.m_20069_() || this.mob.m_20096_();
        }
        return this.mob.m_20096_() && !this.mob.m_20069_();
    }

    public boolean wantsToSleep() {
        if (this.mob.aiActivityType() == PrehistoricEntityInfoAI.Activity.DIURNAL) {
            return !this.mob.m_9236_().m_46461_();
        }
        if (this.mob.aiActivityType() == PrehistoricEntityInfoAI.Activity.NOCTURNAL) {
            if (!this.mob.m_9236_().m_46461_()) {
                return false;
            }
            if (this.mob.aiMovingType() == PrehistoricEntityInfoAI.Moving.AQUATIC || this.mob.aiMovingType() == PrehistoricEntityInfoAI.Moving.SEMI_AQUATIC) {
                return this.mob.m_20069_() || !this.mob.m_9236_().m_45527_(this.mob.m_20183_().m_7494_());
            }
            return !this.mob.m_9236_().m_45527_(this.mob.m_20183_().m_7494_());
        }
        return this.mob.aiActivityType() == PrehistoricEntityInfoAI.Activity.BOTH && this.ticksSlept <= 4000 && this.cathermalSleepCooldown == 0;
    }

    public void setSleepForced(boolean sleepForced) {
        this.sleepForced = sleepForced;
    }

    public void setSleeping(boolean sleeping) {
        this.mob.m_20088_().m_135381_(Prehistoric.SLEEPING, (Object)sleeping);
        if (!sleeping) {
            this.cathermalSleepCooldown = 10000 + this.mob.m_217043_().m_188503_(6000);
            this.mob.updatePose();
        } else {
            this.ticksSlept = 0;
            this.mob.updatePose();
            this.mob.m_21573_().m_26573_();
            this.mob.m_20334_(0.0, this.mob.m_20184_().f_82480_, 0.0);
            this.mob.f_19812_ = true;
        }
    }

    @Override
    public void saveAdditional(CompoundTag tag) {
        tag.m_128379_("Sleeping", this.mob.m_5803_());
        tag.m_128405_("TicksSlept", this.ticksSlept);
        tag.m_128405_("CathermalTimer", this.cathermalSleepCooldown);
    }

    @Override
    public void load(CompoundTag tag) {
        this.setSleeping(tag.m_128471_("Sleeping"));
        this.ticksSlept = tag.m_128451_("TicksSlept");
        this.cathermalSleepCooldown = tag.m_128451_("CathermalTimer");
    }
}

