/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.food;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.client.ResourceLoader;
import com.github.teamfossilsarcheology.fossil.food.Diet;
import com.github.teamfossilsarcheology.fossil.food.FoodType;
import com.github.teamfossilsarcheology.fossil.network.S2CSyncFoodMappingsMessage;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class FoodMappingsManager
extends ResourceLoader<MapPair> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final FoodMappingsManager INSTANCE = new FoodMappingsManager();
    private Map<FoodType, Set<TagKey<Item>>> itemTags = ImmutableMap.of();
    private Map<FoodType, Set<TagKey<EntityType<?>>>> entityTags = ImmutableMap.of();
    private Map<FoodType, Map<Item, Integer>> itemValues = ImmutableMap.of();
    private Map<FoodType, Map<EntityType<?>, Integer>> entityValues = ImmutableMap.of();
    private Map<Diet, TreeSet<Item>> items;
    private Set<EntityType<?>> entities = ImmutableSet.of();
    private final List<Consumer<FoodMappingsManager>> listeners = new ArrayList<Consumer<FoodMappingsManager>>();

    public FoodMappingsManager() {
        super(PackType.SERVER_DATA, "food", "json");
    }

    @NotNull
    protected MapPair prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        ImmutableMap.Builder itemTagsBuilder = new ImmutableMap.Builder();
        ImmutableMap.Builder entityTagsBuilder = new ImmutableMap.Builder();
        ImmutableMap.Builder itemBuilder = new ImmutableMap.Builder();
        ImmutableMap.Builder entityBuilder = new ImmutableMap.Builder();
        ImmutableSet.Builder setBuilder = new ImmutableSet.Builder();
        for (FoodType type : FoodType.values()) {
            ObjectOpenHashSet itemTags = new ObjectOpenHashSet();
            ObjectOpenHashSet entityTags = new ObjectOpenHashSet();
            Object2IntOpenHashMap innerItemBuilder = new Object2IntOpenHashMap();
            Object2IntOpenHashMap innerEntityBuilder = new Object2IntOpenHashMap();
            for (Map.Entry<ResourceLocation, Resource> fileEntry : this.listResources(resourceManager, type.name().toLowerCase() + ".json").entrySet()) {
                try {
                    InputStream inputStream = fileEntry.getValue().m_215507_();
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                        JsonObject object;
                        JsonArray entries;
                        JsonElement jsonElement = (JsonElement)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonElement.class);
                        JsonObject root = jsonElement.getAsJsonObject();
                        if (root.has("items")) {
                            entries = root.get("items").getAsJsonArray();
                            for (JsonElement entry : entries) {
                                object = entry.getAsJsonObject();
                                if (object.has("item")) {
                                    BuiltInRegistries.f_257033_.m_6612_(new ResourceLocation(object.get("item").getAsString())).ifPresent(arg_0 -> FoodMappingsManager.lambda$prepare$0(object, (Map)innerItemBuilder, type, arg_0));
                                    continue;
                                }
                                if (!object.has("tag")) continue;
                                itemTags.add(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(object.get("tag").getAsString())));
                            }
                        }
                        if (!root.has("entities")) continue;
                        entries = root.get("entities").getAsJsonArray();
                        for (JsonElement entry : entries) {
                            object = entry.getAsJsonObject();
                            if (object.has("entity")) {
                                BuiltInRegistries.f_256780_.m_6612_(new ResourceLocation(object.get("entity").getAsString())).ifPresent(arg_0 -> FoodMappingsManager.lambda$prepare$1(setBuilder, object, (Map)innerEntityBuilder, arg_0));
                                continue;
                            }
                            if (!object.has("tag")) continue;
                            entityTags.add(TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation(object.get("tag").getAsString())));
                        }
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    FossilMod.LOGGER.error("Failed to load food values in {}: {}", (Object)fileEntry.getKey(), (Object)e);
                    throw new RuntimeException(e);
                }
            }
            itemTagsBuilder.put((Object)type, (Object)itemTags);
            entityTagsBuilder.put((Object)type, (Object)entityTags);
            itemBuilder.put((Object)type, (Object)innerItemBuilder);
            entityBuilder.put((Object)type, (Object)innerEntityBuilder);
        }
        return new MapPair((Map<FoodType, Map<Item, Integer>>)itemBuilder.build(), (Map<FoodType, Map<EntityType<?>, Integer>>)entityBuilder.build(), (Set<EntityType<?>>)setBuilder.build(), (Map<FoodType, Set<TagKey<Item>>>)itemTagsBuilder.build(), (Map<FoodType, Set<TagKey<EntityType<?>>>>)entityTagsBuilder.build());
    }

    protected void apply(MapPair mapPair, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.itemValues = mapPair.items;
        this.entityValues = mapPair.entities;
        this.entities = mapPair.allEntities;
        this.itemTags = mapPair.itemTags;
        this.entityTags = mapPair.entityTags;
        Function<Map, Integer> f = map -> map.values().stream().map(m -> m.keySet().size()).reduce(Integer::sum).orElse(0);
        FossilMod.LOGGER.info("Loaded food values: (items: {}) (entities: {}, {}) (Tags: {}, {})", (Object)this.itemValues.values().stream().mapToInt(m -> m.keySet().size()).sum(), (Object)this.entityValues.values().stream().mapToInt(m -> m.keySet().size()).sum(), (Object)this.entities.size(), (Object)this.itemTags.values().stream().mapToInt(Collection::size).sum(), (Object)this.entityTags.values().stream().mapToInt(Collection::size).sum());
        this.listeners.forEach(listener -> listener.accept(this));
        this.generateCache();
    }

    public void listen(Consumer<FoodMappingsManager> listener) {
        this.listeners.add(listener);
    }

    public void replaceValues(Map<FoodType, Map<Item, Integer>> itemValues, Map<FoodType, Map<EntityType<?>, Integer>> entityValues, Set<EntityType<?>> entities) {
        FossilMod.LOGGER.info("Replacing client food values: (items: {}) (entities: {}, {})", (Object)itemValues.values().stream().mapToInt(m -> m.keySet().size()).sum(), (Object)entityValues.values().stream().mapToInt(m -> m.keySet().size()).sum(), (Object)entities.size());
        this.itemValues = itemValues;
        this.entityValues = entityValues;
        this.entities = entities;
        this.generateCache();
    }

    private void generateCache() {
        Comparator<Item> byId = Comparator.comparingInt(item -> Item.m_41393_((Item)item.m_5456_()));
        Supplier<TreeSet> set = () -> new TreeSet(byId);
        this.items = Arrays.stream(Diet.values()).collect(Collectors.toMap(Function.identity(), diet -> (TreeSet)diet.flags().stream().flatMap(type -> this.itemValues.get(type).keySet().stream()).collect(Collectors.toCollection(set))));
    }

    public Map<Item, Integer> getItemValues(FoodType type) {
        return this.itemValues.get((Object)type);
    }

    public Map<EntityType<?>, Integer> getEntityValues(FoodType type) {
        return this.entityValues.get((Object)type);
    }

    public boolean hasEntityEntry(EntityType<?> entityType) {
        return this.entities.contains(entityType);
    }

    public void addItem(FoodType type, Item item, int value) {
        this.itemValues.get((Object)type).put(item, value);
    }

    public void addEntity(FoodType type, EntityType<?> entityType, int value) {
        this.entityValues.get((Object)type).put(entityType, value);
    }

    public Map<Diet, TreeSet<Item>> getItemCache() {
        if (this.items == null) {
            this.generateCache();
        }
        return this.items;
    }

    public void addMeat(EntityType<?> entity, int food) {
        this.addEntity(FoodType.MEAT, entity, food);
    }

    public void addMeat(ItemLike itemLike) {
        int food = itemLike.m_5456_().m_41473_() != null ? itemLike.m_5456_().m_41473_().m_38744_() * 7 : 20;
        this.addMeat(itemLike, food);
    }

    public void addMeat(ItemLike itemLike, int food) {
        this.addItem(FoodType.MEAT, itemLike.m_5456_(), food);
    }

    public void addFish(EntityType<?> entity, int food) {
        this.addEntity(FoodType.FISH, entity, food);
    }

    public void addFish(Item item) {
        int food = item.m_41473_() != null ? item.m_41473_().m_38744_() * 7 : 10;
        this.addFish(item, food);
    }

    public void addFish(Item item, int food) {
        this.addItem(FoodType.FISH, item, food);
    }

    public void addEgg(Item item) {
        int food = item.m_41473_() != null ? item.m_41473_().m_38744_() * 7 : 10;
        this.addEgg(item, food);
    }

    public void addEgg(Item item, int food) {
        this.addItem(FoodType.EGG, item, food);
    }

    public void addPlant(Block block, int food) {
        this.addItem(FoodType.PLANT, block.m_5456_(), food);
    }

    public void addPlant(Item item) {
        int food = item.m_41473_() != null ? item.m_41473_().m_38744_() * 5 : 17;
        this.addPlant(item, food);
    }

    public void addPlant(Item item, int food) {
        this.addItem(FoodType.PLANT, item, food);
    }

    private void loadTags() {
        ImmutableMap.Builder itemBuilder = new ImmutableMap.Builder();
        ImmutableMap.Builder entityBuilder = new ImmutableMap.Builder();
        ImmutableSet.Builder setBuilder = new ImmutableSet.Builder();
        setBuilder.addAll(this.entities);
        for (FoodType type : FoodType.values()) {
            Object2IntOpenHashMap innerItemBuilder = new Object2IntOpenHashMap();
            Object2IntOpenHashMap innerEntityBuilder = new Object2IntOpenHashMap();
            innerItemBuilder.putAll(this.itemValues.get((Object)type));
            innerEntityBuilder.putAll(this.entityValues.get((Object)type));
            for (TagKey<Item> tagKey : this.itemTags.get((Object)type)) {
                for (Holder itemHolder : BuiltInRegistries.f_257033_.m_206058_(tagKey)) {
                    Item item = (Item)itemHolder.m_203334_();
                    if (item.m_41473_() != null) {
                        innerItemBuilder.put(item, item.m_41473_().m_38744_() * type.multiplier());
                        continue;
                    }
                    innerItemBuilder.put(item, type.fallback());
                }
            }
            for (TagKey<Item> tagKey : this.entityTags.get((Object)type)) {
                for (Holder entityHolder : BuiltInRegistries.f_256780_.m_206058_(tagKey)) {
                    EntityType entityType = (EntityType)entityHolder.m_203334_();
                    setBuilder.add((Object)entityType);
                    innerEntityBuilder.put(entityType, 0);
                }
            }
            itemBuilder.put((Object)type, (Object)innerItemBuilder);
            entityBuilder.put((Object)type, (Object)innerEntityBuilder);
        }
        this.itemValues = itemBuilder.build();
        this.entityValues = entityBuilder.build();
        this.entities = setBuilder.build();
        this.generateCache();
    }

    public S2CSyncFoodMappingsMessage message() {
        this.loadTags();
        return new S2CSyncFoodMappingsMessage(this.itemValues, this.entityValues, this.entities);
    }

    private static /* synthetic */ void lambda$prepare$1(ImmutableSet.Builder setBuilder, JsonObject object, Map innerEntityBuilder, EntityType entityType) {
        setBuilder.add((Object)entityType);
        if (object.has("value")) {
            innerEntityBuilder.put(entityType, object.get("value").getAsInt());
        } else {
            innerEntityBuilder.put(entityType, 0);
        }
    }

    private static /* synthetic */ void lambda$prepare$0(JsonObject object, Map innerItemBuilder, FoodType type, Item item) {
        if (object.has("value")) {
            innerItemBuilder.put(item, object.get("value").getAsInt());
        } else if (item.m_41473_() != null) {
            innerItemBuilder.put(item, item.m_41473_().m_38744_() * type.multiplier());
        } else {
            innerItemBuilder.put(item, type.fallback());
        }
    }

    protected record MapPair(Map<FoodType, Map<Item, Integer>> items, Map<FoodType, Map<EntityType<?>, Integer>> entities, Set<EntityType<?>> allEntities, Map<FoodType, Set<TagKey<Item>>> itemTags, Map<FoodType, Set<TagKey<EntityType<?>>>> entityTags) {
    }
}

