/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.forge.tests;

import com.github.teamfossilsarcheology.fossil.block.ModBlocks;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.AnalyzerBlock;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.CultureVatBlock;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.SifterBlock;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.VaseBlock;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.WorktableBlock;
import com.github.teamfossilsarcheology.fossil.block.entity.AnalyzerBlockEntity;
import com.github.teamfossilsarcheology.fossil.block.entity.CultureVatBlockEntity;
import com.github.teamfossilsarcheology.fossil.block.entity.SifterBlockEntity;
import com.github.teamfossilsarcheology.fossil.block.entity.WorktableBlockEntity;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.forge.tests.RecipeTests;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestAssertException;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.gametest.GameTestHolder;
import net.minecraftforge.gametest.PrefixGameTestTemplate;

@PrefixGameTestTemplate(value=false)
@GameTestHolder(value="fossil")
public class HopperTests {
    private static final BlockPos MACHINE_POS = new BlockPos(1, 2, 1);
    private static final Direction[] directions = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};

    private static void assertContainerContainsItemInSlot(GameTestHelper helper, BlockPos pos, int slot, Item item, int count) {
        BlockPos blockPos = helper.m_177449_(pos);
        BlockEntity blockEntity = helper.m_177100_().m_7702_(blockPos);
        if (blockEntity instanceof BaseContainerBlockEntity) {
            BaseContainerBlockEntity containerBlockEntity = (BaseContainerBlockEntity)blockEntity;
            if (!containerBlockEntity.m_8020_(slot).m_150930_(item)) {
                throw new GameTestAssertException("Container slot contains wrong item. Expected: " + item + " but got: " + containerBlockEntity.m_8020_(slot));
            }
            if (containerBlockEntity.m_8020_(slot).m_41613_() != count) {
                throw new GameTestAssertException("Container slot contains wrong amount. Expected: " + count + " but got: " + containerBlockEntity.m_8020_(slot).m_41613_());
            }
        }
    }

    @GameTest(m_177043_="culture_vat", m_177046_="culture_vat_hopper", m_177042_=11)
    public static void cultureVatHopperFuel(GameTestHelper helper) {
        BlockEntity blockEntity = RecipeTests.getBlockEntity(MACHINE_POS, helper, CultureVatBlock.class);
        if (blockEntity instanceof CultureVatBlockEntity) {
            CultureVatBlockEntity cultureVatEntity = (CultureVatBlockEntity)blockEntity;
            helper.m_177440_(MACHINE_POS);
            for (int i = 0; i < 4; ++i) {
                BlockPos sidePos = MACHINE_POS.m_121945_(directions[i]);
                helper.m_177252_(sidePos, (BlockState)Blocks.f_50332_.m_49966_().m_61124_((Property)HopperBlock.f_54021_, (Comparable)directions[i].m_122424_()));
                BlockEntity hopper = RecipeTests.getBlockEntity(sidePos, helper, HopperBlock.class);
                if (!(hopper instanceof HopperBlockEntity)) continue;
                HopperBlockEntity hopperBlockEntity = (HopperBlockEntity)hopper;
                Item fuelItem = (Item)ModItems.BIO_GOO.get();
                helper.m_177127_((long)i * 2L, () -> hopperBlockEntity.m_6836_(0, new ItemStack((ItemLike)fuelItem)));
                int expectedCount = i + 1;
                helper.m_177127_((long)i * 2L + 1L, () -> HopperTests.assertContainerContainsItemInSlot(helper, MACHINE_POS, 1, fuelItem, expectedCount));
            }
            helper.m_177127_(10L, () -> ((GameTestHelper)helper).m_177412_());
        }
    }

    @GameTest(m_177043_="culture_vat", m_177046_="culture_vat_hopper", m_177042_=5)
    public static void cultureVatHopperOutput(GameTestHelper helper) {
        BlockEntity blockEntity = RecipeTests.getBlockEntity(MACHINE_POS, helper, CultureVatBlock.class);
        if (blockEntity instanceof CultureVatBlockEntity) {
            CultureVatBlockEntity cultureVatEntity = (CultureVatBlockEntity)blockEntity;
            BlockPos downPos = MACHINE_POS.m_7495_();
            helper.m_177245_(downPos, Blocks.f_50332_);
            helper.m_177440_(downPos);
            BlockEntity hopper = RecipeTests.getBlockEntity(downPos, helper, HopperBlock.class);
            if (hopper instanceof HopperBlockEntity) {
                cultureVatEntity.m_6836_(2, new ItemStack((ItemLike)PrehistoricEntityInfo.ALLOSAURUS.eggItem));
                helper.m_177127_(1L, () -> helper.m_177242_(downPos, PrehistoricEntityInfo.ALLOSAURUS.eggItem));
                helper.m_177127_(4L, () -> ((GameTestHelper)helper).m_177412_());
            }
        }
    }

    @GameTest(m_177043_="culture_vat", m_177046_="culture_vat_hopper", m_177042_=5)
    public static void cultureVatHopperInput(GameTestHelper helper) {
        BlockEntity blockEntity = RecipeTests.getBlockEntity(MACHINE_POS, helper, CultureVatBlock.class);
        if (blockEntity instanceof CultureVatBlockEntity) {
            helper.m_177440_(MACHINE_POS);
            BlockPos upPos = MACHINE_POS.m_7494_();
            helper.m_177245_(upPos, Blocks.f_50332_);
            BlockEntity hopper = RecipeTests.getBlockEntity(upPos, helper, HopperBlock.class);
            if (hopper instanceof HopperBlockEntity) {
                HopperBlockEntity hopperBlockEntity = (HopperBlockEntity)hopper;
                hopperBlockEntity.m_6836_(0, new ItemStack((ItemLike)PrehistoricEntityInfo.ALLOSAURUS.dnaItem));
                helper.m_177127_(1L, () -> HopperTests.assertContainerContainsItemInSlot(helper, MACHINE_POS, 0, PrehistoricEntityInfo.ALLOSAURUS.dnaItem, 1));
                helper.m_177127_(2L, () -> ((GameTestHelper)helper).m_177412_());
            }
        }
    }

    @GameTest(m_177043_="worktable", m_177046_="worktable_hopper", m_177042_=11)
    public static void worktableHopperFuel(GameTestHelper helper) {
        BlockEntity blockEntity = RecipeTests.getBlockEntity(MACHINE_POS, helper, WorktableBlock.class);
        if (blockEntity instanceof WorktableBlockEntity) {
            WorktableBlockEntity worktableEntity = (WorktableBlockEntity)blockEntity;
            helper.m_177440_(MACHINE_POS);
            for (int i = 0; i < 4; ++i) {
                BlockPos sidePos = MACHINE_POS.m_121945_(directions[i]);
                helper.m_177252_(sidePos, (BlockState)Blocks.f_50332_.m_49966_().m_61124_((Property)HopperBlock.f_54021_, (Comparable)directions[i].m_122424_()));
                BlockEntity hopper = RecipeTests.getBlockEntity(sidePos, helper, HopperBlock.class);
                if (!(hopper instanceof HopperBlockEntity)) continue;
                HopperBlockEntity hopperBlockEntity = (HopperBlockEntity)hopper;
                Item fuelItem = (Item)ModItems.POTTERY_SHARD.get();
                helper.m_177127_((long)i * 2L, () -> hopperBlockEntity.m_6836_(0, new ItemStack((ItemLike)fuelItem)));
                int expectedCount = i + 1;
                helper.m_177127_((long)i * 2L + 1L, () -> HopperTests.assertContainerContainsItemInSlot(helper, MACHINE_POS, 1, fuelItem, expectedCount));
            }
            helper.m_177127_(10L, () -> ((GameTestHelper)helper).m_177412_());
        }
    }

    @GameTest(m_177043_="worktable", m_177046_="worktable_hopper", m_177042_=5)
    public static void worktableHopperOutput(GameTestHelper helper) {
        BlockEntity blockEntity = RecipeTests.getBlockEntity(MACHINE_POS, helper, WorktableBlock.class);
        if (blockEntity instanceof WorktableBlockEntity) {
            WorktableBlockEntity worktableEntity = (WorktableBlockEntity)blockEntity;
            BlockPos downPos = MACHINE_POS.m_7495_();
            helper.m_177245_(downPos, Blocks.f_50332_);
            helper.m_177440_(downPos);
            BlockEntity hopper = RecipeTests.getBlockEntity(downPos, helper, HopperBlock.class);
            if (hopper instanceof HopperBlockEntity) {
                worktableEntity.m_6836_(2, new ItemStack((ItemLike)ModBlocks.AMPHORA_VASE_RESTORED.get()));
                helper.m_177127_(1L, () -> helper.m_177242_(downPos, ((VaseBlock)((Object)((Object)ModBlocks.AMPHORA_VASE_RESTORED.get()))).m_5456_()));
                helper.m_177127_(4L, () -> ((GameTestHelper)helper).m_177412_());
            }
        }
    }

    @GameTest(m_177043_="worktable", m_177046_="worktable_hopper", m_177042_=5)
    public static void worktableHopperInput(GameTestHelper helper) {
        BlockEntity blockEntity = RecipeTests.getBlockEntity(MACHINE_POS, helper, WorktableBlock.class);
        if (blockEntity instanceof WorktableBlockEntity) {
            helper.m_177440_(MACHINE_POS);
            BlockPos upPos = MACHINE_POS.m_7494_();
            helper.m_177245_(upPos, Blocks.f_50332_);
            BlockEntity hopper = RecipeTests.getBlockEntity(upPos, helper, HopperBlock.class);
            if (hopper instanceof HopperBlockEntity) {
                HopperBlockEntity hopperBlockEntity = (HopperBlockEntity)hopper;
                hopperBlockEntity.m_6836_(0, new ItemStack((ItemLike)ModBlocks.AMPHORA_VASE_DAMAGED.get()));
                helper.m_177127_(1L, () -> HopperTests.assertContainerContainsItemInSlot(helper, MACHINE_POS, 0, ((VaseBlock)((Object)((Object)ModBlocks.AMPHORA_VASE_DAMAGED.get()))).m_5456_(), 1));
                helper.m_177127_(2L, () -> ((GameTestHelper)helper).m_177412_());
            }
        }
    }

    @GameTest(m_177043_="analyzer", m_177046_="analyzer_hopper", m_177042_=11)
    public static void analyzerHopperInputSide(GameTestHelper helper) {
        BlockEntity blockEntity = RecipeTests.getBlockEntity(MACHINE_POS, helper, AnalyzerBlock.class);
        if (blockEntity instanceof AnalyzerBlockEntity) {
            AnalyzerBlockEntity analyzerEntity = (AnalyzerBlockEntity)blockEntity;
            helper.m_177440_(MACHINE_POS);
            for (int i = 0; i < 4; ++i) {
                BlockPos sidePos = MACHINE_POS.m_121945_(directions[i]);
                helper.m_177252_(sidePos, (BlockState)Blocks.f_50332_.m_49966_().m_61124_((Property)HopperBlock.f_54021_, (Comparable)directions[i].m_122424_()));
                BlockEntity hopper = RecipeTests.getBlockEntity(sidePos, helper, HopperBlock.class);
                if (!(hopper instanceof HopperBlockEntity)) continue;
                HopperBlockEntity hopperBlockEntity = (HopperBlockEntity)hopper;
                Item inputItem = (Item)ModItems.BIO_FOSSIL.get();
                helper.m_177127_((long)i * 2L, () -> hopperBlockEntity.m_6836_(0, new ItemStack((ItemLike)inputItem)));
                int expectedCount = i + 1;
                helper.m_177127_((long)i * 2L + 1L, () -> HopperTests.assertContainerContainsItemInSlot(helper, MACHINE_POS, 0, inputItem, expectedCount));
            }
            helper.m_177127_(10L, () -> ((GameTestHelper)helper).m_177412_());
        }
    }

    @GameTest(m_177043_="analyzer", m_177046_="analyzer_hopper", m_177042_=5)
    public static void analyzerHopperInput(GameTestHelper helper) {
        BlockEntity blockEntity = RecipeTests.getBlockEntity(MACHINE_POS, helper, AnalyzerBlock.class);
        if (blockEntity instanceof AnalyzerBlockEntity) {
            helper.m_177440_(MACHINE_POS);
            BlockPos upPos = MACHINE_POS.m_7494_();
            helper.m_177245_(upPos, Blocks.f_50332_);
            BlockEntity hopper = RecipeTests.getBlockEntity(upPos, helper, HopperBlock.class);
            if (hopper instanceof HopperBlockEntity) {
                HopperBlockEntity hopperBlockEntity = (HopperBlockEntity)hopper;
                hopperBlockEntity.m_6836_(0, new ItemStack((ItemLike)ModItems.BIO_FOSSIL.get()));
                helper.m_177127_(1L, () -> HopperTests.assertContainerContainsItemInSlot(helper, MACHINE_POS, 0, (Item)ModItems.BIO_FOSSIL.get(), 1));
                helper.m_177127_(2L, () -> ((GameTestHelper)helper).m_177412_());
            }
        }
    }

    @GameTest(m_177043_="analyzer", m_177046_="analyzer_hopper", m_177042_=5)
    public static void analyzerHopperOutput(GameTestHelper helper) {
        BlockEntity blockEntity = RecipeTests.getBlockEntity(MACHINE_POS, helper, AnalyzerBlock.class);
        if (blockEntity instanceof AnalyzerBlockEntity) {
            AnalyzerBlockEntity analyzerEntity = (AnalyzerBlockEntity)blockEntity;
            BlockPos downPos = MACHINE_POS.m_7495_();
            helper.m_177245_(downPos, Blocks.f_50332_);
            helper.m_177440_(downPos);
            BlockEntity hopper = RecipeTests.getBlockEntity(downPos, helper, HopperBlock.class);
            if (hopper instanceof HopperBlockEntity) {
                analyzerEntity.m_6836_(9, new ItemStack((ItemLike)PrehistoricEntityInfo.ALLOSAURUS.dnaItem));
                helper.m_177127_(1L, () -> helper.m_177242_(downPos, PrehistoricEntityInfo.ALLOSAURUS.dnaItem));
                helper.m_177127_(4L, () -> ((GameTestHelper)helper).m_177412_());
            }
        }
    }

    @GameTest(m_177043_="sifter", m_177046_="sifter_hopper", m_177042_=11)
    public static void sifterHopperInputSide(GameTestHelper helper) {
        BlockEntity blockEntity = RecipeTests.getBlockEntity(MACHINE_POS, helper, SifterBlock.class);
        if (blockEntity instanceof SifterBlockEntity) {
            SifterBlockEntity sifterEntity = (SifterBlockEntity)blockEntity;
            helper.m_177440_(MACHINE_POS);
            for (int i = 0; i < 4; ++i) {
                BlockPos sidePos = MACHINE_POS.m_121945_(directions[i]);
                helper.m_177252_(sidePos, (BlockState)Blocks.f_50332_.m_49966_().m_61124_((Property)HopperBlock.f_54021_, (Comparable)directions[i].m_122424_()));
                BlockEntity hopper = RecipeTests.getBlockEntity(sidePos, helper, HopperBlock.class);
                if (!(hopper instanceof HopperBlockEntity)) continue;
                HopperBlockEntity hopperBlockEntity = (HopperBlockEntity)hopper;
                Item inputItem = Blocks.f_49992_.m_5456_();
                helper.m_177127_((long)i * 2L, () -> hopperBlockEntity.m_6836_(0, new ItemStack((ItemLike)inputItem)));
                int expectedCount = i + 1;
                helper.m_177127_((long)i * 2L + 1L, () -> HopperTests.assertContainerContainsItemInSlot(helper, MACHINE_POS, 0, inputItem, expectedCount));
            }
            helper.m_177127_(10L, () -> ((GameTestHelper)helper).m_177412_());
        }
    }

    @GameTest(m_177043_="sifter", m_177046_="sifter_hopper", m_177042_=5)
    public static void sifterHopperOutput(GameTestHelper helper) {
        BlockEntity blockEntity = RecipeTests.getBlockEntity(MACHINE_POS, helper, SifterBlock.class);
        if (blockEntity instanceof SifterBlockEntity) {
            SifterBlockEntity sifterEntity = (SifterBlockEntity)blockEntity;
            BlockPos downPos = MACHINE_POS.m_7495_();
            helper.m_177245_(downPos, Blocks.f_50332_);
            helper.m_177440_(downPos);
            BlockEntity hopper = RecipeTests.getBlockEntity(downPos, helper, HopperBlock.class);
            if (hopper instanceof HopperBlockEntity) {
                sifterEntity.m_6836_(1, new ItemStack((ItemLike)ModItems.BIO_FOSSIL.get()));
                helper.m_177127_(1L, () -> helper.m_177242_(downPos, (Item)ModItems.BIO_FOSSIL.get()));
                helper.m_177127_(4L, () -> ((GameTestHelper)helper).m_177412_());
            }
        }
    }

    @GameTest(m_177043_="sifter", m_177046_="sifter_hopper", m_177042_=5)
    public static void sifterHopperInput(GameTestHelper helper) {
        BlockEntity blockEntity = RecipeTests.getBlockEntity(MACHINE_POS, helper, SifterBlock.class);
        if (blockEntity instanceof SifterBlockEntity) {
            helper.m_177440_(MACHINE_POS);
            BlockPos upPos = MACHINE_POS.m_7494_();
            helper.m_177245_(upPos, Blocks.f_50332_);
            BlockEntity hopper = RecipeTests.getBlockEntity(upPos, helper, HopperBlock.class);
            if (hopper instanceof HopperBlockEntity) {
                HopperBlockEntity hopperBlockEntity = (HopperBlockEntity)hopper;
                hopperBlockEntity.m_6836_(0, new ItemStack((ItemLike)Blocks.f_49992_));
                helper.m_177127_(1L, () -> HopperTests.assertContainerContainsItemInSlot(helper, MACHINE_POS, 0, Blocks.f_49992_.m_5456_(), 1));
                helper.m_177127_(2L, () -> ((GameTestHelper)helper).m_177412_());
            }
        }
    }
}

