/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.network.debug;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.instruction.Instruction;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricFlying;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricSwimming;
import com.github.teamfossilsarcheology.fossil.util.Version;
import dev.architectury.networking.NetworkManager;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class C2SStructureMessage {
    private final boolean onlyStructure;

    public C2SStructureMessage(FriendlyByteBuf buf) {
        this(buf.readBoolean());
    }

    public C2SStructureMessage(boolean onlyStructure) {
        this.onlyStructure = onlyStructure;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeBoolean(this.onlyStructure);
    }

    public void apply(Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            Level patt1654$temp;
            if (Version.debugEnabled() && (patt1654$temp = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt1654$temp;
                C2SStructureMessage.spawnTestStructure(serverLevel, this.onlyStructure);
            }
        });
    }

    private static void spawnTestStructure(ServerLevel level, boolean onlyStructure) {
        int length = 0;
        ArrayList<Prehistoric> toAdd = new ArrayList<Prehistoric>();
        for (PrehistoricEntityInfo info : PrehistoricEntityInfo.values()) {
            Entity entity = info.entityType().m_20615_((Level)level);
            if (!(entity instanceof Prehistoric)) continue;
            Prehistoric prehistoric = (Prehistoric)entity;
            toAdd.add(prehistoric);
            ++length;
        }
        BlockState ironBlock = Blocks.f_50743_.m_49966_();
        for (BlockPos blockPos : BlockPos.m_121976_((int)0, (int)119, (int)0, (int)(length * 5 + 20), (int)119, (int)50)) {
            level.m_7731_(blockPos, ironBlock, 2);
        }
        for (int i = 0; i < toAdd.size(); ++i) {
            PrehistoricSwimming swimming;
            Prehistoric prehistoric = (Prehistoric)toAdd.get(i);
            double xOffset = (double)i * 5.0 + 3.0;
            List<Instruction> instructions = List.of(new Instruction.TeleportTo(BlockPos.m_274561_((double)xOffset, (double)120.0, (double)0.0), 0), new Instruction.MoveTo(BlockPos.m_274561_((double)xOffset, (double)120.0, (double)45.0)));
            prehistoric.m_6518_((ServerLevelAccessor)level, level.m_6436_(prehistoric.m_20183_()), MobSpawnType.SPAWN_EGG, null, null);
            prehistoric.m_7678_(xOffset, 120.0, 0.0, 0.0f, 0.0f);
            if (prehistoric instanceof PrehistoricSwimming && !(swimming = (PrehistoricSwimming)prehistoric).isAmphibious()) {
                swimming.m_21557_(true);
            } else {
                prehistoric.getInstructionSystem().start(instructions, true, true);
            }
            if (prehistoric instanceof PrehistoricFlying) {
                PrehistoricFlying flying = (PrehistoricFlying)prehistoric;
                flying.m_21557_(true);
            }
            prehistoric.getInstructionSystem().syncWithClients();
            level.m_7967_((Entity)prehistoric);
        }
    }
}

