/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.util;

import com.github.teamfossilsarcheology.fossil.util.forge.VersionImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.HashSet;
import java.util.Set;

public class Version {
    private static final Set<ReleaseType> RELEASE_TYPES = ReleaseType.parseVersion(Version.getVersion());

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static String getVersion() {
        return VersionImpl.getVersion();
    }

    public static boolean isAlpha() {
        return RELEASE_TYPES.contains((Object)ReleaseType.ALPHA);
    }

    public static boolean debugEnabled() {
        return RELEASE_TYPES.contains((Object)ReleaseType.DEVELOP);
    }

    public static enum ReleaseType {
        ALPHA,
        DEVELOP,
        RELEASE_CANDIDATE;


        public static Set<ReleaseType> parseVersion(String version) {
            HashSet<ReleaseType> set = new HashSet<ReleaseType>();
            if (version.contains("-develop")) {
                set.add(DEVELOP);
            }
            if (version.contains("-rc")) {
                set.add(RELEASE_CANDIDATE);
            }
            if (version.contains("-alpha")) {
                set.add(ALPHA);
            }
            return set;
        }
    }
}

