/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.world.chunk;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.jetbrains.annotations.NotNull;

public abstract class SingleStructureChunkGenerator
extends ChunkGenerator {
    private final ResourceKey<Structure> key;

    public SingleStructureChunkGenerator(Holder.Reference<Biome> biomeReference, ResourceKey<Structure> key) {
        super((BiomeSource)new FixedBiomeSource(biomeReference));
        this.key = key;
    }

    public void m_213679_(WorldGenRegion level, long seed, RandomState random, BiomeManager biomeManager, StructureManager structureManager, ChunkAccess chunk, GenerationStep.Carving step) {
    }

    public void m_255037_(RegistryAccess registryAccess, ChunkGeneratorStructureState structureState, StructureManager structureManager, ChunkAccess chunk, StructureTemplateManager structureTemplateManager) {
        if (chunk.m_7697_().f_45578_ == 0 && chunk.m_7697_().f_45579_ == 0) {
            HolderLookup.RegistryLookup structures = registryAccess.m_255025_(Registries.f_256944_);
            Structure structure = (Structure)structures.m_255043_(this.key).m_203334_();
            SectionPos sectionPos = SectionPos.m_175562_((ChunkAccess)chunk);
            StructureStart structureStart = structureManager.m_220512_(sectionPos, structure, (StructureAccess)chunk);
            int i = structureStart != null ? structureStart.m_73608_() : 0;
            structureStart = structure.m_226596_(registryAccess, (ChunkGenerator)this, this.f_62137_, structureState.m_255046_(), structureTemplateManager, structureState.m_254887_(), chunk.m_7697_(), i, (LevelHeightAccessor)chunk, arg_0 -> ((HolderSet)structure.m_226559_()).m_203333_(arg_0));
            if (structureStart.m_73603_()) {
                structureManager.m_220516_(sectionPos, structure, structureStart, (StructureAccess)chunk);
            }
        }
    }

    public void m_213609_(WorldGenLevel level, ChunkAccess chunk, StructureManager structureManager) {
        ChunkPos chunkPos = chunk.m_7697_();
        if (!SharedConstants.m_183707_((ChunkPos)chunkPos)) {
            WorldgenRandom worldgenRandom = new WorldgenRandom((RandomSource)new XoroshiroRandomSource(RandomSupport.m_224599_()));
            Structure structure = (Structure)level.m_9598_().m_255025_(Registries.f_256944_).m_255043_(this.key).m_203334_();
            level.m_143497_(() -> this.key.toString());
            structureManager.m_220504_(SectionPos.m_123196_((ChunkPos)chunkPos, (int)level.m_151560_()), structure).forEach(structureStart -> structureStart.m_226850_(level, structureManager, (ChunkGenerator)this, (RandomSource)worldgenRandom, SingleStructureChunkGenerator.getWritableArea(chunk), chunkPos));
            level.m_143497_(null);
        }
    }

    private static BoundingBox getWritableArea(ChunkAccess chunk) {
        ChunkPos chunkPos = chunk.m_7697_();
        int i = chunkPos.m_45604_();
        int j = chunkPos.m_45605_();
        LevelHeightAccessor levelHeightAccessor = chunk.m_183618_();
        int k = levelHeightAccessor.m_141937_() + 1;
        int l = levelHeightAccessor.m_151558_() - 1;
        return new BoundingBox(i, k, j, i + 15, l, j + 15);
    }

    public void m_6929_(WorldGenRegion level) {
    }

    public int m_6331_() {
        return 0;
    }

    @NotNull
    public CompletableFuture<ChunkAccess> m_213974_(Executor executor, Blender blender, RandomState random, StructureManager structureManager, ChunkAccess chunk) {
        return CompletableFuture.completedFuture(chunk);
    }

    public int m_6337_() {
        return 0;
    }

    public int m_142062_() {
        return 0;
    }

    public int m_214096_(int x, int z, Heightmap.Types type, LevelHeightAccessor level, RandomState random) {
        return 0;
    }

    @NotNull
    public NoiseColumn m_214184_(int x, int z, LevelHeightAccessor height, RandomState random) {
        return new NoiseColumn(height.m_141937_(), new BlockState[0]);
    }

    public void m_213600_(List<String> info, RandomState random, BlockPos pos) {
    }
}

