/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.world.feature;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.block.ModBlocks;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class ModOreFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_AMBER = ModOreFeatures.createKey("ore_amber");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_AMBER_BURIED = ModOreFeatures.createKey("ore_amber_buried");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_FOSSIL_BLOCK_NO_SANDSTONE = ModOreFeatures.createKey("ore_fossil_block_without_sandstone");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_FOSSIL_BLOCK = ModOreFeatures.createKey("ore_fossil_block");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_PERMAFROST_BLOCK = ModOreFeatures.createKey("ore_permafrost_block");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_VOLCANIC_ROCK = ModOreFeatures.createKey("ore_volcanic_rock");

    private static ResourceKey<ConfiguredFeature<?, ?>> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)FossilMod.location(name));
    }

    public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
        TagMatchTest stoneOreReplaceables = new TagMatchTest(BlockTags.f_144266_);
        TagMatchTest deepslateOreReplaceables = new TagMatchTest(BlockTags.f_144267_);
        List<OreConfiguration.TargetBlockState> amberOreTargetList = List.of(OreConfiguration.m_161021_((RuleTest)stoneOreReplaceables, (BlockState)((DropExperienceBlock)ModBlocks.AMBER_ORE.get()).m_49966_()));
        FeatureUtils.m_254977_(context, ORE_AMBER, (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(amberOreTargetList, 3));
        FeatureUtils.m_254977_(context, ORE_AMBER_BURIED, (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(amberOreTargetList, 3, 1.0f));
        List<OreConfiguration.TargetBlockState> overworldFossilBlockNoSandstone = List.of(ModOreFeatures.target(Blocks.f_152497_, ModBlocks.CALCITE_FOSSIL), ModOreFeatures.target(Blocks.f_152537_, ModBlocks.DRIPSTONE_FOSSIL), ModOreFeatures.target(Blocks.f_152550_, ModBlocks.DEEPSLATE_FOSSIL), OreConfiguration.m_161021_((RuleTest)stoneOreReplaceables, (BlockState)((Block)ModBlocks.STONE_FOSSIL.get()).m_49966_()), ModOreFeatures.target(Blocks.f_152496_, ModBlocks.TUFF_FOSSIL));
        List<OreConfiguration.TargetBlockState> overworldFossilBlock = List.of(ModOreFeatures.target(Blocks.f_152497_, ModBlocks.CALCITE_FOSSIL), ModOreFeatures.target(Blocks.f_152537_, ModBlocks.DRIPSTONE_FOSSIL), ModOreFeatures.target(Blocks.f_152550_, ModBlocks.DEEPSLATE_FOSSIL), ModOreFeatures.target(Blocks.f_50394_, ModBlocks.RED_SANDSTONE_FOSSIL), ModOreFeatures.target(Blocks.f_50062_, ModBlocks.SANDSTONE_FOSSIL), OreConfiguration.m_161021_((RuleTest)stoneOreReplaceables, (BlockState)((Block)ModBlocks.STONE_FOSSIL.get()).m_49966_()), ModOreFeatures.target(Blocks.f_152496_, ModBlocks.TUFF_FOSSIL));
        FeatureUtils.m_254977_(context, ORE_FOSSIL_BLOCK_NO_SANDSTONE, (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(overworldFossilBlockNoSandstone, 6));
        FeatureUtils.m_254977_(context, ORE_FOSSIL_BLOCK, (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(overworldFossilBlock, 6));
        List<OreConfiguration.TargetBlockState> overworldPermafrostBlock = List.of(OreConfiguration.m_161021_((RuleTest)new TagMatchTest(BlockTags.f_144274_), (BlockState)((Block)ModBlocks.PERMAFROST_BLOCK.get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)new BlockMatchTest(Blocks.f_50440_), (BlockState)((Block)ModBlocks.PERMAFROST_BLOCK.get()).m_49966_()));
        FeatureUtils.m_254977_(context, ORE_PERMAFROST_BLOCK, (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(overworldPermafrostBlock, 5));
        List<OreConfiguration.TargetBlockState> overworldVolcanicRock = List.of(OreConfiguration.m_161021_((RuleTest)deepslateOreReplaceables, (BlockState)((Block)ModBlocks.VOLCANIC_ROCK.get()).m_49966_()));
        FeatureUtils.m_254977_(context, ORE_VOLCANIC_ROCK, (Feature)Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(overworldVolcanicRock, 24));
    }

    private static OreConfiguration.TargetBlockState target(Block target, RegistrySupplier<? extends Block> block) {
        return OreConfiguration.m_161021_((RuleTest)new BlockMatchTest(target), (BlockState)((Block)block.get()).m_49966_());
    }
}

