/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.world.feature.structures;

import com.github.teamfossilsarcheology.fossil.config.FossilConfig;
import com.github.teamfossilsarcheology.fossil.world.feature.structures.HellBoatPiece;
import com.github.teamfossilsarcheology.fossil.world.feature.structures.ModStructureType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import org.jetbrains.annotations.NotNull;

public class HellBoatStructure
extends Structure {
    public static final Codec<HellBoatStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)HellBoatStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)HeightProvider.f_161970_.fieldOf("height").forGetter(hellBoatStructure -> hellBoatStructure.height)).apply((Applicative)instance, HellBoatStructure::new));
    public final HeightProvider height;

    public HellBoatStructure(Structure.StructureSettings settings, HeightProvider height) {
        super(settings);
        this.height = height;
    }

    @NotNull
    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        if (!FossilConfig.isEnabled("generateHellShips")) {
            return Optional.empty();
        }
        BlockPos origin = context.f_226628_().m_151394_(0);
        WorldgenRandom worldgenRandom = context.f_226626_();
        int x = context.f_226628_().m_45604_() + worldgenRandom.m_188503_(16);
        int z = context.f_226628_().m_45605_() + worldgenRandom.m_188503_(16);
        NoiseColumn noiseColumn = context.f_226622_().m_214184_(x, z, context.f_226629_(), context.f_226624_());
        if (noiseColumn.m_183556_(31).m_60734_() != Blocks.f_49991_) {
            return Optional.empty();
        }
        for (int i = 32; i < 50; ++i) {
            Block block = noiseColumn.m_183556_(i).m_60734_();
            if (block == Blocks.f_50016_ || block == Blocks.f_50627_) continue;
            return Optional.empty();
        }
        Rotation rotation = Rotation.m_221990_((RandomSource)worldgenRandom);
        BlockPos blockPos = origin.m_175288_(30);
        return Optional.of(new Structure.GenerationStub(blockPos, builder -> builder.m_142679_((StructurePiece)new HellBoatPiece(context.f_226625_(), blockPos, rotation))));
    }

    @NotNull
    public StructureType<?> m_213658_() {
        return ModStructureType.HELL_BOAT;
    }
}

