/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.block.entity;

import com.github.teamfossilsarcheology.fossil.block.custom_blocks.AnalyzerBlock;
import com.github.teamfossilsarcheology.fossil.block.entity.EnergyContainerBlockEntity;
import com.github.teamfossilsarcheology.fossil.block.entity.ModBlockEntities;
import com.github.teamfossilsarcheology.fossil.config.FossilConfig;
import com.github.teamfossilsarcheology.fossil.inventory.AnalyzerMenu;
import com.github.teamfossilsarcheology.fossil.recipe.AnalyzerRecipe;
import com.github.teamfossilsarcheology.fossil.recipe.ModRecipes;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3913;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnalyzerBlockEntity
extends EnergyContainerBlockEntity {
    private static final int[] SLOTS_FOR_UP = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private static final int[] SLOTS_FOR_DOWN = new int[]{9, 10, 11, 12};
    private final class_3913 dataAccess = new class_3913(){

        public int method_17390(int index) {
            switch (index) {
                case 0: {
                    return AnalyzerBlockEntity.this.cookingProgress;
                }
                case 1: {
                    return AnalyzerBlockEntity.this.energyStorage.getEnergy();
                }
            }
            return 0;
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    AnalyzerBlockEntity.this.cookingProgress = value;
                }
            }
        }

        public int method_17389() {
            return 2;
        }
    };
    protected class_2371<class_1799> items = class_2371.method_10213((int)13, (Object)class_1799.field_8037);
    private int rawIndex = -1;

    public AnalyzerBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)ModBlockEntities.ANALYZER.get(), blockPos, blockState);
    }

    @Override
    public class_3913 getDataAccess() {
        return this.dataAccess;
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, AnalyzerBlockEntity blockEntity) {
        blockEntity.serverTick(level, pos, state);
    }

    public void serverTick(class_1937 level, class_2338 pos, class_2680 state) {
        if (FossilConfig.isEnabled("machinesRequireEnergy") && this.energyStorage.getEnergy() <= 0) {
            if (this.cookingProgress > 0) {
                this.cookingProgress = class_3532.method_15340((int)(this.cookingProgress - 2), (int)0, (int)200);
            }
            return;
        }
        boolean wasProcessing = this.cookingProgress > 0;
        boolean dirty = false;
        if (this.canProcess()) {
            ++this.cookingProgress;
            if (this.cookingProgress >= 200) {
                this.cookingProgress = 0;
                this.createItem();
                dirty = true;
            }
            if (FossilConfig.isEnabled("machinesRequireEnergy")) {
                this.energyStorage.extractEnergy(FossilConfig.getInt("machineEnergyUsage"));
            }
        } else {
            this.cookingProgress = class_3532.method_15340((int)(this.cookingProgress - 2), (int)0, (int)200);
        }
        if (wasProcessing != this.cookingProgress > 0) {
            dirty = true;
            state = (class_2680)state.method_11657((class_2769)AnalyzerBlock.ACTIVE, (Comparable)Boolean.valueOf(this.cookingProgress > 0));
            level.method_8652(pos, state, 3);
        }
        if (dirty) {
            AnalyzerBlockEntity.method_31663((class_1937)level, (class_2338)pos, (class_2680)state);
        }
    }

    private boolean isAnalyzable(class_1799 itemStack) {
        return ModRecipes.getAnalyzerRecipeForItem((class_1263)new class_1277(new class_1799[]{itemStack}), this.field_11863) != null;
    }

    @Override
    protected boolean canProcess() {
        int slot;
        if (FossilConfig.isEnabled("machinesRequireEnergy") && this.energyStorage.getEnergy() <= FossilConfig.getInt("machineEnergyUsage")) {
            return false;
        }
        this.rawIndex = -1;
        for (slot = 0; slot < 9; ++slot) {
            if (((class_1799)this.items.get(slot)).method_7960() || !this.isAnalyzable((class_1799)this.items.get(slot))) continue;
            this.rawIndex = slot;
            break;
        }
        if (this.rawIndex != -1) {
            for (slot = 9; slot < 13; ++slot) {
                if (!((class_1799)this.items.get(slot)).method_7960()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void createItem() {
        if (this.canProcess()) {
            class_1799 input = (class_1799)this.items.get(this.rawIndex);
            AnalyzerRecipe recipe = ModRecipes.getAnalyzerRecipeForItem((class_1263)new class_1277(new class_1799[]{input}), this.field_11863);
            if (recipe == null) {
                return;
            }
            class_1799 output = recipe.method_8116(this, this.field_11863.method_30349()).method_7972();
            if (output.method_7947() > 1) {
                output.method_7939(1 + this.field_11863.field_9229.method_43048(output.method_7947() - 1));
            }
            if (!output.method_7960()) {
                class_1799 itemStack;
                int slot;
                for (slot = 9; slot < 13; ++slot) {
                    itemStack = (class_1799)this.items.get(slot);
                    if (!class_1799.method_7984((class_1799)itemStack, (class_1799)output) || itemStack.method_7947() + output.method_7947() >= 64) continue;
                    itemStack.method_7939(itemStack.method_7947() + output.method_7947());
                    input.method_7934(1);
                    return;
                }
                for (slot = 9; slot < 13; ++slot) {
                    itemStack = (class_1799)this.items.get(slot);
                    if (!itemStack.method_7960()) continue;
                    this.items.set(slot, (Object)output);
                    input.method_7934(1);
                    return;
                }
            }
        }
    }

    @Override
    @NotNull
    public class_2371<class_1799> getItems() {
        return this.items;
    }

    @NotNull
    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"container.fossil.analyzer");
    }

    @NotNull
    protected class_1703 method_5465(int containerId, @NotNull class_1661 inventory) {
        return new AnalyzerMenu(containerId, inventory, this, this.dataAccess);
    }

    public void method_5447(int slot, @NotNull class_1799 stack) {
        this.items.set(slot, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        this.method_5431();
    }

    public boolean method_5437(int slot, @NotNull class_1799 stack) {
        return slot < SLOTS_FOR_DOWN[0] && this.isAnalyzable(stack);
    }

    public int @NotNull [] method_5494(@NotNull class_2350 side) {
        return side == class_2350.field_11033 ? SLOTS_FOR_DOWN : SLOTS_FOR_UP;
    }

    public boolean method_5492(int slot, @NotNull class_1799 itemStack, @Nullable class_2350 direction) {
        return this.method_5437(slot, itemStack);
    }

    public boolean method_5493(int slot, @NotNull class_1799 stack, @NotNull class_2350 direction) {
        return direction != class_2350.field_11036 && slot >= SLOTS_FOR_DOWN[0];
    }
}

