/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PathingDebug;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PathingRenderer;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PlayerNodeEvaluator;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.EnumMap;
import net.minecraft.class_10;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1950;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_4459;
import net.minecraft.class_7;
import net.minecraft.class_9;
import org.jetbrains.annotations.Nullable;

public class PlayerSwimNodeEvaluator
extends PlayerNodeEvaluator {
    private final Long2ObjectMap<class_7> pathTypesByPosCache = new Long2ObjectOpenHashMap();

    @Override
    public void prepare(class_1950 level, class_1657 p) {
        super.prepare(level, p);
        this.pathTypesByPosCache.clear();
        PathingDebug.setPathfindingMalus(class_7.field_18, 0.0f);
    }

    @Override
    public void done() {
        super.done();
        this.pathTypesByPosCache.clear();
    }

    @Override
    public class_9 getStart() {
        class_238 aABB = PathingRenderer.getBigHitbox().method_997(class_243.method_24955((class_2382)PathingDebug.pos1));
        return super.getNode(class_3532.method_15357((double)aABB.field_1323), class_3532.method_15357((double)(aABB.field_1322 + 0.5)), class_3532.method_15357((double)aABB.field_1321));
    }

    @Override
    public int getNeighbors(class_9[] nodes, class_9 node) {
        int i = 0;
        EnumMap map = Maps.newEnumMap(class_2350.class);
        for (class_2350 direction : class_2350.values()) {
            class_9 node2 = this.getNode(node.field_40 + direction.method_10148(), node.field_39 + direction.method_10164(), node.field_38 + direction.method_10165());
            map.put(direction, node2);
            if (!this.isNodeValid(node2)) continue;
            nodes[i++] = node2;
        }
        for (class_2350 direction2 : class_2350.class_2353.field_11062) {
            class_2350 direction3 = direction2.method_10170();
            class_9 node3 = this.getNode(node.field_40 + direction2.method_10148() + direction3.method_10148(), node.field_39, node.field_38 + direction2.method_10165() + direction3.method_10165());
            if (!this.isDiagonalNodeValid(node3, (class_9)map.get(direction2), (class_9)map.get(direction3))) continue;
            nodes[i++] = node3;
        }
        return i;
    }

    protected boolean isNodeValid(@Nullable class_9 node) {
        return node != null && !node.field_42;
    }

    protected boolean isDiagonalNodeValid(@Nullable class_9 node, @Nullable class_9 node2, @Nullable class_9 node3) {
        return this.isNodeValid(node) && node2 != null && node2.field_43 >= 0.0f && node3 != null && node3.field_43 >= 0.0f;
    }

    @Override
    @Nullable
    protected class_9 getNode(int x, int y, int z) {
        class_9 node = null;
        class_7 blockPathTypes = this.getCachedBlockType(x, y, z);
        if (blockPathTypes == class_7.field_18) {
            float f;
            float f2 = PathingDebug.getPathfindingMalus(blockPathTypes);
            if (f >= 0.0f) {
                node = super.getNode(x, y, z);
                node.field_41 = blockPathTypes;
                node.field_43 = Math.max(node.field_43, f2);
                if (this.level.method_8316(new class_2338(x, y, z)).method_15769()) {
                    node.field_43 += 8.0f;
                }
            }
        }
        return node;
    }

    @Override
    public class_4459 getGoal(double x, double y, double z) {
        return new class_4459(super.getNode(class_3532.method_15357((double)x), class_3532.method_15357((double)y), class_3532.method_15357((double)z)));
    }

    protected class_7 getCachedBlockType(int x, int y, int z) {
        return (class_7)this.pathTypesByPosCache.computeIfAbsent(class_2338.method_10064((int)x, (int)y, (int)z), l -> this.getBlockPathType((class_1922)this.level, x, y, z));
    }

    @Override
    public class_7 getBlockPathType(class_1922 level, int x, int y, int z) {
        return this.getBlockPathType(level, x, y, z, this.player, this.entityWidth, this.entityHeight, this.entityDepth, this.canOpenDoors(), this.canPassDoors());
    }

    @Override
    public class_7 getBlockPathType(class_1922 blockaccess, int x, int y, int z, class_1657 entityliving, int xSize, int ySize, int zSize, boolean canBreakDoors, boolean canEnterDoors) {
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        for (int i = x; i < x + xSize; ++i) {
            for (int j = y; j < y + ySize; ++j) {
                for (int k = z; k < z + zSize; ++k) {
                    class_3610 fluidState = blockaccess.method_8316((class_2338)mutableBlockPos.method_10103(i, j, k));
                    class_2680 blockState = blockaccess.method_8320((class_2338)mutableBlockPos.method_10103(i, j, k));
                    if (fluidState.method_15769() && blockState.method_26171(blockaccess, mutableBlockPos.method_10074(), class_10.field_48) && blockState.method_26215()) {
                        return class_7.field_16;
                    }
                    if (fluidState.method_15767(class_3486.field_15517)) continue;
                    return class_7.field_22;
                }
            }
        }
        class_2680 blockState2 = blockaccess.method_8320((class_2338)mutableBlockPos);
        if (blockState2.method_26171(blockaccess, (class_2338)mutableBlockPos, class_10.field_48)) {
            return class_7.field_18;
        }
        return class_7.field_22;
    }
}

