/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.model;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.client.model.AdditiveAnimationModel;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricFlying;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricSwimming;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.swimming.Trilobite;
import java.util.function.Function;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;

public class PrehistoricGeoModel<T extends Prehistoric>
extends DefaultedEntityGeoModel<T>
implements AdditiveAnimationModel {
    private final Function<class_2960, class_1921> renderType;

    public PrehistoricGeoModel(String assetName, Function<class_2960, class_1921> renderType) {
        super(FossilMod.location(assetName), false);
        this.renderType = renderType;
    }

    public void setCustomAnimations(T animatable, long instanceId, AnimationState<T> animationState) {
        PrehistoricFlying flying;
        super.setCustomAnimations(animatable, instanceId, animationState);
        if (class_310.method_1551().method_1493()) {
            return;
        }
        if (animatable instanceof PrehistoricSwimming && animatable.method_5799() || animatable instanceof PrehistoricFlying && (flying = (PrehistoricFlying)animatable).method_6581()) {
            if (!animatable.method_5782() && !(animatable instanceof Trilobite)) {
                CoreGeoBone root = this.getAnimationProcessor().getBone("pitch_root");
                if (root != null) {
                    float pitch = class_3532.method_16439((float)animationState.getPartialTick(), (float)((Prehistoric)animatable).field_6004, (float)animatable.method_36455());
                    root.setRotX(-pitch * ((float)Math.PI / 180));
                }
            } else if (animatable instanceof PrehistoricFlying) {
                PrehistoricFlying flying2 = (PrehistoricFlying)animatable;
                CoreGeoBone root = this.getAnimationProcessor().getBone("pitch_root");
                if (root != null && ((Prehistoric)animatable).method_5642() instanceof class_1657) {
                    float pitch = class_3532.method_16439((float)animationState.getPartialTick(), (float)flying2.prevPitch, (float)flying2.currentPitch);
                    root.setRotX(-pitch * ((float)Math.PI / 180));
                    float yaw = class_3532.method_16439((float)animationState.getPartialTick(), (float)flying2.prevYaw, (float)flying2.currentYaw);
                    root.setRotZ(yaw * ((float)Math.PI / 180));
                }
            }
        }
    }

    public class_2960 getTextureResource(T object) {
        if (((Prehistoric)object).textureLocation == null) {
            ((Prehistoric)object).refreshTexturePath();
        }
        return ((Prehistoric)object).textureLocation;
    }

    public class_1921 getRenderType(T animatable, class_2960 texture) {
        return this.renderType.apply(texture);
    }
}

