/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.config.fabric;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import eu.midnightdust.lib.config.MidnightConfig;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public class FabricConfigFix {
    private static final Map<Integer, Set<Update<?>>> FIXES = new HashMap();

    private static <T> void add(int version, String name, T newValue, Predicate<T> predicate) {
        FIXES.computeIfAbsent(version, k -> new HashSet()).add(new Update<T>(name, newValue, predicate));
    }

    private static <T> void add(int version, String name, T newValue) {
        FabricConfigFix.add(version, name, newValue, t -> true);
    }

    public static void fixConfig(Map<String, Field> fields) {
        Field version = fields.get("version");
        try {
            if (version != null && (Integer)version.get(null) < 1) {
                FossilMod.LOGGER.info("Config version is outdated: {} -> {}", version.get(null), (Object)1);
                for (Update update : (Set)FIXES.getOrDefault(1, new HashSet())) {
                    Object oldValue;
                    Field field = fields.get(update.name);
                    if (field == null || !update.canReplace(oldValue = field.get(null))) continue;
                    FossilMod.LOGGER.info("Updating {}: {} -> {}", (Object)update.name, oldValue, update.newValue);
                    field.set(null, update.newValue);
                }
                version.set(null, 1);
                MidnightConfig.write((String)"fossil");
            }
        }
        catch (IllegalAccessException e) {
            FossilMod.LOGGER.error("Error while trying to update config", (Throwable)e);
        }
    }

    private record Update<T>(String name, T newValue, Predicate<T> predicate) {
        public boolean canReplace(Object oldValue) {
            return oldValue.getClass().isAssignableFrom(this.newValue.getClass()) && this.predicate.test(oldValue);
        }
    }
}

