/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai.anu;

import com.github.teamfossilsarcheology.fossil.entity.ai.anu.AnuDefensePhase;
import com.github.teamfossilsarcheology.fossil.entity.ai.anu.AnuFlightPhase;
import com.github.teamfossilsarcheology.fossil.entity.ai.anu.AnuLandingPhase;
import com.github.teamfossilsarcheology.fossil.entity.ai.anu.AnuMeleePhase;
import com.github.teamfossilsarcheology.fossil.entity.ai.anu.AnuPhaseInstance;
import com.github.teamfossilsarcheology.fossil.entity.monster.AnuBoss;
import com.google.common.collect.ImmutableList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;

public enum AnuPhase {
    MELEE(AnuMeleePhase.class, 1.0f),
    FLIGHT(AnuFlightPhase.class, 0.66f),
    LANDING(AnuLandingPhase.class, -1.0f),
    DEFENSE(AnuDefensePhase.class, 0.2f);

    private static final List<AnuPhase> BY_DAMAGE;
    private final Class<? extends AnuPhaseInstance> instanceClass;
    private final float healthFraction;

    private AnuPhase(Class<? extends AnuPhaseInstance> clazz, float f) {
        this.instanceClass = clazz;
        this.healthFraction = f;
    }

    public static boolean isLower(AnuPhase oldPhase, AnuPhase newPhase) {
        for (AnuPhase anuPhase : BY_DAMAGE) {
            if (anuPhase == oldPhase) {
                return true;
            }
            if (anuPhase != newPhase) continue;
            return false;
        }
        return true;
    }

    public static AnuPhase byFraction(float fraction) {
        for (AnuPhase mode : BY_DAMAGE) {
            if (fraction >= mode.healthFraction) continue;
            return mode;
        }
        return MELEE;
    }

    public AnuPhaseInstance createInstance(AnuBoss anu) {
        try {
            return this.instanceClass.getConstructor(AnuBoss.class).newInstance(new Object[]{anu});
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    static {
        BY_DAMAGE = (List)Stream.of(AnuPhase.values()).sorted(Comparator.comparingDouble(mode -> mode.healthFraction)).collect(ImmutableList.toImmutableList());
    }
}

