/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai.anu;

import com.github.teamfossilsarcheology.fossil.entity.ai.anu.AnuPhase;
import com.github.teamfossilsarcheology.fossil.entity.ai.anu.AnuPhaseInstance;
import com.github.teamfossilsarcheology.fossil.entity.monster.AnuBoss;
import com.mojang.logging.LogUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public final class AnuPhaseSystem {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final AnuBoss anu;
    private final AnuPhaseInstance[] phases = new AnuPhaseInstance[AnuPhase.values().length];
    @NotNull
    private AnuPhaseInstance currentPhase;

    public AnuPhaseSystem(AnuBoss anuBoss) {
        this.anu = anuBoss;
        this.currentPhase = this.getPhase(AnuPhase.MELEE);
    }

    public void setPhase(AnuPhase phase) {
        this.setPhase(phase, -1);
    }

    public void setPhase(AnuPhase phase, int duration) {
        if (phase != this.currentPhase.getPhase()) {
            this.currentPhase.end();
            this.currentPhase = this.getPhase(phase);
            if (!this.anu.method_37908().field_9236) {
                this.anu.method_5841().method_12778(AnuBoss.DATA_PHASE, (Object)phase.ordinal());
            }
            LOGGER.debug("Anu is now in phase {} on the {}", (Object)phase, (Object)(this.anu.method_37908().field_9236 ? "client" : "server"));
            this.currentPhase.begin(duration);
        }
    }

    @NotNull
    public AnuPhaseInstance getCurrentPhase() {
        return this.currentPhase;
    }

    public AnuPhaseInstance getPhase(AnuPhase phase) {
        int i = phase.ordinal();
        if (this.phases[i] == null) {
            this.phases[i] = phase.createInstance(this.anu);
        }
        return this.phases[i];
    }
}

