/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai.navigation;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.class_10;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_4459;
import net.minecraft.class_7;
import net.minecraft.class_8;
import net.minecraft.class_9;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrilobiteNodeEvaluator
extends class_8 {
    private final Long2ObjectMap<class_7> pathTypesByPosCache = new Long2ObjectOpenHashMap();
    private final Object2BooleanMap<class_238> collisionCache = new Object2BooleanOpenHashMap();

    @NotNull
    public class_9 method_21() {
        class_2338.class_2339 mutableBlockPos = this.field_33.method_24515().method_25503();
        int i = this.field_33.method_31478();
        if (this.field_33.method_5799()) {
            while (mutableBlockPos.method_10264() > this.field_20622.method_31607() && this.field_20622.method_8320((class_2338)mutableBlockPos).method_26171((class_1922)this.field_20622, (class_2338)mutableBlockPos, class_10.field_48)) {
                mutableBlockPos.method_10100(0, -1, 0);
            }
        } else {
            class_9 node = this.method_13(mutableBlockPos.method_10263(), i, mutableBlockPos.method_10260());
            node.field_41 = this.getBlockPathType(this.field_33, node.method_22879());
            node.field_43 = this.field_33.method_5944(node.field_41);
            return node;
        }
        i = mutableBlockPos.method_10084().method_10264();
        class_2338 blockPos = this.field_33.method_24515();
        class_7 blockPathTypes = this.getCachedBlockType(this.field_33, blockPos.method_10263(), i, blockPos.method_10260());
        if (this.field_33.method_5944(blockPathTypes) < 0.0f) {
            class_238 aABB = this.field_33.method_5829();
            if (this.hasPositiveMalus((class_2338)mutableBlockPos.method_10102(aABB.field_1323, (double)i, aABB.field_1321)) || this.hasPositiveMalus((class_2338)mutableBlockPos.method_10102(aABB.field_1323, (double)i, aABB.field_1324)) || this.hasPositiveMalus((class_2338)mutableBlockPos.method_10102(aABB.field_1320, (double)i, aABB.field_1321)) || this.hasPositiveMalus((class_2338)mutableBlockPos.method_10102(aABB.field_1320, (double)i, aABB.field_1324))) {
                class_9 node = this.method_27137((class_2338)mutableBlockPos);
                node.field_41 = this.getBlockPathType(this.field_33, node.method_22879());
                node.field_43 = this.field_33.method_5944(node.field_41);
                return node;
            }
        }
        class_9 node = this.method_13(blockPos.method_10263(), i, blockPos.method_10260());
        node.field_41 = this.getBlockPathType(this.field_33, node.method_22879());
        node.field_43 = this.field_33.method_5944(node.field_41);
        return node;
    }

    public final boolean hasPositiveMalus(class_2338 pos) {
        class_7 blockPathTypes = this.getBlockPathType(this.field_33, pos);
        return this.field_33.method_5944(blockPathTypes) >= 0.0f;
    }

    @NotNull
    public class_4459 method_16(double x, double y, double z) {
        return new class_4459(this.method_13(class_3532.method_15357((double)x), class_3532.method_15357((double)y), class_3532.method_15357((double)z)));
    }

    public int method_18(class_9[] nodes, class_9 node) {
        class_9 node9;
        class_9 node8;
        class_9 node7;
        class_9 node6;
        class_9 node5;
        class_9 node4;
        class_9 node3;
        double d;
        class_9 node2;
        int i = 0;
        int j = 0;
        class_7 blockPathTypes = this.getCachedBlockType(this.field_33, node.field_40, node.field_39 + 1, node.field_38);
        class_7 blockPathTypes2 = this.getCachedBlockType(this.field_33, node.field_40, node.field_39, node.field_38);
        if (this.field_33.method_5944(blockPathTypes) >= 0.0f && blockPathTypes2 != class_7.field_21326) {
            j = class_3532.method_15375((float)Math.max(1.0f, this.field_33.method_49476()));
        }
        if (this.isNeighborValid(node2 = this.findAcceptedNode(node.field_40, node.field_39, node.field_38 + 1, j, d = this.getFloorLevel(new class_2338(node.field_40, node.field_39, node.field_38)), class_2350.field_11035, blockPathTypes2), node)) {
            nodes[i++] = node2;
        }
        if (this.isNeighborValid(node3 = this.findAcceptedNode(node.field_40 - 1, node.field_39, node.field_38, j, d, class_2350.field_11039, blockPathTypes2), node)) {
            nodes[i++] = node3;
        }
        if (this.isNeighborValid(node4 = this.findAcceptedNode(node.field_40 + 1, node.field_39, node.field_38, j, d, class_2350.field_11034, blockPathTypes2), node)) {
            nodes[i++] = node4;
        }
        if (this.isNeighborValid(node5 = this.findAcceptedNode(node.field_40, node.field_39, node.field_38 - 1, j, d, class_2350.field_11043, blockPathTypes2), node)) {
            nodes[i++] = node5;
        }
        if (this.isDiagonalValid(node, node3, node5, node6 = this.findAcceptedNode(node.field_40 - 1, node.field_39, node.field_38 - 1, j, d, class_2350.field_11043, blockPathTypes2))) {
            nodes[i++] = node6;
        }
        if (this.isDiagonalValid(node, node4, node5, node7 = this.findAcceptedNode(node.field_40 + 1, node.field_39, node.field_38 - 1, j, d, class_2350.field_11043, blockPathTypes2))) {
            nodes[i++] = node7;
        }
        if (this.isDiagonalValid(node, node3, node2, node8 = this.findAcceptedNode(node.field_40 - 1, node.field_39, node.field_38 + 1, j, d, class_2350.field_11035, blockPathTypes2))) {
            nodes[i++] = node8;
        }
        if (this.isDiagonalValid(node, node4, node2, node9 = this.findAcceptedNode(node.field_40 + 1, node.field_39, node.field_38 + 1, j, d, class_2350.field_11035, blockPathTypes2))) {
            nodes[i++] = node9;
        }
        return i;
    }

    protected boolean isNeighborValid(@Nullable class_9 node, class_9 node2) {
        return node != null && !node.field_42 && (node.field_43 >= 0.0f || node2.field_43 < 0.0f);
    }

    protected boolean isDiagonalValid(class_9 node, @Nullable class_9 node2, @Nullable class_9 node3, @Nullable class_9 node4) {
        if (node4 == null || node3 == null || node2 == null) {
            return false;
        }
        if (node4.field_42) {
            return false;
        }
        if (node3.field_39 > node.field_39 || node2.field_39 > node.field_39) {
            return false;
        }
        boolean bl = node3.field_41 == class_7.field_10 && node2.field_41 == class_7.field_10 && (double)this.field_33.method_17681() < 0.5;
        return node4.field_43 >= 0.0f && (node3.field_39 < node.field_39 || node3.field_43 >= 0.0f || bl) && (node2.field_39 < node.field_39 || node2.field_43 >= 0.0f || bl);
    }

    protected double getFloorLevel(class_2338 pos) {
        return TrilobiteNodeEvaluator.getFloorLevel((class_1922)this.field_20622, pos);
    }

    public static double getFloorLevel(class_1922 level, class_2338 pos) {
        class_2338 blockPos = pos.method_10074();
        class_265 voxelShape = level.method_8320(blockPos).method_26220(level, blockPos);
        return (double)blockPos.method_10264() + (voxelShape.method_1110() ? 0.0 : voxelShape.method_1105(class_2350.class_2351.field_11052));
    }

    @Nullable
    protected class_9 findAcceptedNode(int x, int y, int z, int i, double d, class_2350 direction, class_7 original) {
        class_9 node = null;
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        double e = this.getFloorLevel((class_2338)mutableBlockPos.method_10103(x, y, z));
        if (e - d > 1.125) {
            return null;
        }
        class_7 type = this.getCachedBlockType(this.field_33, x, y, z);
        float f = this.field_33.method_5944(type);
        double g = (double)this.field_33.method_17681() / 2.0;
        if (f >= 0.0f) {
            node = this.method_13(x, y, z);
            node.field_41 = type;
            node.field_43 = Math.max(node.field_43, f);
        }
        if (type != class_7.field_12) {
            double j;
            double h;
            class_238 aABB;
            if ((node == null || node.field_43 < 0.0f) && i > 0 && (node = this.findAcceptedNode(x, y + 1, z, i - 1, d, direction, original)) != null && (node.field_41 == class_7.field_7 || node.field_41 == class_7.field_12) && this.field_33.method_17681() < 1.0f && this.hasCollisions(aABB = new class_238((h = (double)(x - direction.method_10148()) + 0.5) - g, TrilobiteNodeEvaluator.getFloorLevel((class_1922)this.field_20622, (class_2338)mutableBlockPos.method_10102(h, (double)(y + 1), j = (double)(z - direction.method_10165()) + 0.5)) + 0.001, j - g, h + g, (double)this.field_33.method_17682() + TrilobiteNodeEvaluator.getFloorLevel((class_1922)this.field_20622, (class_2338)mutableBlockPos.method_10103(node.field_40, node.field_39, node.field_38)) - 0.002, j + g))) {
                node = null;
            }
            if (type == class_7.field_18) {
                if (this.getCachedBlockType(this.field_33, x, y - 1, z) != class_7.field_18) {
                    return node;
                }
                while (y > this.field_33.method_37908().method_31607()) {
                    if ((type = this.getCachedBlockType(this.field_33, x, --y, z)) != class_7.field_18) {
                        return node;
                    }
                    node = this.method_13(x, y, z);
                    node.field_41 = type;
                    node.field_43 = Math.max(node.field_43, this.field_33.method_5944(type));
                }
            }
            if (type == class_7.field_7) {
                int k = 0;
                int l = y;
                while (type == class_7.field_7) {
                    if (--y < this.field_33.method_37908().method_31607()) {
                        class_9 node2 = this.method_13(x, l, z);
                        node2.field_41 = class_7.field_22;
                        node2.field_43 = -1.0f;
                        return node2;
                    }
                    if (k++ >= this.field_33.method_5850()) {
                        class_9 node2 = this.method_13(x, y, z);
                        node2.field_41 = class_7.field_22;
                        node2.field_43 = -1.0f;
                        return node2;
                    }
                    type = this.getCachedBlockType(this.field_33, x, y, z);
                    f = this.field_33.method_5944(type);
                    if (type != class_7.field_7 && f >= 0.0f) {
                        node = this.method_13(x, y, z);
                        node.field_41 = type;
                        node.field_43 = Math.max(node.field_43, f);
                        break;
                    }
                    if (!(f < 0.0f)) continue;
                    class_9 node2 = this.method_13(x, y, z);
                    node2.field_41 = class_7.field_22;
                    node2.field_43 = -1.0f;
                    return node2;
                }
            }
        }
        return node;
    }

    private boolean hasCollisions(class_238 aABB) {
        return this.collisionCache.computeIfAbsent((Object)aABB, object -> !this.field_20622.method_8587((class_1297)this.field_33, aABB));
    }

    private class_7 getBlockPathType(class_1308 entityliving, class_2338 pos) {
        return this.getCachedBlockType(entityliving, pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    protected class_7 getCachedBlockType(class_1308 entity, int x, int y, int z) {
        return (class_7)this.pathTypesByPosCache.computeIfAbsent(class_2338.method_10064((int)x, (int)y, (int)z), l -> this.method_25((class_1922)this.field_20622, x, y, z, entity));
    }

    @NotNull
    public class_7 method_25(class_1922 blockaccess, int x, int y, int z, class_1308 entityliving) {
        EnumSet<class_7> enumSet = EnumSet.noneOf(class_7.class);
        class_7 blockPathTypes = class_7.field_22;
        blockPathTypes = this.getBlockPathTypes(blockaccess, x, y, z, enumSet, blockPathTypes);
        class_7 result = class_7.field_22;
        for (class_7 tested : enumSet) {
            if (entityliving.method_5944(tested) < 0.0f) {
                return tested;
            }
            if (!(entityliving.method_5944(tested) >= entityliving.method_5944(result))) continue;
            result = tested;
        }
        return blockPathTypes == class_7.field_7 && entityliving.method_5944(result) == 0.0f && this.field_31 <= 1 ? class_7.field_7 : result;
    }

    public class_7 getBlockPathTypes(class_1922 level, int x, int y, int z, Set<class_7> nodeTypeEnum, class_7 nodeType) {
        for (int i = 0; i < this.field_31; ++i) {
            for (int j = 0; j < this.field_30; ++j) {
                for (int k = 0; k < this.field_28; ++k) {
                    int l = i + x;
                    int m = j + y;
                    int n = k + z;
                    class_7 blockPathTypes = this.method_17(level, l, m, n);
                    if (i == 0 && j == 0 && k == 0) {
                        nodeType = blockPathTypes;
                    }
                    nodeTypeEnum.add(blockPathTypes);
                }
            }
        }
        return nodeType;
    }

    @NotNull
    public class_7 method_17(class_1922 level, int x, int y, int z) {
        class_2338.class_2339 pos = new class_2338.class_2339(x, y, z);
        int i = pos.method_10263();
        int j = pos.method_10264();
        int k = pos.method_10260();
        class_7 type = TrilobiteNodeEvaluator.getBlockPathTypeRaw(level, (class_2338)pos);
        if (type == class_7.field_7 && j >= level.method_31607() + 1) {
            class_7 below = TrilobiteNodeEvaluator.getBlockPathTypeRaw(level, (class_2338)pos.method_10103(i, j - 1, k));
            if (below == class_7.field_3) {
                type = class_7.field_3;
            } else if (below != class_7.field_7) {
                type = class_7.field_12;
            }
        }
        return type;
    }

    protected static class_7 getBlockPathTypeRaw(class_1922 level, class_2338 pos) {
        class_3610 fluidState = level.method_8316(pos);
        if (fluidState.method_15767(class_3486.field_15517)) {
            return class_7.field_7;
        }
        class_2680 blockstate = level.method_8320(pos);
        if (blockstate.method_27852(class_2246.field_10092)) {
            return class_7.field_3;
        }
        return class_7.field_22;
    }
}

