/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.animation;

import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationCategory;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.animation.ClientAnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.animation.PausableAnimationController;
import com.github.teamfossilsarcheology.fossil.entity.animation.ServerAnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricAnimatable;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricFish;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricFlying;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricLeaping;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricSwimming;
import com.github.teamfossilsarcheology.fossil.entity.util.Util;
import com.github.teamfossilsarcheology.fossil.network.MessageHandler;
import com.github.teamfossilsarcheology.fossil.network.S2CSyncActiveAnimationMessage;
import com.github.teamfossilsarcheology.fossil.network.debug.S2CCancelAnimationMessage;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_4051;
import net.minecraft.class_5134;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class AnimationLogic<T extends class_1308> {
    public static final String IDLE_CTRL = "Movement/Idle";
    public static final String EAT_CTRL = "Eat";
    public static final String ATTACK_CTRL = "Attack";
    private final Map<String, ActiveAnimationInfo> activeAnimations = new Object2ObjectOpenHashMap();
    private final Map<ActiveAnimationInfo, BooleanSupplier> additionalLogic = new Object2ObjectOpenHashMap();
    private final Map<String, ActiveAnimationInfo> nextAnimations = new Object2ObjectOpenHashMap();
    private final Map<String, Float> prevAnimationSpeeds = new Object2FloatOpenHashMap();
    protected final T entity;

    public AnimationLogic(T entity) {
        this.entity = entity;
    }

    public Optional<ActiveAnimationInfo> getActiveAnimation(String controller) {
        return Optional.ofNullable(this.activeAnimations.get(controller));
    }

    private ActiveAnimationInfo putActiveAnimation(String controller, ActiveAnimationInfo info) {
        this.additionalLogic.remove(this.activeAnimations.put(controller, info));
        return info;
    }

    public void triggerAnimation(String controller, AnimationInfo animationInfo, AnimationCategory category) {
        if (animationInfo != null && !this.entity.method_37908().field_9236) {
            ActiveAnimationInfo activeAnimationInfo = new Builder(animationInfo.animation, this.entity.method_37908().method_8510(), category).forced().transitionLength(5).loop(false).build();
            class_4051 conditions = class_4051.method_36626().method_36627().method_18418(30.0);
            List players = ((class_3218)this.entity.method_37908()).method_18766(serverPlayer -> conditions.method_18419((class_1309)serverPlayer, this.entity));
            MessageHandler.SYNC_CHANNEL.sendToPlayers((Iterable)players, (Object)new S2CSyncActiveAnimationMessage((class_1297)this.entity, controller, activeAnimationInfo));
        }
    }

    public ActiveAnimationInfo forceAnimation(String controller, AnimationInfo animationInfo, AnimationCategory category, double speed, int transitionLength, boolean loop) {
        if (animationInfo != null) {
            ActiveAnimationInfo activeAnimationInfo = new Builder(animationInfo.animation, this.entity.method_37908().method_8510(), category).forced().transitionLength(transitionLength).speed(speed).loop(loop).build();
            this.addNextAnimation(controller, activeAnimationInfo);
            if (!this.entity.method_37908().field_9236) {
                class_4051 conditions = class_4051.method_36626().method_36627().method_18418(30.0);
                List players = ((class_3218)this.entity.method_37908()).method_18766(serverPlayer -> conditions.method_18419((class_1309)serverPlayer, this.entity));
                MessageHandler.SYNC_CHANNEL.sendToPlayers((Iterable)players, (Object)new S2CSyncActiveAnimationMessage((class_1297)this.entity, controller, activeAnimationInfo));
            }
            return activeAnimationInfo;
        }
        return null;
    }

    public ActiveAnimationInfo addActiveAnimation(String controller, AnimationCategory category) {
        return this.addActiveAnimation(controller, ((PrehistoricAnimatable)this.entity).getAnimation((AnimationCategory)category).animation, category, false);
    }

    public ActiveAnimationInfo addActiveAnimation(String controller, AnimationCategory category, boolean keepActive) {
        return this.addActiveAnimation(controller, ((PrehistoricAnimatable)this.entity).getAnimation((AnimationCategory)category).animation, category, keepActive);
    }

    public ActiveAnimationInfo addActiveAnimation(String controller, Animation animation, AnimationCategory category, boolean keepActive) {
        if (animation == null) {
            return null;
        }
        ActiveAnimationInfo active = this.getActiveAnimation(controller).orElse(null);
        if (active == null) {
            return this.putActiveAnimation(controller, new Builder(animation, this.entity.method_37908().method_8510(), category).keepActive(keepActive).build());
        }
        boolean replaceAnim = false;
        if (active.category == category && this.isAnimationDone(active)) {
            replaceAnim = !active.loop || this.entity.method_6051().method_43057() < category.chance();
        } else if (active.category != category) {
            boolean bl = replaceAnim = active.loop && (!active.keepActive || this.additionalLogic.getOrDefault(active, () -> false).getAsBoolean()) || this.isAnimationDone(active);
        }
        if (replaceAnim) {
            int transitionLength = Math.max(category.transitionLength(), active.category.transitionLength());
            return this.putActiveAnimation(controller, new Builder(animation, this.entity.method_37908().method_8510(), category).transitionLength(transitionLength).keepActive(keepActive).build());
        }
        return null;
    }

    public void addNextAnimation(String controller, ActiveAnimationInfo activeAnimationInfo) {
        this.nextAnimations.put(controller, activeAnimationInfo);
    }

    public void cancelAnimation(String controller) {
        if (this.entity.method_37908().field_9236) {
            this.getActiveAnimation(controller).ifPresent(this.additionalLogic::remove);
            this.activeAnimations.remove(controller);
        } else {
            class_4051 conditions = class_4051.method_36626().method_36627().method_18418(30.0);
            List players = ((class_3218)this.entity.method_37908()).method_18766(serverPlayer -> conditions.method_18419((class_1309)serverPlayer, this.entity));
            MessageHandler.DEBUG_CHANNEL.sendToPlayers((Iterable)players, (Object)new S2CCancelAnimationMessage(this.entity.method_5628(), controller));
        }
    }

    public boolean isAnimationDone(String controller) {
        Optional<ActiveAnimationInfo> opt = this.getActiveAnimation(controller);
        return opt.isEmpty() || this.isAnimationDone(opt.get());
    }

    public boolean isAnimationDone(ActiveAnimationInfo activeAnimation) {
        return (double)this.entity.method_37908().method_8510() >= activeAnimation.endTick;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isBlocked() {
        PrehistoricSwimming swimming;
        T t = this.entity;
        if (t instanceof PrehistoricSwimming && (swimming = (PrehistoricSwimming)t).isDoingGrabAttack()) {
            return true;
        }
        t = this.entity;
        if (!(t instanceof Prehistoric)) return false;
        Prehistoric prehistoric = (Prehistoric)t;
        if (this.entity.method_37908().method_8510() >= prehistoric.getEntityHitboxData().getAttackBoxData().attackBoxEndTime()) return false;
        return true;
    }

    public double getActionDelay(String controller) {
        if (this.activeAnimations.containsKey(controller)) {
            ActiveAnimationInfo activeAnimation = this.activeAnimations.get(controller);
            Map<String, ServerAnimationInfo> animationData = ((PrehistoricAnimatable)this.entity).getServerAnimationInfos();
            if (animationData.containsKey(activeAnimation.animationName)) {
                return animationData.get((Object)activeAnimation.animationName).actionDelay;
            }
        }
        return 0.0;
    }

    public PlayState waterPredicate(AnimationState<PrehistoricSwimming> state) {
        if (this.isBlocked()) {
            return PlayState.STOP;
        }
        AnimationController controller = state.getController();
        if (this.tryNextAnimation(state, controller)) {
            return PlayState.CONTINUE;
        }
        Optional<ActiveAnimationInfo> activeAnimation = this.getActiveAnimation(controller.getName());
        if (activeAnimation.isPresent() && this.tryForcedAnimation(state, activeAnimation.get())) {
            return PlayState.CONTINUE;
        }
        double animationSpeed = 1.0;
        if (((PrehistoricSwimming)state.getAnimatable()).isBeached()) {
            this.addActiveAnimation(controller.getName(), AnimationCategory.BEACHED);
        } else if (this.entity.method_6113()) {
            this.addActiveAnimation(controller.getName(), AnimationCategory.SLEEP);
        } else if (state.isMoving()) {
            if (this.entity.method_5799()) {
                if (this.entity.method_5624()) {
                    this.addActiveAnimation(controller.getName(), AnimationCategory.SWIM_FAST);
                } else {
                    this.addActiveAnimation(controller.getName(), AnimationCategory.SWIM);
                }
            } else {
                animationSpeed = this.addMovementAnimation(state, true);
            }
        } else if (((PrehistoricSwimming)state.getAnimatable()).isWeak()) {
            this.addActiveAnimation(controller.getName(), AnimationCategory.KNOCKOUT);
        } else {
            this.addActiveAnimation(controller.getName(), AnimationCategory.IDLE);
        }
        this.prevAnimationSpeeds.put(controller.getName(), Float.valueOf((float)animationSpeed));
        AnimationLogic.setAnimationSpeed(controller, animationSpeed, state.getAnimationTick());
        Optional<ActiveAnimationInfo> newAnimation = this.getActiveAnimation(controller.getName());
        if (newAnimation.isPresent()) {
            state.setAnimation(RawAnimation.begin().then(newAnimation.get().animationName, newAnimation.get().loop ? Animation.LoopType.LOOP : Animation.LoopType.DEFAULT));
        }
        return PlayState.CONTINUE;
    }

    public static void setAnimationSpeed(AnimationController<?> controller, double animationSpeed, double animationTick) {
        if (controller instanceof PausableAnimationController) {
            PausableAnimationController pausableAnimationController = (PausableAnimationController)controller;
            pausableAnimationController.setAnimationSpeed(animationSpeed, animationTick);
        }
    }

    public boolean tryNextAnimation(AnimationState<?> state, AnimationController<?> controller) {
        if (!this.nextAnimations.containsKey(controller.getName())) {
            return false;
        }
        ActiveAnimationInfo next = this.nextAnimations.remove(controller.getName());
        this.putActiveAnimation(controller.getName(), next);
        controller.transitionLength(next.transitionLength);
        controller.forceAnimationReset();
        state.setAnimation(RawAnimation.begin().then(next.animationName, next.loop ? Animation.LoopType.LOOP : Animation.LoopType.DEFAULT));
        return true;
    }

    public boolean tryForcedAnimation(AnimationState<?> state, ActiveAnimationInfo activeAnimation) {
        if (activeAnimation.forced && (activeAnimation.loop || !this.isAnimationDone(activeAnimation))) {
            AnimationController controller = state.getController();
            AnimationLogic.setAnimationSpeed(controller, activeAnimation.speed, state.getAnimationTick());
            controller.transitionLength(activeAnimation.transitionLength);
            state.setAnimation(RawAnimation.begin().then(activeAnimation.animationName, activeAnimation.loop ? Animation.LoopType.LOOP : Animation.LoopType.DEFAULT));
            return true;
        }
        return false;
    }

    public double addMovementAnimation(AnimationState<? extends Prehistoric> state, boolean canSprint) {
        double scaleMult;
        AnimationController controller = state.getController();
        ClientAnimationInfo walkAnim = (ClientAnimationInfo)((PrehistoricAnimatable)this.entity).nextWalkingAnimation();
        double animationSpeed = scaleMult = (double)(1.0f / ((Prehistoric)state.getAnimatable()).method_17825());
        double f = this.entity.method_24828() ? (double)(this.entity.method_37908().method_8320(this.entity.method_24515().method_10074()).method_26204().method_9499() * 0.91f) : (double)0.91f;
        double mobSpeed = this.entity.method_18798().method_37267() / f * 20.0;
        mobSpeed = Math.min(Util.attributeToSpeed(this.entity.method_26825(class_5134.field_23719), ((Prehistoric)state.getAnimatable()).attributes().sprintMod(), this.entity.method_5624()), mobSpeed);
        if (walkAnim.blocksPerSecond > 0.0) {
            animationSpeed *= mobSpeed / walkAnim.blocksPerSecond;
        }
        if (animationSpeed <= 0.1) {
            this.addActiveAnimation(controller.getName(), AnimationCategory.IDLE);
        } else {
            if (animationSpeed < (double)(this.prevAnimationSpeeds.getOrDefault(controller.getName(), Float.valueOf(0.0f)).floatValue() - 1.0E-5f)) {
                animationSpeed = class_3532.method_15348((float)this.prevAnimationSpeeds.get(controller.getName()).floatValue(), (float)((float)animationSpeed), (float)0.05f);
            }
            if (canSprint && (animationSpeed > 2.75 || this.entity.method_5624())) {
                ClientAnimationInfo sprintAnim = (ClientAnimationInfo)((PrehistoricAnimatable)this.entity).nextSprintingAnimation();
                animationSpeed = scaleMult;
                if (sprintAnim.blocksPerSecond > 0.0) {
                    animationSpeed *= mobSpeed / sprintAnim.blocksPerSecond;
                }
                this.addActiveAnimation(controller.getName(), sprintAnim.animation, AnimationCategory.SPRINT, false);
            } else {
                this.addActiveAnimation(controller.getName(), walkAnim.animation, AnimationCategory.WALK, false);
            }
        }
        return animationSpeed;
    }

    public PlayState leapingPredicate(AnimationState<PrehistoricLeaping> state) {
        AnimationController controller = state.getController();
        if (this.tryNextAnimation(state, controller)) {
            return PlayState.CONTINUE;
        }
        Optional<ActiveAnimationInfo> activeAnimation = this.getActiveAnimation(controller.getName());
        if (activeAnimation.isPresent() && this.tryForcedAnimation(state, activeAnimation.get())) {
            return PlayState.CONTINUE;
        }
        double animationSpeed = 1.0;
        PrehistoricLeaping entity = (PrehistoricLeaping)state.getAnimatable();
        if (entity.getLeapSystem().isAttackRiding()) {
            AnimationLogic.setAnimationSpeed(controller, 1.0, state.getAnimationTick());
            controller.transitionLength(10);
            state.setAnimation(RawAnimation.begin().thenLoop(entity.getLeapAttackAnimationName()));
            return PlayState.CONTINUE;
        }
        if (entity.getLeapSystem().hasLeapStarted() || entity.getLeapSystem().isLeapFlying()) {
            AnimationLogic.setAnimationSpeed(controller, 1.0, state.getAnimationTick());
            if (controller.getCurrentAnimation() != null && entity.getAnimations().get(AnimationCategory.FALL).hasAnimation(controller.getCurrentAnimation().animation().name()) && entity.method_24828()) {
                controller.transitionLength(0);
                state.setAnimation(RawAnimation.begin().thenPlay(entity.getLandAnimationName()));
            } else {
                state.setAnimation(RawAnimation.begin().thenPlay(entity.getLeapStartAnimationName()).thenLoop(entity.getAnimation((AnimationCategory)AnimationCategory.FALL).animation.name()));
            }
            return PlayState.CONTINUE;
        }
        if (entity.getLeapSystem().isLanding()) {
            AnimationLogic.setAnimationSpeed(controller, 1.0, state.getAnimationTick());
            controller.transitionLength(0);
            state.setAnimation(RawAnimation.begin().thenPlay(entity.getLandAnimationName()));
            return PlayState.CONTINUE;
        }
        if (entity.method_6113()) {
            this.addActiveAnimation(controller.getName(), AnimationCategory.SLEEP);
        } else if (entity.sitSystem.isSitting()) {
            this.addActiveAnimation(controller.getName(), AnimationCategory.SIT);
        } else if (entity.isClimbing()) {
            this.addActiveAnimation(controller.getName(), AnimationCategory.CLIMB);
            animationSpeed = 2.0;
        } else if (state.isMoving()) {
            if (entity.method_5799()) {
                ActiveAnimationInfo info = this.addActiveAnimation(controller.getName(), AnimationCategory.SWIM, true);
                if (info != null) {
                    this.additionalLogic.put(info, () -> ((PrehistoricLeaping)entity).method_24828());
                }
            } else {
                animationSpeed = this.addMovementAnimation(state, true);
            }
        } else if (entity.method_5799()) {
            this.addActiveAnimation(controller.getName(), AnimationCategory.SWIM);
        } else {
            this.addActiveAnimation(controller.getName(), AnimationCategory.IDLE);
        }
        AnimationLogic.setAnimationSpeed(controller, animationSpeed, state.getAnimationTick());
        Optional<ActiveAnimationInfo> newAnimation = this.getActiveAnimation(controller.getName());
        if (newAnimation.isPresent()) {
            controller.transitionLength(newAnimation.get().transitionLength);
            state.setAnimation(RawAnimation.begin().then(newAnimation.get().animationName, newAnimation.get().loop ? Animation.LoopType.LOOP : Animation.LoopType.DEFAULT));
        }
        return PlayState.CONTINUE;
    }

    public PlayState landPredicate(AnimationState<Prehistoric> state) {
        if (this.isBlocked()) {
            return PlayState.STOP;
        }
        AnimationController controller = state.getController();
        if (this.tryNextAnimation(state, controller)) {
            return PlayState.CONTINUE;
        }
        Optional<ActiveAnimationInfo> activeAnimation = this.getActiveAnimation(controller.getName());
        if (activeAnimation.isPresent() && this.tryForcedAnimation(state, activeAnimation.get())) {
            return PlayState.CONTINUE;
        }
        double animationSpeed = 1.0;
        if (((Prehistoric)state.getAnimatable()).isWeak()) {
            this.addActiveAnimation(controller.getName(), AnimationCategory.KNOCKOUT);
        } else if (this.entity.method_6113()) {
            this.addActiveAnimation(controller.getName(), AnimationCategory.SLEEP);
        } else if (((Prehistoric)state.getAnimatable()).sitSystem.isSitting()) {
            this.addActiveAnimation(controller.getName(), AnimationCategory.SIT);
        } else if (this.entity.method_5799()) {
            ActiveAnimationInfo info = this.addActiveAnimation(controller.getName(), AnimationCategory.SWIM, true);
            if (info != null) {
                this.additionalLogic.put(info, () -> this.entity.method_24828());
            }
        } else if (state.isMoving()) {
            animationSpeed = this.addMovementAnimation(state, true);
        } else {
            this.addActiveAnimation(controller.getName(), AnimationCategory.IDLE);
        }
        this.prevAnimationSpeeds.put(controller.getName(), Float.valueOf((float)animationSpeed));
        AnimationLogic.setAnimationSpeed(controller, animationSpeed, state.getAnimationTick());
        Optional<ActiveAnimationInfo> newAnimation = this.getActiveAnimation(controller.getName());
        if (newAnimation.isPresent()) {
            controller.transitionLength(newAnimation.get().transitionLength);
            state.setAnimation(RawAnimation.begin().then(newAnimation.get().animationName, newAnimation.get().loop ? Animation.LoopType.LOOP : Animation.LoopType.DEFAULT));
        }
        return PlayState.CONTINUE;
    }

    public PlayState attackPredicate(AnimationState<Prehistoric> state) {
        AnimationController controller = state.getController();
        if (this.tryNextAnimation(state, controller)) {
            return PlayState.CONTINUE;
        }
        if (!this.isAnimationDone(controller.getName())) {
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    public PlayState grabAttackPredicate(AnimationState<PrehistoricSwimming> state) {
        AnimationController controller = state.getController();
        if (this.tryNextAnimation(state, controller)) {
            return PlayState.CONTINUE;
        }
        if (((PrehistoricSwimming)state.getAnimatable()).isDoingGrabAttack()) {
            this.addActiveAnimation(controller.getName(), ((PrehistoricSwimming)state.getAnimatable()).nextGrabbingAnimation().animation, AnimationCategory.ATTACK, false);
        } else if (this.isAnimationDone(controller.getName())) {
            this.activeAnimations.remove(controller.getName());
        }
        Optional<ActiveAnimationInfo> newAnimation = this.getActiveAnimation(controller.getName());
        if (newAnimation.isPresent()) {
            state.setAnimation(RawAnimation.begin().thenPlay(newAnimation.get().animationName()));
            return PlayState.CONTINUE;
        }
        state.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    public PlayState fishPredicate(AnimationState<PrehistoricFish> state) {
        AnimationController controller = state.getController();
        if (!this.entity.method_5799()) {
            this.addActiveAnimation(controller.getName(), AnimationCategory.BEACHED);
        } else if (state.isMoving()) {
            this.addActiveAnimation(controller.getName(), AnimationCategory.SWIM);
        } else {
            this.addActiveAnimation(controller.getName(), AnimationCategory.IDLE);
        }
        Optional<ActiveAnimationInfo> newAnimation = this.getActiveAnimation(controller.getName());
        newAnimation.ifPresent(newInfo -> state.setAnimation(RawAnimation.begin().then(newInfo.animationName(), newInfo.loop ? Animation.LoopType.LOOP : Animation.LoopType.DEFAULT)));
        return PlayState.CONTINUE;
    }

    public PlayState flyingPredicate(AnimationState<PrehistoricFlying> state) {
        AnimationController controller = state.getController();
        if (this.tryNextAnimation(state, controller)) {
            return PlayState.CONTINUE;
        }
        Optional<ActiveAnimationInfo> activeAnimation = this.getActiveAnimation(controller.getName());
        if (activeAnimation.isPresent() && this.tryForcedAnimation(state, activeAnimation.get())) {
            return PlayState.CONTINUE;
        }
        controller.transitionLength(5);
        double animationSpeed = 1.0;
        if (!((PrehistoricFlying)state.getAnimatable()).isTakingOff()) {
            if (((PrehistoricFlying)state.getAnimatable()).method_6581()) {
                if (this.entity.method_5624()) {
                    this.addActiveAnimation(controller.getName(), AnimationCategory.FLY_FAST);
                } else {
                    this.addActiveAnimation(controller.getName(), AnimationCategory.FLY);
                }
            } else if (this.entity.method_6113()) {
                this.addActiveAnimation(controller.getName(), AnimationCategory.SLEEP);
            } else if (((PrehistoricFlying)state.getAnimatable()).sitSystem.isSitting()) {
                this.addActiveAnimation(controller.getName(), AnimationCategory.SIT);
            } else if (((PrehistoricFlying)state.getAnimatable()).isClimbing()) {
                this.addActiveAnimation(controller.getName(), AnimationCategory.CLIMB);
            } else if (this.entity.method_5799()) {
                ActiveAnimationInfo info = this.addActiveAnimation(controller.getName(), AnimationCategory.SWIM, true);
                if (info != null) {
                    this.additionalLogic.put(info, () -> this.entity.method_24828());
                }
            } else if (!this.entity.method_24828()) {
                this.addActiveAnimation(controller.getName(), AnimationCategory.FLY);
                controller.transitionLength(10);
                animationSpeed = 0.5;
            } else if (state.isMoving()) {
                animationSpeed = this.addMovementAnimation(state, false);
            } else {
                this.addActiveAnimation(controller.getName(), AnimationCategory.IDLE);
            }
        }
        AnimationLogic.setAnimationSpeed(controller, animationSpeed, state.getAnimationTick());
        Optional<ActiveAnimationInfo> newAnimation = this.getActiveAnimation(controller.getName());
        newAnimation.ifPresent(newInfo -> state.setAnimation(RawAnimation.begin().then(newInfo.animationName(), newInfo.loop ? Animation.LoopType.LOOP : Animation.LoopType.DEFAULT)));
        return PlayState.CONTINUE;
    }

    public record ActiveAnimationInfo(String animationName, double endTick, AnimationCategory category, boolean forced, int transitionLength, double speed, boolean loop, boolean keepActive) {
    }

    public static class Builder {
        private final String animationName;
        private final double endTick;
        private final AnimationCategory category;
        private boolean forced;
        private int transitionLength;
        private double speed = 1.0;
        private boolean loop;
        private boolean keepActive;

        public Builder(Animation animation, long currentTime, AnimationCategory category) {
            this.animationName = animation.name();
            this.endTick = (double)currentTime + animation.length();
            this.category = category;
            this.transitionLength = category.transitionLength();
            this.loop = animation.loopType() == Animation.LoopType.LOOP;
        }

        public Builder(String animationName, double endTick, AnimationCategory category) {
            this.animationName = animationName;
            this.endTick = endTick;
            this.category = category;
            this.transitionLength = category.transitionLength();
        }

        public Builder forced() {
            this.forced = true;
            return this;
        }

        public Builder transitionLength(int length) {
            this.transitionLength = length;
            return this;
        }

        public Builder speed(double speed) {
            this.speed = speed;
            return this;
        }

        public Builder loop(boolean loop) {
            this.loop = loop;
            return this;
        }

        public Builder loop() {
            this.loop = true;
            return this;
        }

        public Builder keepActive(boolean keepActive) {
            this.keepActive = keepActive;
            return this;
        }

        public ActiveAnimationInfo build() {
            return new ActiveAnimationInfo(this.animationName, this.endTick, this.category, this.forced, this.transitionLength, this.speed, this.loop, this.keepActive);
        }
    }
}

