/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.animation;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationCategoryLoader;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationInfoLoader;
import com.github.teamfossilsarcheology.fossil.entity.animation.BakedAnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.animation.ClientAnimationInfo;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import software.bernie.geckolib.cache.GeckoLibCache;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.loading.object.BakedAnimations;

public class ClientAnimationInfoLoader
extends AnimationInfoLoader<ClientAnimationInfo> {
    private static final BakedAnimationInfo<ClientAnimationInfo> EMPTY = new BakedAnimationInfo(Object2ObjectMaps.emptyMap());
    public static final ClientAnimationInfoLoader INSTANCE = new ClientAnimationInfoLoader(new GsonBuilder().create());
    private Map<class_2960, BakedAnimationInfo<ClientAnimationInfo>> clientAnimationInfos = ImmutableMap.of();

    public ClientAnimationInfoLoader(Gson gson) {
        super(gson, "animations/entity/data");
    }

    protected void apply(Map<class_2960, JsonElement> jsons, class_3300 resourceManager, class_3695 profiler) {
        Object2ObjectOpenHashMap data = new Object2ObjectOpenHashMap();
        for (Map.Entry<class_2960, JsonElement> fileEntry : jsons.entrySet()) {
            JsonElement jsonElement = fileEntry.getValue();
            if (!(jsonElement instanceof JsonObject)) continue;
            JsonObject root = (JsonObject)jsonElement;
            if (!fileEntry.getKey().method_12836().equals("fossil")) continue;
            ImmutableMap.Builder innerBuilder = ImmutableMap.builder();
            for (Map.Entry entry : class_3518.method_15296((JsonObject)root, (String)"animations").getAsJsonObject().entrySet()) {
                JsonObject animationObj = ((JsonElement)entry.getValue()).getAsJsonObject();
                double blockSpeed = animationObj.has("blocks_per_second") ? class_3518.method_34927((JsonObject)animationObj, (String)"blocks_per_second") : 0.0;
                innerBuilder.put((Object)((String)entry.getKey()), (Object)blockSpeed);
            }
            class_2960 path = FossilMod.location("animations/entity/" + fileEntry.getKey().method_12832() + ".animation.json");
            data.put(path, innerBuilder.build());
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry fileEntry : GeckoLibCache.getBakedAnimations().entrySet()) {
            if (!((class_2960)fileEntry.getKey()).method_12836().equals("fossil")) continue;
            Object2ObjectOpenHashMap bakedMap = new Object2ObjectOpenHashMap();
            for (Map.Entry entry : ((BakedAnimations)fileEntry.getValue()).animations().entrySet()) {
                double blocksPerSecond = ((Map)data.getOrDefault(fileEntry.getKey(), new HashMap())).getOrDefault(entry.getKey(), 0.0);
                bakedMap.put((String)entry.getKey(), new ClientAnimationInfo((Animation)entry.getValue(), blocksPerSecond));
            }
            builder.put((Object)((class_2960)fileEntry.getKey()), new BakedAnimationInfo(bakedMap));
        }
        this.clientAnimationInfos = builder.build();
        FossilMod.LOGGER.info("Loaded {} client animations for {} entities", (Object)this.clientAnimationInfos.values().stream().map(info -> info.animations().size()).reduce(Integer::sum).orElse(0), (Object)this.clientAnimationInfos.size());
        AnimationCategoryLoader.CLIENT.apply(this.clientAnimationInfos);
    }

    @Override
    public Map<class_2960, BakedAnimationInfo<ClientAnimationInfo>> getAnimationInfos() {
        return this.clientAnimationInfos;
    }

    @Override
    public BakedAnimationInfo<ClientAnimationInfo> getAnimations(class_2960 animationFile) {
        return this.clientAnimationInfos.getOrDefault(animationFile, EMPTY);
    }
}

