/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.entity.ai.FleeBattleGoal;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricFlocking;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricShearable;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import com.github.teamfossilsarcheology.fossil.sounds.ModSounds;
import com.github.teamfossilsarcheology.fossil.util.Gender;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_6908;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Mammoth
extends PrehistoricFlocking
implements PrehistoricShearable {
    private static final class_2940<Boolean> SHEARED = class_2945.method_12791(Mammoth.class, (class_2941)class_2943.field_13323);
    private int woolRegenTicks;

    public Mammoth(class_1299<Mammoth> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(3, (class_1352)new FleeBattleGoal(this, 1.0));
    }

    @Override
    public void refreshTexturePath() {
        if (!this.method_37908().field_9236) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("textures/entity/mammoth/mammoth");
        if (this.method_6109()) {
            builder.append("_baby");
        }
        if (this.isTeen() || this.isAdult()) {
            if (this.getGender() == Gender.MALE) {
                builder.append("_male");
            } else {
                builder.append("_female");
            }
        }
        if (this.method_6113()) {
            builder.append("_sleeping");
        }
        if (this.isSheared()) {
            builder.append("_shaved");
        }
        builder.append(".png");
        this.textureLocation = FossilMod.location(builder.toString());
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SHEARED, (Object)false);
    }

    @Override
    public void method_5674(class_2940<?> key) {
        if (SHEARED.equals(key)) {
            this.refreshTexturePath();
        }
        super.method_5674(key);
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("Sheared", this.isSheared());
        compound.method_10569("WoolRegenTicks", this.woolRegenTicks);
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setSheared(compound.method_10577("Sheared"));
        this.woolRegenTicks = compound.method_10550("WoolRegenTicks");
    }

    @Override
    public PrehistoricEntityInfo info() {
        return PrehistoricEntityInfo.MAMMOTH;
    }

    @Override
    protected int getMaxGroupSize() {
        return 7;
    }

    @Override
    public void method_6007() {
        boolean tooWarm = this.method_37908().method_23753(this.method_24515()).method_40220(class_6908.field_41753);
        if (tooWarm && this.method_6112(class_1294.field_5911) != null && !this.isSheared()) {
            this.method_6092(new class_1293(class_1294.field_5911, 60, 1));
        }
        super.method_6007();
    }

    @Override
    public void feed(int foodAmount) {
        super.feed(foodAmount);
        if (this.isSheared()) {
            this.woolRegenTicks += foodAmount;
            if (this.woolRegenTicks >= 150) {
                this.setSheared(false);
                this.woolRegenTicks = 0;
            }
        }
    }

    @Override
    public class_1792 getOrderItem() {
        return class_1802.field_8600;
    }

    @Override
    public double method_5621() {
        double d = 0.35;
        return super.method_5621() + d;
    }

    @Override
    @NotNull
    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_31574(class_1802.field_8868) && this.method_27072()) {
            this.method_6636(class_3419.field_15248);
            this.method_32875(class_5712.field_28730, (class_1297)player);
            if (!this.method_37908().field_9236) {
                itemStack.method_7956(1, (class_1309)player, player2 -> player2.method_20236(hand));
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return super.method_5992(player, hand);
    }

    public void method_6636(class_3419 source) {
        this.method_37908().method_43129(null, (class_1297)this, class_3417.field_14975, source, 1.0f, 1.0f);
        this.setSheared(true);
        int maxWool = 1 + this.field_5974.method_43048(20);
        for (int i = 0; i < maxWool; ++i) {
            class_1542 itemEntity = this.method_5870((class_1935)ModItems.MAMMOTH_FUR.get(), 1);
            if (itemEntity == null) continue;
            itemEntity.method_18799(itemEntity.method_18798().method_1031((double)(this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.1, (double)this.field_5974.method_43057() * 0.05, (double)(this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.1));
        }
    }

    @Override
    public class_1315 method_5943(class_5425 levelIn, class_1266 difficultyIn, class_3730 reason, @Nullable class_1315 spawnDataIn, @Nullable class_2487 dataTag) {
        class_1315 data = super.method_5943(levelIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (this.method_6109()) {
            this.setSheared(true);
        }
        return data;
    }

    public boolean method_27072() {
        return !this.isSheared() && !this.method_6109();
    }

    @Override
    public boolean isSheared() {
        return (Boolean)this.field_6011.method_12789(SHEARED);
    }

    @Override
    public void setSheared(boolean sheared) {
        this.field_6011.method_12778(SHEARED, (Object)sheared);
    }

    @Override
    public float getGenderedScale() {
        return this.getGender() == Gender.MALE ? 1.15f : super.getGenderedScale();
    }

    @Override
    public float getTargetScale() {
        return 1.5f;
    }

    @Nullable
    protected class_3414 method_5994() {
        return (class_3414)ModSounds.MAMMOTH_AMBIENT.get();
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSource) {
        return (class_3414)ModSounds.MAMMOTH_HURT.get();
    }

    @Nullable
    protected class_3414 method_6002() {
        return (class_3414)ModSounds.MAMMOTH_DEATH.get();
    }
}

