/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.base;

import com.github.teamfossilsarcheology.fossil.entity.ai.FlockBuildGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.FlockWanderGoal;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_5534;

public abstract class PrehistoricFlocking
extends Prehistoric {
    protected int groupSize = 1;
    protected PrehistoricFlocking groupLeader;
    protected long flockAttackedTick;
    protected class_1309 flockAttackedTarget;

    protected PrehistoricFlocking(class_1299<? extends Prehistoric> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new FlockBuildGoal(this));
        this.field_6201.method_6277(21, (class_1352)new FlockWanderGoal(this, 1.0));
    }

    public void setFlockAttacked(class_1309 target) {
        this.flockAttackedTick = this.method_37908().method_8510();
        this.flockAttackedTarget = target;
    }

    public class_1309 getFlockAttackedTarget() {
        return this.flockAttackedTarget;
    }

    public void leaveGroup() {
        if (this.groupLeader != null) {
            this.groupLeader.decreaseGroupSize();
            this.groupLeader = null;
        }
    }

    public boolean hasGroupLeader() {
        return this.groupLeader != null;
    }

    public void increaseGroupSize() {
        ++this.groupSize;
    }

    public void decreaseGroupSize() {
        --this.groupSize;
    }

    public boolean canGroupGrow() {
        return this.isGroupLeader() && this.groupSize < this.getMaxGroupSize();
    }

    public boolean isGroupLeader() {
        return this.groupSize > 1;
    }

    public boolean inRangeOfGroupLeader() {
        return this.method_5858((class_1297)this.groupLeader) <= 151.0;
    }

    public boolean isPartOfSameFlock(PrehistoricFlocking other) {
        return this.groupLeader != null && (other.groupLeader == this || this.groupLeader == other || other.groupLeader == this.groupLeader);
    }

    public void pathToGroupLeader(double speed) {
        class_243 vec;
        if (this.hasGroupLeader() && (vec = this.method_5739((class_1297)this.groupLeader) < 7.0f ? class_5534.method_31527((class_1314)this, (int)5, (int)7) : class_5534.method_31527((class_1314)this.groupLeader, (int)5, (int)7)) != null) {
            this.method_5942().method_6337(vec.field_1352, vec.field_1351, vec.field_1350, speed);
        }
    }

    public PrehistoricFlocking startFollowing(PrehistoricFlocking groupLeader) {
        this.groupLeader = groupLeader;
        groupLeader.increaseGroupSize();
        return groupLeader;
    }

    public void addFollowers(Stream<? extends PrehistoricFlocking> followers) {
        followers.filter(dino -> dino != this).limit(this.getMaxGroupSize() - this.groupSize).forEach(dino -> dino.startFollowing(this));
    }

    @Override
    public void method_6007() {
        if (this.hasGroupLeader() && !this.groupLeader.method_5805()) {
            this.leaveGroup();
        }
        super.method_6007();
        if (this.hasGroupLeader() && this.method_37908().field_9229.method_43048(200) == 1 && this.method_37908().method_8390(this.getClass(), this.method_5829().method_1014((double)this.getFlockDistance()), flocking -> flocking == this.groupLeader).isEmpty()) {
            this.leaveGroup();
        }
        if (this.flockAttackedTarget != null && this.flockAttackedTick < this.method_37908().method_8510() - 100L) {
            this.flockAttackedTarget = null;
        }
    }

    protected abstract int getMaxGroupSize();

    public int getFlockDistance() {
        return 32;
    }
}

