/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.base;

import com.github.teamfossilsarcheology.fossil.entity.LaserPointEntity;
import com.github.teamfossilsarcheology.fossil.entity.ai.AmphibiousWanderGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DelayedAttackGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoFollowOwnerGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoMatingGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoPanicGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoRandomSwimGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.EatBlockGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.EatFromFeederGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.EatItemEntityGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.EnterWaterGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.GrabMeleeAttackGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.HuntingTargetGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.PassiveFoodGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.WaterPlayGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.control.CustomSwimMoveControl;
import com.github.teamfossilsarcheology.fossil.entity.ai.control.PrehistoricLookControl;
import com.github.teamfossilsarcheology.fossil.entity.ai.control.SmoothTurningMoveControl;
import com.github.teamfossilsarcheology.fossil.entity.ai.navigation.AmphibiousPathNavigation;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.animation.PausableAnimationController;
import com.github.teamfossilsarcheology.fossil.entity.damagesource.ModDamageTypes;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfoAI;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.SwimmingAnimal;
import com.github.teamfossilsarcheology.fossil.food.Diet;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1313;
import net.minecraft.class_1332;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1432;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_4538;
import net.minecraft.class_5134;
import net.minecraft.class_6862;
import net.minecraft.class_7;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animation.AnimatableManager;

public abstract class PrehistoricSwimming
extends Prehistoric
implements SwimmingAnimal {
    public static final int MAX_TIME_IN_WATER = 1000;
    public static final int MAX_TIME_ON_LAND = 1000;
    private static final class_2940<Boolean> GRABBING = class_2945.method_12791(PrehistoricSwimming.class, (class_2941)class_2943.field_13323);
    private int timeInWater = 0;
    private int timeOnLand = 0;
    protected boolean isLandNavigator;
    private boolean beached;

    protected PrehistoricSwimming(class_1299<? extends Prehistoric> entityType, class_1937 level, class_2960 animationLocation) {
        super(entityType, level, animationLocation);
        this.method_5941(class_7.field_18, 0.0f);
        this.switchNavigator(false);
    }

    protected PrehistoricSwimming(class_1299<? extends Prehistoric> entityType, class_1937 level) {
        super(entityType, level);
        this.method_5941(class_7.field_18, 0.0f);
        this.switchNavigator(false);
    }

    @Override
    protected void method_5959() {
        this.matingGoal = new DinoMatingGoal(this, 1.0);
        this.field_6201.method_6277(1, (class_1352)new DinoPanicGoal(this, this.attributes().sprintMod()));
        if (this.aiAttackType() == PrehistoricEntityInfoAI.Attacking.GRAB) {
            this.field_6201.method_6277(5, (class_1352)new GrabMeleeAttackGoal(this, this.attributes().sprintMod(), false));
        } else if (this.aiAttackType() != PrehistoricEntityInfoAI.Attacking.NONE) {
            this.field_6201.method_6277(5, new DelayedAttackGoal<PrehistoricSwimming>(this, this.attributes().sprintMod(), false));
        }
        this.field_6201.method_6277(12, (class_1352)this.matingGoal);
        if (this.data().diet() != Diet.PASSIVE) {
            this.field_6201.method_6277(15, (class_1352)new EatFromFeederGoal(this));
            this.field_6201.method_6277(16, (class_1352)new EatItemEntityGoal(this));
            this.field_6201.method_6277(17, (class_1352)new EatBlockGoal(this));
        } else {
            this.field_6201.method_6277(15, (class_1352)new PassiveFoodGoal(this));
        }
        this.field_6201.method_6277(18, new WaterPlayGoal<PrehistoricSwimming>(this, 1.0));
        this.field_6201.method_6277(20, (class_1352)new DinoFollowOwnerGoal(this, this.attributes().sprintMod(), 7.0f, 2.0f, false));
        this.field_6201.method_6277(21, new EnterWaterGoal<PrehistoricSwimming>(this, 1.0f));
        this.field_6201.method_6277(22, new DinoRandomSwimGoal<PrehistoricSwimming>(this, 1.0));
        this.field_6201.method_6277(23, (class_1352)new AmphibiousWanderGoal(this, 1.0));
        this.field_6201.method_6277(25, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(26, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(5, (class_1352)new HuntingTargetGoal(this));
        this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, LaserPointEntity.class, true));
    }

    public static boolean isOverWater(class_1309 entity) {
        if (entity.method_37908().method_8316(entity.method_24515().method_10074()).method_15767(class_3486.field_15517)) {
            return true;
        }
        if (entity.method_37908().method_8316(entity.method_24515().method_10087(2)).method_15767(class_3486.field_15517)) {
            return true;
        }
        return entity.method_37908().method_8316(entity.method_24515().method_10087(3)).method_15767(class_3486.field_15517);
    }

    @Override
    protected void method_20417() {
        boolean bl = !this.isBeached() && !this.method_6113();
        this.field_6201.method_6276(class_1352.class_4134.field_18405, bl && !this.sitSystem.isSitting());
        this.field_6201.method_6276(class_1352.class_4134.field_18407, bl && !this.sitSystem.isSitting());
        this.field_6201.method_6276(class_1352.class_4134.field_18406, bl);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(GRABBING, (Object)false);
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("TimeInWater", this.timeInWater);
        compound.method_10569("TimeOnLand", this.timeOnLand);
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.timeInWater = compound.method_10550("TimeInWater");
        this.timeOnLand = compound.method_10550("TimeOnLand");
    }

    @Override
    @NotNull
    protected class_1408 method_5965(class_1937 level) {
        return new AmphibiousPathNavigation<PrehistoricSwimming>(this, level);
    }

    protected void switchNavigator(boolean onLand) {
        if (onLand) {
            this.field_6207 = new SmoothTurningMoveControl(this);
            this.field_6206 = new PrehistoricLookControl(this);
            this.isLandNavigator = true;
        } else {
            this.field_6207 = new CustomSwimMoveControl<PrehistoricSwimming>(this);
            this.field_6206 = new class_1332((class_1308)this, 20);
            this.isLandNavigator = false;
        }
    }

    @NotNull
    public class_1310 method_6046() {
        return class_1310.field_6292;
    }

    public boolean method_5957(class_4538 level) {
        return level.method_8606((class_1297)this);
    }

    public boolean method_5675() {
        return false;
    }

    @Override
    public boolean isAmphibious() {
        return this.aiMovingType() == PrehistoricEntityInfoAI.Moving.SEMI_AQUATIC;
    }

    @Override
    public boolean canSwim() {
        return this.aiMovingType() == PrehistoricEntityInfoAI.Moving.AQUATIC || this.aiMovingType() == PrehistoricEntityInfoAI.Moving.SEMI_AQUATIC;
    }

    @Override
    public double swimSpeed() {
        return this.swimSpeed;
    }

    public boolean method_6094() {
        return true;
    }

    @NotNull
    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28632;
    }

    @Override
    public void method_6007() {
        super.method_6007();
        boolean wasBeached = this.beached;
        boolean inWater = this.method_5799();
        boolean bl = this.beached = !this.isAmphibious() && !inWater && this.method_24828();
        if (!this.method_37908().field_9236) {
            if (this.isAmphibious()) {
                if (this.isLandNavigator && inWater) {
                    this.switchNavigator(false);
                } else if (!this.isLandNavigator && !inWater && this.method_24828()) {
                    this.switchNavigator(true);
                }
            } else if (this.isLandNavigator) {
                this.switchNavigator(false);
            }
            if (inWater) {
                ++this.timeInWater;
                this.timeOnLand = 0;
                this.method_5875(true);
                if (this.method_6113() && this.method_37908().method_8320(this.method_24515().method_10069(0, (int)(this.method_17682() + 1.0f), 0)).method_26215()) {
                    this.method_5875(false);
                }
            } else if (this.method_24828()) {
                this.timeInWater = 0;
                ++this.timeOnLand;
            } else {
                this.method_5875(false);
            }
            if (this.isDoingGrabAttack() && !this.method_5782()) {
                this.setDoingGrabAttack(false);
            }
        } else {
            if (wasBeached != this.beached) {
                this.refreshTexturePath();
            }
            if (this.beached) {
                this.method_36457(0.0f);
            }
        }
    }

    protected void method_6010(class_6862<class_3611> fluidTag) {
        this.method_18799(this.method_18798().method_1031(0.0, 0.3, 0.0));
    }

    public void method_29242(boolean isFlying) {
        super.method_29242(this.method_5799());
    }

    protected float method_6031(float yRot, float animStep) {
        if (this.isBeached()) {
            return animStep;
        }
        return super.method_6031(yRot, animStep);
    }

    protected void handleAirSupply(int airSupply) {
        if (!this.canBreatheOnLand() && this.method_5805() && !this.method_5816() && !this.method_5987()) {
            this.method_5855(airSupply - 1);
            if (this.method_5669() == -40) {
                this.method_5855(0);
                this.method_5643(this.method_48923().method_48795(ModDamageTypes.SUFFOCATE_KEY), 2.0f);
            }
        } else {
            this.method_5855(500);
        }
    }

    @Override
    public void method_5865(class_1297 passenger, class_1297.class_4738 callback) {
        super.method_5865(passenger, callback);
        if (passenger != this.getRidingPlayer() && this.isDoingGrabAttack()) {
            this.getEntityHitboxData().getAnchorData().getAnchorPos("grab_pos").ifPresentOrElse(pos -> callback.accept(passenger, pos.field_1352, pos.field_1351 + passenger.method_5678(), pos.field_1350), () -> {
                float t = 5.0f * class_3532.method_15374((float)((float)Math.PI + (float)this.field_6012 * 0.275f));
                float radius = 0.24499999f * this.method_17825() * -3.0f;
                float angle = (float)Math.PI / 180 * this.field_6283 + 3.15f + t * 1.75f * 0.05f;
                double extraX = radius * class_3532.method_15374((float)((float)Math.PI + angle));
                double extraY = 0.065 * (double)this.method_17825();
                double extraZ = radius * class_3532.method_15362((float)angle);
                callback.accept(passenger, this.method_23317() + extraX, this.method_23318() + extraY, this.method_23321() + extraZ);
            });
        }
    }

    public float grabTargetSize() {
        return this.method_17681() / 2.0f;
    }

    @Override
    public void startGrabAttack(class_1297 target) {
        target.method_5804((class_1297)this);
        this.setDoingGrabAttack(true);
    }

    @Override
    public void stopGrabAttack(class_1297 target) {
        target.method_5848();
        this.setDoingGrabAttack(false);
    }

    public void method_5670() {
        int i = this.method_5669();
        super.method_5670();
        this.handleAirSupply(i);
    }

    @Override
    public void disableCustomAI(byte type, boolean disableAI) {
        if (type == 0 || type == 2) {
            super.disableCustomAI(type, disableAI);
            this.method_5875(disableAI);
        } else {
            super.disableCustomAI(type, disableAI);
        }
    }

    @Override
    public void method_6091(class_243 travelVector) {
        if (this.method_6062() && !this.method_5782() || !this.isAmphibious() && !this.method_5799()) {
            super.method_6091(class_243.field_1353);
            return;
        }
        class_1309 rider = this.method_5642();
        if (rider == null || !this.canBeControlledByRider() || this.method_5787() && !this.steering.trySteering(rider)) {
            if (this.method_6034() && this.method_5799()) {
                this.method_5724(this.method_6029(), travelVector);
                this.method_5784(class_1313.field_6308, this.method_18798());
                this.method_18799(this.method_18798().method_1021(0.9));
                if (!this.method_5740() && this.method_37908().method_8316(this.method_24515().method_10074()).method_15767(class_3486.field_15517)) {
                    this.method_18799(this.method_18798().method_1031(0.0, -0.005, 0.0));
                }
                this.method_29242(this instanceof class_1432);
            } else {
                super.method_6091(travelVector);
            }
            return;
        }
        if (!this.method_5799()) {
            super.method_6091(travelVector);
            return;
        }
        this.method_36456(rider.method_36454());
        this.field_5982 = this.method_36454();
        this.method_36457(rider.method_36455() * 0.5f);
        this.method_5710(this.method_36454(), this.method_36455());
        this.field_6283 = this.method_36454();
        this.field_6241 = this.method_36454();
        float newStrafeMovement = rider.field_6212 * 0.5f;
        float newForwardMovement = rider.field_6250;
        if (this.method_5787()) {
            this.method_6125((float)this.method_26825(class_5134.field_23719));
            this.steering.waterTravel(new class_243((double)newStrafeMovement, travelVector.field_1351, (double)newForwardMovement), (class_1657)rider);
        } else {
            this.method_18799(class_243.field_1353);
            this.method_29242(this instanceof class_1432);
        }
    }

    public void method_5764(boolean downwards) {
        if (this.method_17681() < 2.0f) {
            super.method_5764(downwards);
        }
    }

    @Override
    public boolean method_6101() {
        return false;
    }

    public void destroyBoat(class_1297 targetSailor) {
        class_1297 class_12972 = targetSailor.method_5854();
        if (class_12972 instanceof class_1690) {
            class_1690 boat = (class_1690)class_12972;
            if (!this.method_37908().field_9236) {
                boat.method_5768();
                if (this.method_37908().method_8450().method_8355(class_1928.field_19393)) {
                    int i;
                    for (i = 0; i < 3; ++i) {
                        this.method_5706((class_1935)boat.method_47885().method_7560());
                    }
                    for (i = 0; i < 2; ++i) {
                        this.method_5706((class_1935)class_1802.field_8600);
                    }
                }
            }
        }
    }

    @Override
    public boolean canBeControlledByRider() {
        return !this.isAmphibious() ? this.method_5799() && super.canBeControlledByRider() : super.canBeControlledByRider();
    }

    public boolean isBeached() {
        return this.beached;
    }

    @Override
    public int timeInWater() {
        return this.timeInWater;
    }

    @Override
    public int timeOnLand() {
        return this.timeOnLand;
    }

    @Override
    public boolean isDoingGrabAttack() {
        return (Boolean)this.field_6011.method_12789(GRABBING);
    }

    public void setDoingGrabAttack(boolean grabbing) {
        this.field_6011.method_12778(GRABBING, (Object)grabbing);
    }

    @NotNull
    public AnimationInfo nextGrabbingAnimation() {
        return this.nextIdleAnimation();
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        PausableAnimationController<PrehistoricSwimming> controller = new PausableAnimationController<PrehistoricSwimming>(this, "Movement/Idle", 5, this.getAnimationLogic()::waterPredicate);
        this.registerEatingListeners(controller);
        this.registerControllerWithTriggers(controllerRegistrar, controller);
        this.registerControllerWithTriggers(controllerRegistrar, new PausableAnimationController<PrehistoricSwimming>(this, "Attack", 5, this.getAnimationLogic()::grabAttackPredicate));
    }

    public int method_5978() {
        return 1;
    }

    public int method_5986() {
        return 1;
    }
}

