/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.prehistoric.swimming;

import com.github.teamfossilsarcheology.fossil.entity.ai.DinoHurtByTargetGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoOwnerHurtByTargetGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.DinoOwnerHurtTargetGoal;
import com.github.teamfossilsarcheology.fossil.entity.ai.LeaveWaterGoal;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationCategory;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationInfo;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationLogic;
import com.github.teamfossilsarcheology.fossil.entity.animation.PausableAnimationController;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricSwimming;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import com.github.teamfossilsarcheology.fossil.sounds.ModSounds;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1352;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_3414;
import net.minecraft.class_3486;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class Spinosaurus
extends PrehistoricSwimming {
    public static final String GRAB = "animation.spinosaurus.grab";
    public static final String IDLE = "animation.spinosaurus.idle";
    public static final String IDLE_WATER = "animation.spinosaurus.idle_water";
    public static final String IDLE_WATER_FLOAT = "animation.spinosaurus.idle_water_float";
    public static final String SWIM_FLOATING = "animation.spinosaurus.swim_floating";
    public static final String SWIM_UNDERWATER = "animation.spinosaurus.swim_underwater";
    public static final String SWIM_GROUND = "animation.spinosaurus.swim_ground";
    private final SpinoAnimationLogic animationLogic = new SpinoAnimationLogic(this);

    public Spinosaurus(class_1299<Spinosaurus> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(21, new LeaveWaterGoal<Spinosaurus>(this, 1.0));
        this.field_6185.method_6277(1, (class_1352)new DinoOwnerHurtByTargetGoal(this));
        this.field_6185.method_6277(2, (class_1352)new DinoOwnerHurtTargetGoal(this));
        this.field_6185.method_6277(3, (class_1352)new DinoHurtByTargetGoal(this));
    }

    @Override
    public PrehistoricEntityInfo info() {
        return PrehistoricEntityInfo.SPINOSAURUS;
    }

    @Override
    public class_1792 getOrderItem() {
        return (class_1792)ModItems.SKULL_STICK.get();
    }

    @Override
    public float getTargetScale() {
        return 1.5f;
    }

    @Override
    public float grabTargetSize() {
        return this.method_17681();
    }

    @Override
    @NotNull
    public AnimationInfo nextGrabbingAnimation() {
        return this.getAllAnimations().get(GRAB);
    }

    @Nullable
    protected class_3414 method_5994() {
        return (class_3414)ModSounds.SPINOSAURUS_AMBIENT.get();
    }

    @Nullable
    protected class_3414 method_6011(class_1282 damageSource) {
        return (class_3414)ModSounds.SPINOSAURUS_HURT.get();
    }

    @Nullable
    protected class_3414 method_6002() {
        return (class_3414)ModSounds.SPINOSAURUS_DEATH.get();
    }

    @Override
    public AnimationLogic<Prehistoric> getAnimationLogic() {
        return this.animationLogic;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        PausableAnimationController<Spinosaurus> controller = new PausableAnimationController<Spinosaurus>(this, "Movement/Idle", 5, this.animationLogic::spinoPredicate);
        this.registerEatingListeners(controller);
        controllerRegistrar.add(new AnimationController[]{controller});
        AnimationController[] animationControllerArray = new AnimationController[1];
        animationControllerArray[0] = new PausableAnimationController<Spinosaurus>(this, "Attack", 0, this.getAnimationLogic()::grabAttackPredicate);
        controllerRegistrar.add(animationControllerArray);
    }

    static class SpinoAnimationLogic
    extends AnimationLogic<Prehistoric> {
        public SpinoAnimationLogic(PrehistoricSwimming entity) {
            super(entity);
        }

        public PlayState spinoPredicate(AnimationState<PrehistoricSwimming> state) {
            if (this.isBlocked()) {
                return PlayState.STOP;
            }
            AnimationController controller = state.getController();
            if (this.tryNextAnimation(state, controller)) {
                return PlayState.CONTINUE;
            }
            Optional<AnimationLogic.ActiveAnimationInfo> activeAnimation = this.getActiveAnimation(controller.getName());
            if (activeAnimation.isPresent() && this.tryForcedAnimation(state, activeAnimation.get())) {
                return PlayState.CONTINUE;
            }
            double animationSpeed = 1.0;
            if (((PrehistoricSwimming)state.getAnimatable()).isBeached()) {
                this.addActiveAnimation(controller.getName(), AnimationCategory.BEACHED);
            } else if (((Prehistoric)this.entity).method_6113()) {
                this.addActiveAnimation(controller.getName(), AnimationCategory.SLEEP);
            } else if (state.isMoving()) {
                if (((Prehistoric)this.entity).method_5799()) {
                    boolean onGround;
                    boolean bl = onGround = ((Prehistoric)this.entity).method_23318() - Math.floor(((Prehistoric)this.entity).method_23318()) < 0.05 && ((Prehistoric)this.entity).method_37908().method_8316(((Prehistoric)this.entity).method_24515().method_10074()).method_15769();
                    if (((Prehistoric)this.entity).method_5777(class_3486.field_15517)) {
                        if (onGround) {
                            this.addActiveAnimation(controller.getName(), ((Prehistoric)this.entity).getAnimation((String)Spinosaurus.SWIM_GROUND).animation, AnimationCategory.SWIM, false);
                        } else {
                            this.addActiveAnimation(controller.getName(), ((Prehistoric)this.entity).getAnimation((String)Spinosaurus.SWIM_UNDERWATER).animation, AnimationCategory.SWIM, false);
                        }
                    } else if (onGround) {
                        animationSpeed = this.addMovementAnimation(state, false);
                    } else {
                        this.addActiveAnimation(controller.getName(), ((Prehistoric)this.entity).getAnimation((String)Spinosaurus.SWIM_FLOATING).animation, AnimationCategory.SWIM, false);
                    }
                } else {
                    animationSpeed = this.addMovementAnimation(state, false);
                }
            } else if (((PrehistoricSwimming)state.getAnimatable()).isWeak()) {
                this.addActiveAnimation(controller.getName(), AnimationCategory.KNOCKOUT);
            } else if (((Prehistoric)this.entity).method_5799()) {
                if (((Prehistoric)this.entity).method_5777(class_3486.field_15517)) {
                    this.addActiveAnimation(controller.getName(), ((Prehistoric)this.entity).getAnimation((String)Spinosaurus.IDLE_WATER).animation, AnimationCategory.IDLE, false);
                } else {
                    this.addActiveAnimation(controller.getName(), ((Prehistoric)this.entity).getAnimation((String)Spinosaurus.IDLE_WATER_FLOAT).animation, AnimationCategory.IDLE, false);
                }
            } else {
                this.addActiveAnimation(controller.getName(), ((Prehistoric)this.entity).getAnimation((String)Spinosaurus.IDLE).animation, AnimationCategory.IDLE, false);
            }
            SpinoAnimationLogic.setAnimationSpeed(controller, animationSpeed, state.getAnimationTick());
            Optional<AnimationLogic.ActiveAnimationInfo> newAnimation = this.getActiveAnimation(controller.getName());
            if (newAnimation.isPresent()) {
                controller.setAnimation(RawAnimation.begin().then(newAnimation.get().animationName(), newAnimation.get().loop() ? Animation.LoopType.LOOP : Animation.LoopType.PLAY_ONCE));
            }
            return PlayState.CONTINUE;
        }
    }
}

