/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.util;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.InstructionTab;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.instruction.Instruction;
import com.github.teamfossilsarcheology.fossil.entity.ai.navigation.AmphibiousPathNavigation;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationCategory;
import com.github.teamfossilsarcheology.fossil.entity.animation.AnimationLogic;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.Parasaurolophus;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricFlying;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricLeaping;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.swimming.Meganeura;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.system.AISystem;
import com.github.teamfossilsarcheology.fossil.network.MessageHandler;
import com.github.teamfossilsarcheology.fossil.network.debug.InstructionMessage;
import com.github.teamfossilsarcheology.fossil.util.Version;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_1412;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_3218;

public class InstructionSystem
extends AISystem {
    private final List<Instruction> instructions = new ObjectArrayList();
    private int index = -1;
    private boolean shouldLoop;
    private int tries;
    private long endTick;
    private long delayTick;
    private boolean breachTargetReached;
    private boolean attached;
    private AnimationLogic.ActiveAnimationInfo activeAnim;
    private long animCount;

    public InstructionSystem(Prehistoric entity) {
        super(entity);
    }

    @Override
    public void serverTick() {
        if (this.instructions.isEmpty() || this.index >= this.instructions.size() || !Version.debugEnabled()) {
            return;
        }
        if (!this.tickRunning()) {
            this.startNext();
        }
    }

    private boolean tickRunning() {
        Prehistoric prehistoric;
        boolean debug = false;
        Instruction current = this.instructions.get(this.index);
        if (this.mob.isHungry()) {
            this.mob.setHunger(this.mob.getMaxHunger());
        }
        if ((prehistoric = this.mob) instanceof Parasaurolophus) {
            Parasaurolophus parasaurolophus = (Parasaurolophus)prehistoric;
            parasaurolophus.setStanding(false);
        }
        if (current instanceof Instruction.MoveTo) {
            Instruction.MoveTo moveTo = (Instruction.MoveTo)current;
            return this.tryUpdatePath(moveTo);
        }
        if (current instanceof Instruction.FlyTo) {
            Instruction.FlyTo flyTo = (Instruction.FlyTo)current;
            Prehistoric prehistoric2 = this.mob;
            if (prehistoric2 instanceof PrehistoricFlying) {
                PrehistoricFlying flying = (PrehistoricFlying)prehistoric2;
                if (flying.isUsingStuckNavigation()) {
                    return !flying.method_5942().method_6357();
                }
                return flying.method_5962().method_6241();
            }
            return true;
        }
        if (current instanceof Instruction.FlyLand) {
            Instruction.FlyLand flyLand = (Instruction.FlyLand)current;
            Prehistoric prehistoric3 = this.mob;
            if (prehistoric3 instanceof PrehistoricFlying) {
                PrehistoricFlying flying = (PrehistoricFlying)prehistoric3;
                return flying.method_6581();
            }
        } else {
            if (current instanceof Instruction.TeleportTo) {
                Instruction.TeleportTo teleportTo = (Instruction.TeleportTo)current;
                if (this.endTick < this.mob.method_37908().method_8510()) {
                    return false;
                }
                this.mob.method_5725(teleportTo.target, teleportTo.rotation, this.mob.method_36455());
                this.mob.method_5847(teleportTo.rotation);
                return true;
            }
            if (current instanceof Instruction.AttachTo) {
                Instruction.AttachTo attachTo = (Instruction.AttachTo)current;
                Prehistoric prehistoric4 = this.mob;
                if (prehistoric4 instanceof Meganeura) {
                    Meganeura meganeura = (Meganeura)prehistoric4;
                    if (!meganeura.getAttachSystem().isAttached()) {
                        return true;
                    }
                    if (!this.attached) {
                        this.attached = true;
                        this.endTick = this.mob.method_37908().method_8510() + 100L;
                    }
                    if (this.endTick < this.mob.method_37908().method_8510()) {
                        meganeura.getAttachSystem().stopAttaching();
                        return false;
                    }
                    return true;
                }
                return false;
            }
            if (current instanceof Instruction.LeapLand) {
                Instruction.LeapLand leapLand = (Instruction.LeapLand)current;
                PrehistoricLeaping leaping = (PrehistoricLeaping)this.mob;
                if (leaping.getLeapSystem().isLeaping()) {
                    if (leaping.getLeapSystem().isLanding()) {
                        this.delayTick = this.mob.method_37908().method_8510() + 25L;
                    }
                } else {
                    if (this.mob.method_24828() && this.delayTick > 0L && this.delayTick >= this.mob.method_37908().method_8510()) {
                        return false;
                    }
                    if (leaping.method_5707(leapLand.location) < 30.0 && this.delayTick == 0L) {
                        leaping.getLeapSystem().setBlockLeapTarget(leapLand.location);
                    }
                }
                return true;
            }
            if (current instanceof Instruction.LeapAttack) {
                Instruction.LeapAttack leapAttack = (Instruction.LeapAttack)current;
                class_1297 target = this.mob.method_37908().method_8469(leapAttack.targetId);
                if (target instanceof class_1309) {
                    class_1309 livingEntity = (class_1309)target;
                    livingEntity.method_6033(livingEntity.method_6063());
                    PrehistoricLeaping leaping = (PrehistoricLeaping)this.mob;
                    double jumpDistance = 30.0;
                    if (leaping.getLeapSystem().isLeaping()) {
                        if (leaping.getLeapSystem().isLanding()) {
                            this.delayTick = this.mob.method_37908().method_8510() + 25L;
                        }
                    } else {
                        if (this.mob.method_24828() && this.delayTick > 0L && this.delayTick >= this.mob.method_37908().method_8510()) {
                            return false;
                        }
                        if (leaping.method_5858(target) < jumpDistance && this.delayTick == 0L) {
                            leaping.getLeapSystem().setLeapTarget(livingEntity);
                        } else {
                            this.mob.method_5942().method_6335(target, 1.0);
                            this.mob.method_5951(target, 120.0f, 10.0f);
                        }
                    }
                    return true;
                }
            } else {
                if (current instanceof Instruction.Idle) {
                    Instruction.Idle idle = (Instruction.Idle)current;
                    return this.endTick >= this.mob.method_37908().method_8510();
                }
                if (current instanceof Instruction.Sleep) {
                    Instruction.Sleep sleep = (Instruction.Sleep)current;
                    if (this.endTick < this.mob.method_37908().method_8510()) {
                        this.mob.sleepSystem.setSleeping(false);
                        this.mob.sleepSystem.setSleepForced(false);
                        return false;
                    }
                    return true;
                }
                if (current instanceof Instruction.PlayAnim) {
                    Instruction.PlayAnim playAnim = (Instruction.PlayAnim)current;
                    if (playAnim.timeBased) {
                        if (this.animCount < this.mob.method_37908().method_8510()) {
                            this.mob.getAnimationLogic().cancelAnimation(playAnim.controller);
                            return false;
                        }
                    } else if (this.mob.getAnimationLogic().isAnimationDone(this.activeAnim)) {
                        --this.animCount;
                        if (this.animCount > 0L) {
                            this.activeAnim = this.mob.getAnimationLogic().forceAnimation(playAnim.controller, this.mob.getAllAnimations().get(playAnim.name), AnimationCategory.IDLE, 1.0, 5, false);
                        } else {
                            return false;
                        }
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private boolean tryUpdatePath(Instruction.MoveTo moveTo) {
        class_1408 navigation = this.mob.method_5942();
        if (this.tries >= 15) {
            this.tries = 0;
            return false;
        }
        if (navigation instanceof class_1409 && !this.mob.method_24828() && !this.mob.method_5816()) {
            return true;
        }
        if (navigation instanceof class_1412 && !this.mob.method_5816() && !(navigation instanceof AmphibiousPathNavigation)) {
            return true;
        }
        if (navigation.method_6345() == null) {
            class_11 path = navigation.method_6348(moveTo.target, 1);
            if (path == null) {
                ++this.tries;
                return true;
            }
            return navigation.method_6334(path, 1.0);
        }
        if (navigation.method_6345().method_46() && !moveTo.target.method_19769((class_2374)this.mob.method_19538(), this.acceptedDistance())) {
            class_11 path = navigation.method_6348(moveTo.target, 1);
            if (path == null) {
                ++this.tries;
                return true;
            }
            return navigation.method_6334(path, 1.0);
        }
        return !navigation.method_6345().method_46();
    }

    public double acceptedDistance() {
        if (this.mob.getEntityHitboxData().hasCustomParts() && this.mob.getEntityHitboxData().getHeadRadius() != 0.0f) {
            return this.mob.getEntityHitboxData().getHeadRadius() * this.mob.method_17825() + 1.0f;
        }
        return this.mob.method_17681() / 2.0f + 1.0f;
    }

    private void startNext() {
        ++this.index;
        this.tries = 0;
        if (this.instructions.size() == this.index) {
            if (this.shouldLoop) {
                this.syncWithClients();
                this.index = 0;
            } else {
                this.stop();
                return;
            }
        }
        this.endTick = 0L;
        this.delayTick = 0L;
        Instruction current = this.instructions.get(this.index);
        if (current instanceof Instruction.MoveTo) {
            Instruction.MoveTo moveTo = (Instruction.MoveTo)current;
            this.mob.method_5942().method_6337((double)moveTo.target.method_10263(), (double)moveTo.target.method_10264(), (double)moveTo.target.method_10260(), 1.0);
        } else if (current instanceof Instruction.FlyTo) {
            Instruction.FlyTo flyTo = (Instruction.FlyTo)current;
            Prehistoric prehistoric = this.mob;
            if (prehistoric instanceof PrehistoricFlying) {
                PrehistoricFlying flying = (PrehistoricFlying)prehistoric;
                flying.moveTo(class_243.method_24953((class_2382)flyTo.target), false, true);
            }
        } else if (current instanceof Instruction.FlyLand) {
            Instruction.FlyLand flyLand = (Instruction.FlyLand)current;
            Prehistoric prehistoric = this.mob;
            if (prehistoric instanceof PrehistoricFlying) {
                PrehistoricFlying flying = (PrehistoricFlying)prehistoric;
                flying.moveTo(class_243.method_24953((class_2382)flyLand.target), true, true);
            }
        } else if (current instanceof Instruction.TeleportTo) {
            Instruction.TeleportTo teleportTo = (Instruction.TeleportTo)current;
            this.mob.method_5942().method_6340();
            this.mob.method_5725(teleportTo.target, teleportTo.rotation, this.mob.method_36455());
            this.mob.method_5847(teleportTo.rotation);
            this.endTick = this.mob.method_37908().method_8510() + 5L;
        } else if (current instanceof Instruction.AttachTo) {
            Instruction.AttachTo attachTo = (Instruction.AttachTo)current;
            this.attached = false;
            this.mob.method_5942().method_6337((double)attachTo.target.method_10263(), (double)attachTo.target.method_10264(), (double)attachTo.target.method_10260(), 1.0);
            Prehistoric prehistoric = this.mob;
            if (prehistoric instanceof Meganeura) {
                Meganeura meganeura = (Meganeura)prehistoric;
                class_2350 face = attachTo.direction;
                float rad = this.mob.method_17681() / 2.0f;
                class_243 pos = new class_243(attachTo.location.field_1352 + (double)(rad * (float)face.method_10148()), attachTo.location.field_1351, attachTo.location.field_1350 + (double)(rad * (float)face.method_10165()));
                meganeura.getAttachSystem().setAttachTarget(attachTo.target, face, pos);
            }
        } else if (current instanceof Instruction.LeapLand) {
            Instruction.LeapLand leapLand = (Instruction.LeapLand)current;
            this.mob.method_5942().method_6337(leapLand.location.field_1352, leapLand.location.field_1351, leapLand.location.field_1350, 1.0);
        } else if (current instanceof Instruction.LeapAttack) {
            Prehistoric prehistoric;
            Instruction.LeapAttack leapAttack = (Instruction.LeapAttack)current;
            class_1297 target = this.mob.method_37908().method_8469(leapAttack.targetId);
            if (target instanceof class_1309 && (prehistoric = this.mob) instanceof PrehistoricLeaping) {
                PrehistoricLeaping leaping = (PrehistoricLeaping)prehistoric;
                this.mob.method_5942().method_6335(target, 1.0);
                this.mob.method_5951(target, 120.0f, 10.0f);
                this.mob.method_5980((class_1309)leaping);
            }
        } else if (current instanceof Instruction.Idle) {
            Instruction.Idle idle = (Instruction.Idle)current;
            this.endTick = this.mob.method_37908().method_8510() + (long)idle.duration;
        } else if (current instanceof Instruction.PlayAnim) {
            Instruction.PlayAnim playAnim = (Instruction.PlayAnim)current;
            if (playAnim.timeBased) {
                this.animCount = this.mob.method_37908().method_8510() + (long)playAnim.count * 20L;
                this.activeAnim = this.mob.getAnimationLogic().forceAnimation(playAnim.controller, this.mob.getAllAnimations().get(playAnim.name), AnimationCategory.IDLE, 1.0, 5, true);
            } else {
                this.animCount = playAnim.count;
                this.activeAnim = this.mob.getAnimationLogic().forceAnimation(playAnim.controller, this.mob.getAllAnimations().get(playAnim.name), AnimationCategory.IDLE, 1.0, 5, false);
            }
        } else if (current instanceof Instruction.Sleep) {
            Instruction.Sleep sleep = (Instruction.Sleep)current;
            this.endTick = this.mob.method_37908().method_8510() + (long)sleep.duration;
            this.mob.sleepSystem.setDisabled(false);
            this.mob.sleepSystem.setSleeping(true);
            this.mob.sleepSystem.setSleepForced(true);
        }
    }

    public void start(List<Instruction> instructions, boolean loop, boolean sync) {
        this.instructions.clear();
        this.instructions.addAll(instructions);
        this.mob.method_5942().method_6340();
        this.index = -1;
        this.endTick = 0L;
        this.delayTick = 0L;
        this.shouldLoop = loop;
        if (sync) {
            this.syncWithClients();
        }
        this.mob.sleepSystem.setDisabled(true);
        this.mob.sitSystem.setDisabled(true);
        if (instructions.isEmpty()) {
            this.stop();
        } else {
            Prehistoric prehistoric = this.mob;
            if (prehistoric instanceof Meganeura) {
                Meganeura meganeura = (Meganeura)prehistoric;
                meganeura.getAttachSystem().stopAttaching();
            }
            if ((prehistoric = this.mob) instanceof PrehistoricLeaping) {
                PrehistoricLeaping leaping = (PrehistoricLeaping)prehistoric;
                leaping.getLeapSystem().stopLeap();
                leaping.getLeapSystem().setAttackRiding(false);
                leaping.method_5848();
            }
            if (this.mob.method_6113()) {
                this.mob.sleepSystem.setSleeping(false);
            }
            if (this.mob.sitSystem.isSitting()) {
                this.mob.sitSystem.setSitting(false);
            }
            this.mob.disableCustomAI((byte)0, false);
            this.mob.disableCustomAI((byte)1, true);
            this.mob.disableCustomAI((byte)2, false);
            this.mob.disableCustomAI((byte)3, false);
            this.startNext();
        }
    }

    public void stop() {
        this.mob.disableCustomAI((byte)0, true);
        this.mob.disableCustomAI((byte)1, false);
        this.mob.sleepSystem.setSleepForced(false);
        this.mob.sleepSystem.setDisabled(false);
        this.mob.sitSystem.setDisabled(false);
    }

    public void syncWithClients() {
        MessageHandler.DEBUG_CHANNEL.sendToPlayers((Iterable)((class_3218)this.mob.method_37908()).method_18766(serverPlayer -> serverPlayer.method_5739((class_1297)this.mob) < 32.0f), (Object)new InstructionMessage(this.mob.method_5628(), this.shouldLoop, this.instructions));
    }

    @Override
    public void saveAdditional(class_2487 tag) {
        if (Version.debugEnabled() && !this.mob.method_37908().field_9236) {
            class_2499 saved = new class_2499();
            for (int i = 0; i < this.instructions.size(); ++i) {
                saved.method_10533(i, (class_2520)this.instructions.get(i).encodeTag());
            }
            tag.method_10566("Instructions", (class_2520)saved);
            tag.method_10556("InstructionsLoop", this.shouldLoop);
        }
    }

    @Override
    public void load(class_2487 tag) {
        if (Version.debugEnabled()) {
            ObjectArrayList newInstructions = new ObjectArrayList();
            newInstructions.clear();
            class_2499 saved = tag.method_10554("Instructions", 10);
            for (class_2520 savedTag : saved) {
                newInstructions.add(Instruction.decodeFromTag((class_2487)savedTag));
            }
            this.shouldLoop = tag.method_10577("InstructionsLoop");
            if (!newInstructions.isEmpty()) {
                this.start((List<Instruction>)newInstructions, this.shouldLoop, false);
            }
        }
    }

    public void saveAdditionalSpawnData(class_2540 buf) {
        class_2487 tag = new class_2487();
        this.saveAdditional(tag);
        buf.method_10794(tag);
    }

    public void loadAdditionalSpawnData(class_2540 buf) {
        ObjectArrayList newInstructions = new ObjectArrayList();
        class_2487 tag = buf.method_10798();
        if (tag != null) {
            class_2499 saved = tag.method_10554("Instructions", 10);
            for (class_2520 savedTag : saved) {
                newInstructions.add(Instruction.decodeFromTag((class_2487)savedTag));
            }
            InstructionTab.INSTRUCTIONS.put(this.mob.method_5667(), new InstructionTab.Pair(this.mob.method_5628(), (List<Instruction>)newInstructions));
        }
    }
}

