/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.fabric.capabilities;

import com.github.teamfossilsarcheology.fossil.capabilities.ModCapabilities;
import com.github.teamfossilsarcheology.fossil.config.FossilConfig;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.EntityInfo;
import com.github.teamfossilsarcheology.fossil.event.ModEvents;
import com.github.teamfossilsarcheology.fossil.fabric.capabilities.IMammalComponent;
import dev.onyxstudios.cca.api.v3.component.tick.CommonTickingComponent;
import java.util.Objects;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_2487;
import org.jetbrains.annotations.Nullable;

public class MammalComponent
implements IMammalComponent,
CommonTickingComponent {
    private final class_1429 animal;
    private int embryoProgress;
    private EntityInfo embryo;

    public MammalComponent(class_1429 provider) {
        this.animal = provider;
    }

    public void tick() {
        if (this.embryoProgress == 0) {
            return;
        }
        if (this.embryoProgress >= FossilConfig.getInt("pregnancyDuration")) {
            if (!this.animal.method_37908().field_9236) {
                ModEvents.growEntity(this.embryo, (class_1309)this.animal);
                ModCapabilities.stopPregnancy(this.animal);
            }
        } else {
            ++this.embryoProgress;
        }
    }

    public void readFromNbt(class_2487 tag) {
        this.setEmbryoProgress(tag.method_10550("embryoProgress"));
        try {
            this.setEmbryo(EntityInfo.fromNbt(tag.method_10558("embryo")));
        }
        catch (IllegalArgumentException e) {
            this.setEmbryo(null);
        }
    }

    public void writeToNbt(class_2487 tag) {
        tag.method_10569("embryoProgress", this.embryoProgress);
        if (this.embryo != null) {
            tag.method_10582("embryo", this.embryo.name());
        }
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MammalComponent that = (MammalComponent)obj;
        return Objects.equals(this.embryoProgress, that.embryoProgress) && Objects.equals(this.embryo, that.embryo);
    }

    public int hashCode() {
        return Objects.hash(this.embryoProgress, this.embryo);
    }

    @Override
    public int getEmbryoProgress() {
        return this.embryoProgress;
    }

    @Override
    public void setEmbryoProgress(int progress) {
        this.embryoProgress = progress;
    }

    @Override
    public EntityInfo getEmbryo() {
        return this.embryo;
    }

    @Override
    public void setEmbryo(@Nullable EntityInfo embryo) {
        this.embryo = embryo;
    }
}

