/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.network;

import com.github.teamfossilsarcheology.fossil.capabilities.ModCapabilities;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.EntityInfo;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.Env;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1429;
import net.minecraft.class_2540;
import org.jetbrains.annotations.Nullable;

public class S2CMammalCapMessage {
    private final int entityId;
    private final int embryoProgress;
    private final EntityInfo embryo;

    public S2CMammalCapMessage(class_2540 buf) {
        EntityInfo temp;
        this.entityId = buf.readInt();
        this.embryoProgress = buf.readInt();
        try {
            temp = EntityInfo.fromNbt(buf.method_19772());
        }
        catch (IllegalArgumentException e) {
            temp = null;
        }
        this.embryo = temp;
    }

    public S2CMammalCapMessage(class_1429 animal, int embryoProgress, @Nullable EntityInfo embryo) {
        this.entityId = animal.method_5628();
        this.embryoProgress = embryoProgress;
        this.embryo = embryo;
    }

    public void write(class_2540 buf) {
        buf.writeInt(this.entityId);
        buf.writeInt(this.embryoProgress);
        if (this.embryo != null) {
            buf.method_10814(this.embryo.name());
        } else {
            buf.method_10814("null");
        }
    }

    public void apply(Supplier<NetworkManager.PacketContext> contextSupplier) {
        if (contextSupplier.get().getEnvironment() == Env.SERVER) {
            return;
        }
        contextSupplier.get().queue(() -> {
            class_1297 entity = ((NetworkManager.PacketContext)contextSupplier.get()).getPlayer().method_37908().method_8469(this.entityId);
            if (entity instanceof class_1429) {
                class_1429 animal = (class_1429)entity;
                ModCapabilities.setEmbryoProgress(animal, this.embryoProgress);
                ModCapabilities.setEmbryo(animal, this.embryo);
            }
        });
    }
}

