/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.recipe;

import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.VanillaEntityInfo;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import com.github.teamfossilsarcheology.fossil.recipe.AnalyzerRecipe;
import com.github.teamfossilsarcheology.fossil.recipe.CultureVatRecipe;
import com.github.teamfossilsarcheology.fossil.recipe.SifterRecipe;
import com.github.teamfossilsarcheology.fossil.recipe.WithFuelRecipe;
import com.github.teamfossilsarcheology.fossil.recipe.WorktableRecipe;
import com.github.teamfossilsarcheology.fossil.util.Version;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class ModRecipes {
    public static final Map<class_1792, AnalyzerRecipe> ANALYZER_RECIPES = new Object2ObjectOpenHashMap();
    private static final Map<class_1935, Integer> WORKTABLE_FUEL_VALUES = new Object2IntOpenHashMap();
    private static final Map<class_1935, Integer> CULTURE_VAT_FUEL_VALUES = new Object2IntOpenHashMap();
    public static final DeferredRegister<class_1865<?>> SERIALIZERS = DeferredRegister.create((String)"fossil", (class_5321)class_7924.field_41216);
    public static final DeferredRegister<class_3956<?>> TYPES = DeferredRegister.create((String)"fossil", (class_5321)class_7924.field_41217);
    public static final RegistrySupplier<class_1865<AnalyzerRecipe>> ANALYZER_SERIALIZER = SERIALIZERS.register("analyzer", () -> AnalyzerRecipe.Serializer.INSTANCE);
    public static final RegistrySupplier<class_1865<CultureVatRecipe>> CULTURE_VAT_SERIALIZER = SERIALIZERS.register("culture_vat", () -> CultureVatRecipe.Serializer.INSTANCE);
    public static final RegistrySupplier<class_1865<SifterRecipe>> SIFTER_SERIALIZER = SERIALIZERS.register("sifter", () -> SifterRecipe.Serializer.INSTANCE);
    public static final RegistrySupplier<class_1865<WorktableRecipe>> WORKTABLE_SERIALIZER = SERIALIZERS.register("worktable", () -> WorktableRecipe.Serializer.INSTANCE);
    public static final RegistrySupplier<class_3956<AnalyzerRecipe>> ANALYZER_TYPE = TYPES.register("analyzer", () -> AnalyzerRecipe.Type.INSTANCE);
    public static final RegistrySupplier<class_3956<CultureVatRecipe>> CULTURE_VAT_TYPE = TYPES.register("culture_vat", () -> CultureVatRecipe.Type.INSTANCE);
    public static final RegistrySupplier<class_3956<SifterRecipe>> SIFTER_TYPE = TYPES.register("sifter", () -> SifterRecipe.Type.INSTANCE);
    public static final RegistrySupplier<class_3956<WorktableRecipe>> WORKTABLE_TYPE = TYPES.register("worktable", () -> WorktableRecipe.Type.INSTANCE);

    public static void register() {
        SERIALIZERS.register();
        TYPES.register();
    }

    public static void initRecipes() {
        for (PrehistoricEntityInfo info : PrehistoricEntityInfo.entitiesWithBones()) {
            ModRecipes.registerAnalyzer(new AnalyzerRecipe.Builder((class_1935)info.armBoneItem).addOutput((class_1935)class_1802.field_8324, 30.0).addOutput((class_1935)class_1802.field_8606, 35.0).addOutput((class_1935)info.dnaItem, 35.0));
            ModRecipes.registerAnalyzer(new AnalyzerRecipe.Builder((class_1935)info.footBoneItem).addOutput((class_1935)class_1802.field_8324, 30.0).addOutput((class_1935)class_1802.field_8606, 35.0).addOutput((class_1935)info.dnaItem, 35.0));
            ModRecipes.registerAnalyzer(new AnalyzerRecipe.Builder((class_1935)info.legBoneItem).addOutput((class_1935)class_1802.field_8324, 30.0).addOutput((class_1935)class_1802.field_8606, 35.0).addOutput((class_1935)info.dnaItem, 35.0));
            ModRecipes.registerAnalyzer(new AnalyzerRecipe.Builder((class_1935)info.legBoneItem).addOutput((class_1935)class_1802.field_8324, 30.0).addOutput((class_1935)class_1802.field_8606, 35.0).addOutput((class_1935)info.dnaItem, 35.0));
            ModRecipes.registerAnalyzer(new AnalyzerRecipe.Builder((class_1935)info.ribcageBoneItem).addOutput((class_1935)class_1802.field_8324, 30.0).addOutput((class_1935)class_1802.field_8606, 35.0).addOutput((class_1935)info.dnaItem, 35.0));
            ModRecipes.registerAnalyzer(new AnalyzerRecipe.Builder((class_1935)info.skullBoneItem).addOutput((class_1935)class_1802.field_8324, 30.0).addOutput((class_1935)class_1802.field_8606, 35.0).addOutput((class_1935)info.dnaItem, 35.0));
            ModRecipes.registerAnalyzer(new AnalyzerRecipe.Builder((class_1935)info.tailBoneItem).addOutput((class_1935)class_1802.field_8324, 30.0).addOutput((class_1935)class_1802.field_8606, 35.0).addOutput((class_1935)info.dnaItem, 35.0));
            ModRecipes.registerAnalyzer(new AnalyzerRecipe.Builder((class_1935)info.uniqueBoneItem).addOutput((class_1935)class_1802.field_8324, 30.0).addOutput((class_1935)class_1802.field_8606, 35.0).addOutput((class_1935)info.dnaItem, 35.0));
            ModRecipes.registerAnalyzer(new AnalyzerRecipe.Builder((class_1935)info.vertebraeBoneItem).addOutput((class_1935)class_1802.field_8324, 30.0).addOutput((class_1935)class_1802.field_8606, 35.0).addOutput((class_1935)info.dnaItem, 35.0));
        }
        ModRecipes.registerAnalyzer(new AnalyzerRecipe.Builder((class_1935)PrehistoricEntityInfo.MEGALODON.uniqueBoneItem).addOutput((class_1935)class_1802.field_8324, 30.0).addOutput((class_1935)class_1802.field_8606, 35.0).addOutput((class_1935)PrehistoricEntityInfo.MEGALODON.dnaItem, 35.0));
        for (PrehistoricEntityInfo prehistoricEntityInfo : PrehistoricEntityInfo.values()) {
            if (prehistoricEntityInfo.foodItem != null) {
                ModRecipes.registerAnalyzer(new AnalyzerRecipe.Builder((class_1935)prehistoricEntityInfo.foodItem).addOutput((class_1935)prehistoricEntityInfo.dnaItem, 100.0));
            }
            if (prehistoricEntityInfo.eggItem != null) {
                ModRecipes.registerAnalyzer(new AnalyzerRecipe.Builder((class_1935)prehistoricEntityInfo.eggItem).addOutput((class_1935)prehistoricEntityInfo.dnaItem, 100.0));
            }
            if (prehistoricEntityInfo.birdEggItem != null) {
                ModRecipes.registerAnalyzer(new AnalyzerRecipe.Builder((class_1935)prehistoricEntityInfo.birdEggItem).addOutput((class_1935)prehistoricEntityInfo.dnaItem, 100.0));
            }
            if (prehistoricEntityInfo.cultivatedBirdEggItem != null) {
                ModRecipes.registerAnalyzer(new AnalyzerRecipe.Builder((class_1935)prehistoricEntityInfo.cultivatedBirdEggItem).addOutput((class_1935)prehistoricEntityInfo.dnaItem, 100.0));
            }
            if (prehistoricEntityInfo.embryoItem == null) continue;
            ModRecipes.registerAnalyzer(new AnalyzerRecipe.Builder((class_1935)prehistoricEntityInfo.embryoItem).addOutput((class_1935)prehistoricEntityInfo.dnaItem, 100.0));
        }
        for (Enum enum_ : VanillaEntityInfo.values()) {
            if (((VanillaEntityInfo)enum_).eggItem != null) {
                ModRecipes.registerAnalyzer(new AnalyzerRecipe.Builder((class_1935)((VanillaEntityInfo)enum_).eggItem).addOutput((class_1935)((VanillaEntityInfo)enum_).dnaItem, 100.0));
            }
            if (((VanillaEntityInfo)enum_).embryoItem == null) continue;
            ModRecipes.registerAnalyzer(new AnalyzerRecipe.Builder((class_1935)((VanillaEntityInfo)enum_).embryoItem).addOutput((class_1935)((VanillaEntityInfo)enum_).dnaItem, 100.0));
        }
        WORKTABLE_FUEL_VALUES.put((class_1935)ModItems.POTTERY_SHARD.get(), 300);
        WORKTABLE_FUEL_VALUES.put((class_1935)ModItems.RELIC_SCRAP.get(), 300);
        CULTURE_VAT_FUEL_VALUES.put((class_1935)ModItems.BIO_GOO.get(), Version.debugEnabled() ? 1000 : 6000);
    }

    private static void registerAnalyzer(AnalyzerRecipe.Builder recipe) {
        ANALYZER_RECIPES.put(recipe.item.method_8389(), recipe.build());
    }

    @Nullable
    public static SifterRecipe getSifterRecipeForItem(class_1263 container, class_1937 level) {
        return level.method_8433().method_8132((class_3956)SIFTER_TYPE.get(), container, level).orElse(null);
    }

    @Nullable
    public static AnalyzerRecipe getAnalyzerRecipeForItem(class_1263 container, class_1937 level) {
        return ANALYZER_RECIPES.computeIfAbsent(container.method_5438(0).method_7909(), item -> level.method_8433().method_8132((class_3956)ANALYZER_TYPE.get(), container, level).orElse(null));
    }

    @Nullable
    public static WorktableRecipe getWorktableRecipeForItem(WithFuelRecipe.ContainerWithAnyFuel container, class_1937 level) {
        return level.method_8433().method_8132((class_3956)WORKTABLE_TYPE.get(), (class_1263)container, level).orElse(null);
    }

    @Nullable
    public static CultureVatRecipe getCultureVatRecipeForItem(WithFuelRecipe.ContainerWithAnyFuel container, class_1937 level) {
        return level.method_8433().method_8132((class_3956)CULTURE_VAT_TYPE.get(), (class_1263)container, level).orElse(null);
    }

    public static boolean isWorktableFuel(class_1935 itemLike) {
        return WORKTABLE_FUEL_VALUES.containsKey(itemLike);
    }

    public static int getWorktableFuelValue(class_1935 itemLike) {
        return WORKTABLE_FUEL_VALUES.getOrDefault(itemLike, 0);
    }

    public static boolean isCultureVatFuel(class_1935 itemLike) {
        return CULTURE_VAT_FUEL_VALUES.containsKey(itemLike);
    }

    public static int getCultureVatFuelValue(class_1935 itemLike) {
        return CULTURE_VAT_FUEL_VALUES.getOrDefault(itemLike, 0);
    }
}

