/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.block;

import com.github.teamfossilsarcheology.fossil.block.ModBlocks;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.CrataegusBushBlock;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.EphedraBushBlock;
import com.github.teamfossilsarcheology.fossil.block.custom_blocks.VacciniumBushBlock;
import com.github.teamfossilsarcheology.fossil.item.FlowerSeedsItem;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import com.github.teamfossilsarcheology.fossil.item.ModTabs;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.world.food.Foods;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public enum PrehistoricPlantInfo {
    BENNETTITALES_LARGE(Size.DOUBLE_GROWABLE, Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)28.0, (double)14.0)),
    BENNETTITALES_SMALL(Size.SINGLE_GROWABLE, BENNETTITALES_LARGE, "bennettitales", Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0)),
    CEPHALOTAXUS(Size.SINGLE, Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0)),
    CRATAEGUS(Size.DOUBLE_BERRY, Shapes.m_83040_(), 2, 3),
    CYATHEA(Size.FOUR, Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0)),
    DICTYOPHYLLUM(Size.SINGLE, Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0)),
    DILLHOFFIA(Size.SINGLE, Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0)),
    DIPTERIS(Size.DOUBLE, Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)22.0, (double)15.0)),
    DUISBERGIA(Size.DOUBLE, Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)32.0, (double)13.0)),
    EPHEDRA(Size.SINGLE_BERRY, Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), 1, 1),
    FLORISSANTIA(Size.SINGLE, Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)11.0, (double)12.0)),
    FOOZIA(Size.DOUBLE, Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)32.0, (double)14.0)),
    HORSETAIL_LARGE(Size.DOUBLE_GROWABLE, Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)32.0, (double)14.0)),
    HORSETAIL_SMALL(Size.SINGLE_GROWABLE, HORSETAIL_LARGE, "horsetail", Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0)),
    LICOPODIOPHYTA(Size.SINGLE, Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0)),
    MUTANT_PLANT(Size.DOUBLE, Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)32.0, (double)14.0)),
    OSMUNDA(Size.SINGLE, Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0)),
    SAGENOPTERIS(Size.SINGLE, Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0)),
    SARRACENIA(Size.DOUBLE, Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)28.0, (double)13.0)),
    VACCINIUM(Size.SINGLE_BERRY, Shapes.m_83040_(), 2, 3),
    WELWITSCHIA(Size.SINGLE, Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0)),
    ZAMITES(Size.DOUBLE, Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)32.0, (double)13.0));

    private static List<PrehistoricPlantInfo> seedsCache;
    private final Size size;
    private final String resourceName;
    private final VoxelShape shape;
    private PrehistoricPlantInfo tallPlant;
    public int berryAge;
    public int maxAge;
    public RegistrySupplier<Item> berryItem;
    private String commonName;
    private RegistrySupplier<? extends BushBlock> plantBlock;
    private RegistrySupplier<Item> fossilizedPlantSeedItem;
    private RegistrySupplier<FlowerSeedsItem> plantSeedItem;

    private PrehistoricPlantInfo(Size size, VoxelShape shape) {
        this.size = size;
        this.shape = shape;
        this.resourceName = this.name().toLowerCase(Locale.ROOT);
    }

    private PrehistoricPlantInfo(Size size, PrehistoricPlantInfo tallPlant, String commonName, VoxelShape shape) {
        this.size = size;
        this.resourceName = this.name().toLowerCase(Locale.ROOT);
        this.tallPlant = tallPlant;
        this.commonName = commonName;
        this.shape = shape;
    }

    private PrehistoricPlantInfo(Size size, VoxelShape shape, int berryAge, int maxAge) {
        this.size = size;
        this.resourceName = this.name().toLowerCase(Locale.ROOT);
        this.berryAge = berryAge;
        this.maxAge = maxAge;
        this.shape = shape;
    }

    public static void register() {
        for (PrehistoricPlantInfo info : PrehistoricPlantInfo.values()) {
            if (info == CRATAEGUS) {
                info.plantBlock = ModBlocks.registerBlock(info.resourceName, () -> new CrataegusBushBlock(info));
                info.berryItem = ModItems.ITEMS.register("berry_" + info.resourceName, () -> new Item(new Item.Properties().m_41491_(ModTabs.FA_MOB_ITEM_TAB).m_41489_(Foods.f_38808_)));
                info.registerPlantSeed(info.resourceName);
                continue;
            }
            if (info == EPHEDRA) {
                info.plantBlock = ModBlocks.registerBlock(info.resourceName, () -> new EphedraBushBlock(info.shape, info));
                info.berryItem = ModItems.ITEMS.register("berry_" + info.resourceName, () -> new Item(new Item.Properties().m_41491_(ModTabs.FA_MOB_ITEM_TAB).m_41489_(Foods.f_38808_)));
                info.registerPlantSeed(info.resourceName);
                continue;
            }
            if (info == VACCINIUM) {
                info.plantBlock = ModBlocks.registerBlock(info.resourceName, () -> new VacciniumBushBlock(info.shape, info));
                info.berryItem = ModItems.ITEMS.register("berry_" + info.resourceName, () -> new Item(new Item.Properties().m_41491_(ModTabs.FA_MOB_ITEM_TAB).m_41489_(Foods.f_38808_)));
                info.registerPlantSeed(info.resourceName);
                continue;
            }
            if (info.size == Size.SINGLE) {
                info.plantBlock = ModBlocks.registerShortFlower(info.resourceName, info.shape);
                info.registerPlantSeed(info.resourceName);
                continue;
            }
            if (info.size == Size.DOUBLE) {
                info.plantBlock = ModBlocks.registerTallFlower(info.resourceName, info.shape);
                if (info == MUTANT_PLANT) continue;
                info.registerPlantSeed(info.resourceName);
                continue;
            }
            if (info.size == Size.SINGLE_GROWABLE) {
                info.plantBlock = ModBlocks.registerGrowableFlower(info.resourceName, info.tallPlant.plantBlock, info.shape);
                info.registerPlantSeed(info.commonName);
                continue;
            }
            if (info.size == Size.DOUBLE_GROWABLE || info == MUTANT_PLANT) {
                info.plantBlock = ModBlocks.registerTallFlower(info.resourceName, info.shape);
                continue;
            }
            if (info.size != Size.FOUR) continue;
            info.plantBlock = ModBlocks.registerFourTallFlower(info.resourceName, info.shape);
            info.registerPlantSeed(info.resourceName);
        }
    }

    public static List<PrehistoricPlantInfo> plantsWithSeeds() {
        if (seedsCache == null) {
            seedsCache = Arrays.stream(PrehistoricPlantInfo.values()).filter(type -> type.plantSeedItem != null).toList();
        }
        return seedsCache;
    }

    private void registerPlantSeed(String name) {
        this.fossilizedPlantSeedItem = ModItems.ITEMS.register("fossil_seed_" + name, () -> new Item(new Item.Properties().m_41491_(ModTabs.FA_MOB_ITEM_TAB)));
        this.plantSeedItem = ModItems.ITEMS.register("seed_" + name, () -> new FlowerSeedsItem(new Item.Properties().m_41491_(ModTabs.FA_MOB_ITEM_TAB), this.plantBlock));
    }

    public BushBlock getPlantBlock() {
        return (BushBlock)this.plantBlock.get();
    }

    public Item getFossilizedPlantSeedItem() {
        return (Item)this.fossilizedPlantSeedItem.get();
    }

    public FlowerSeedsItem getPlantSeedItem() {
        return (FlowerSeedsItem)((Object)this.plantSeedItem.get());
    }

    static enum Size {
        SINGLE,
        DOUBLE,
        SINGLE_GROWABLE,
        DOUBLE_GROWABLE,
        FOUR,
        SINGLE_BERRY,
        DOUBLE_BERRY;

    }
}

