/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.capabilities.ModCapabilities;
import com.github.teamfossilsarcheology.fossil.client.DinopediaBioLoader;
import com.github.teamfossilsarcheology.fossil.config.FossilConfig;
import com.github.teamfossilsarcheology.fossil.entity.Quagga;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.DinosaurEgg;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.OrderType;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfoAI;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricFish;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricShearable;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.system.MoodSystem;
import com.github.teamfossilsarcheology.fossil.food.FoodMappingsManager;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class DinopediaScreen
extends Screen {
    private static final ResourceLocation DINOPEDIA_BACKGROUND = FossilMod.location("textures/gui/dinopedia.png");
    private static final ResourceLocation MOODS = FossilMod.location("textures/gui/dinopedia_mood.png");
    private static final LoadingCache<UUID, Component> USERNAMES = CacheBuilder.newBuilder().expireAfterWrite(24L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<UUID, Component>(){

        @NotNull
        public Component load(@NotNull UUID key) {
            Player player = Minecraft.m_91087_().f_91073_.m_46003_(key);
            if (player != null) {
                return player.m_7755_();
            }
            GameProfile gameProfile = new GameProfile(key, null);
            gameProfile = Minecraft.m_91087_().m_91108_().fillProfileProperties(gameProfile, true);
            if (gameProfile.isComplete()) {
                return new TextComponent(gameProfile.getName());
            }
            return new TextComponent("Invalid User");
        }
    });
    private static final Component STUNTED_GROWTH = new TranslatableComponent("pedia.fossil.condition.stunted");
    private static final Component SHEARED = new TranslatableComponent("pedia.fossil.condition.sheared");
    private static final Component NOT_SHEARED = new TranslatableComponent("pedia.fossil.condition.not_sheared");
    private static final int MOOD_FACE_WIDTH = 16;
    private static final int MOOD_FACE_HEIGHT = 15;
    private static final int MOOD_BAR_WIDTH = 206;
    private static final int MOOD_BAR_HEIGHT = 9;
    private static final int PAGE_1 = 0;
    private static final int PAGE_2 = 1;
    private static final int MAX_PAGES = 2;
    private final LivingEntity entity;
    private List<String> currentBio;
    private final List<Component> toolTipList = new ArrayList<Component>();
    private final int xSize = 390;
    private final int ySize = 245;
    private int leftPos;
    private int topPos;
    private DinopediaPageButton backButton;
    private DinopediaPageButton forwardButton;
    private int currentPage;

    public DinopediaScreen(LivingEntity entity) {
        super((Component)new TextComponent(""));
        this.entity = entity;
    }

    public static void renderEntityInDinopedia(int posX, int posY, LivingEntity entity) {
        PoseStack poseStack = RenderSystem.m_157191_();
        poseStack.m_85836_();
        poseStack.m_85837_((double)posX, (double)posY, 1050.0);
        poseStack.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.m_157182_();
        PoseStack poseStack2 = new PoseStack();
        poseStack2.m_85837_(0.0, -10.0, 1000.0);
        int scale = 25;
        if (entity instanceof Prehistoric) {
            scale = (int)(35.0f / entity.m_20205_());
        } else if (entity instanceof DinosaurEgg) {
            scale = 110;
        } else if (entity instanceof Quagga) {
            scale = 35;
        }
        poseStack2.m_85841_((float)scale, (float)scale, (float)scale);
        poseStack2.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        Lighting.m_166384_();
        EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
        entityRenderDispatcher.m_114468_(false);
        poseStack2.m_85845_(Vector3f.f_122223_.m_122240_(-30.0f));
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        RenderSystem.m_69890_(() -> {
            float yRotO = entity.f_20883_;
            entity.f_20883_ = 110.0f;
            entityRenderDispatcher.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, poseStack2, (MultiBufferSource)bufferSource, 0xF000F0);
            entity.f_20883_ = yRotO;
        });
        bufferSource.m_109911_();
        entityRenderDispatcher.m_114468_(true);
        poseStack.m_85849_();
        RenderSystem.m_157182_();
        Lighting.m_84931_();
    }

    protected void m_7856_() {
        this.leftPos = (this.f_96543_ - 390) / 2;
        this.topPos = (this.f_96544_ - 245) / 2;
        this.backButton = (DinopediaPageButton)this.m_142416_((GuiEventListener)new DinopediaPageButton(this.leftPos + 10, this.topPos + 245 - 45, 200, 100, false, button -> this.pageBack()));
        if (this.entity instanceof Prehistoric || this.entity instanceof Quagga || this.entity instanceof PrehistoricFish) {
            this.forwardButton = (DinopediaPageButton)this.m_142416_((GuiEventListener)new DinopediaPageButton(this.leftPos + 390 - 43, this.topPos + 245 - 45, 200, 100, true, button -> this.pageForward()));
        }
        this.updateButtonVisibility();
    }

    protected void pageBack() {
        if (this.currentPage > 0) {
            --this.currentPage;
        }
        this.updateButtonVisibility();
    }

    protected void pageForward() {
        if (this.currentPage < this.getMaxPages() - 1) {
            ++this.currentPage;
        }
        this.updateButtonVisibility();
    }

    private void updateButtonVisibility() {
        if (this.forwardButton != null) {
            this.forwardButton.f_93624_ = this.currentPage < this.getMaxPages() - 1;
        }
        this.backButton.f_93624_ = this.currentPage > 0;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        this.renderBackgroundLayer(poseStack, mouseX, mouseY);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.renderForegroundLayer(poseStack, mouseX, mouseY, partialTick);
        if (!this.toolTipList.isEmpty()) {
            this.m_96597_(poseStack, this.toolTipList, mouseX, mouseY);
            this.toolTipList.clear();
        }
    }

    private void renderBackgroundLayer(PoseStack poseStack, int mouseX, int mouseY) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)DINOPEDIA_BACKGROUND);
        DinopediaScreen.m_93133_((PoseStack)poseStack, (int)this.leftPos, (int)this.topPos, (float)0.0f, (float)0.0f, (int)390, (int)245, (int)390, (int)390);
        if (this.currentPage == 0) {
            DinopediaScreen.renderEntityInDinopedia(this.leftPos + 100, this.topPos + 80, this.entity);
        }
    }

    private void renderForegroundLayer(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        if (this.currentPage == 0) {
            this.renderFirstPage(poseStack, mouseX, mouseY);
        } else if (this.currentPage >= 1) {
            if (this.currentBio == null) {
                this.currentBio = this.loadBio(this.entity);
                this.updateButtonVisibility();
            }
            if (!this.currentBio.isEmpty()) {
                this.renderPrehistoricBio(poseStack);
            }
        }
    }

    private int getMaxPages() {
        if (this.currentBio == null) {
            return 2;
        }
        return 2 + this.currentBio.size() / 42;
    }

    private float getScaledX(boolean left, int width, float scale) {
        return ((float)this.leftPos + (left ? 0.0f : 195.0f) + (195.0f - (float)width * scale) / 2.0f) / scale;
    }

    private static float roundToHalf(double value) {
        return (float)Math.round(value * 2.0) / 2.0f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void renderFirstPage(PoseStack poseStack, int mouseX, int mouseY) {
        LivingEntity scale3;
        Component name;
        Animal animal;
        float embryoProgress;
        int col = 10321511;
        boolean drawLeftPage = true;
        LivingEntity livingEntity = this.entity;
        if (livingEntity instanceof Animal && (embryoProgress = (float)ModCapabilities.getEmbryoProgress(animal = (Animal)livingEntity)) > 0.0f) {
            drawLeftPage = false;
            float quot = DinopediaScreen.roundToHalf(embryoProgress / (float)(FossilConfig.getInt("pregnancyDuration") + 1) * 100.0f);
            TranslatableComponent progress = new TranslatableComponent("pedia.fossil.pregnantTime", new Object[]{Float.valueOf(quot)});
            this.f_96547_.m_92889_(poseStack, (Component)progress, this.getScaledX(true, this.f_96547_.m_92852_((FormattedText)progress), 1.0f), (float)(this.topPos + 135), col);
            poseStack.m_85836_();
            float scale2 = 1.5f;
            poseStack.m_85841_(scale2, scale2, scale2);
            TranslatableComponent name2 = new TranslatableComponent("pedia.fossil.pregnant", new Object[]{this.entity.m_6095_().m_20676_()});
            this.f_96547_.m_92889_(poseStack, (Component)name2, this.getScaledX(true, this.f_96547_.m_92852_((FormattedText)name2), scale2), (float)(this.topPos + 85) / scale2, 4337700);
            poseStack.m_85849_();
        }
        this.renderFirstPageRight(poseStack, mouseX, mouseY);
        LivingEntity quot = this.entity;
        if (quot instanceof Prehistoric) {
            Prehistoric dino = (Prehistoric)quot;
            if (drawLeftPage) {
                poseStack.m_85836_();
                float scale3 = 1.5f;
                poseStack.m_85841_(scale3, scale3, scale3);
                name = this.entity.m_6095_().m_20676_();
                this.f_96547_.m_92889_(poseStack, name, this.getScaledX(true, this.f_96547_.m_92852_((FormattedText)name), scale3), (float)(this.topPos + 85) / scale3, 4337700);
                poseStack.m_85849_();
                int x = this.leftPos + 30;
                int y = this.topPos + 85;
                this.f_96547_.m_92889_(poseStack, (Component)new TranslatableComponent("pedia.fossil.age", new Object[]{dino.getAgeInDays()}), (float)x, (float)(y + 20), col);
                this.f_96547_.m_92889_(poseStack, (Component)new TranslatableComponent("pedia.fossil.health", new Object[]{this.entity.m_21223_() + "/" + this.entity.m_21233_()}), (float)x, (float)(y + 30), col);
                this.f_96547_.m_92889_(poseStack, (Component)new TranslatableComponent("pedia.fossil.hunger", new Object[]{dino.getHunger() + "/" + dino.getMaxHunger()}), (float)x, (float)(y + 40), col);
                Component dietText = dino.data().diet().getName();
                this.renderHoverInfo(poseStack, x, y + 50, mouseX, mouseY, dietText, dino.data().diet().getDescription());
                Component tempText = dino.aiResponseType().getName();
                this.renderHoverInfo(poseStack, x, y + 60, mouseX, mouseY, tempText, dino.aiResponseType().getDescription());
                this.f_96547_.m_92889_(poseStack, dino.getGender().getName(), (float)x, (float)(y + 70), col);
                if (dino.m_142504_() == null) {
                    this.f_96547_.m_92889_(poseStack, (Component)new TranslatableComponent("pedia.fossil.untamed"), (float)x, (float)(y + 80), col);
                } else {
                    try {
                        this.f_96547_.m_92889_(poseStack, (Component)new TranslatableComponent("pedia.fossil.owner", new Object[]{USERNAMES.get((Object)dino.m_142504_())}), (float)x, (float)(y + 80), col);
                    }
                    catch (ExecutionException e) {
                        this.f_96547_.m_92889_(poseStack, (Component)new TranslatableComponent("pedia.fossil.owner", new Object[]{"Invalid User"}), (float)x, (float)(y + 80), col);
                    }
                }
                OrderType order = dino.getCurrentOrder();
                this.renderHoverInfo(poseStack, x, y + 90, mouseX, mouseY, order.getName(), order.getDescription());
                this.f_96547_.m_92889_(poseStack, (Component)new TranslatableComponent("pedia.fossil.order.item", new Object[]{new TranslatableComponent(dino.getOrderItem().m_5524_())}), (float)x, (float)(y + 100), col);
                PrehistoricEntityInfoAI.Activity activity = dino.aiActivityType();
                this.renderHoverInfo(poseStack, x, y + 110, mouseX, mouseY, activity.getName(), activity.getDescription());
                this.f_96547_.m_92889_(poseStack, (Component)new TranslatableComponent("pedia.fossil.population", new Object[]{dino.data().maxPopulation()}), (float)x, (float)(y + 120), col);
                return;
            }
        }
        if ((scale3 = this.entity) instanceof DinosaurEgg) {
            DinosaurEgg egg = (DinosaurEgg)scale3;
            poseStack.m_85836_();
            float scale4 = 1.5f;
            poseStack.m_85841_(scale4, scale4, scale4);
            name = new TranslatableComponent("pedia.fossil.egg", new Object[]{egg.getPrehistoricEntityInfo().displayName.get()});
            this.f_96547_.m_92889_(poseStack, name, this.getScaledX(true, this.f_96547_.m_92852_((FormattedText)name), scale4), (float)(this.topPos + 85) / scale4, 4337700);
            poseStack.m_85849_();
            int time = Mth.m_14143_((float)((float)egg.getHatchingTime() / (float)egg.getTotalHatchingTime() * 100.0f));
            TranslatableComponent progress = new TranslatableComponent("pedia.fossil.egg.time", new Object[]{Math.max(time, 0)});
            this.f_96547_.m_92889_(poseStack, (Component)progress, this.getScaledX(true, this.f_96547_.m_92852_((FormattedText)progress), 1.0f), (float)(this.topPos + 120), 10321511);
            MutableComponent status = egg.m_20069_() ? new TranslatableComponent("pedia.fossil.egg.status.wet").m_130938_(style -> style.m_131140_(ChatFormatting.AQUA)) : (egg.isTooCold() ? new TranslatableComponent("pedia.fossil.egg.status.cold").m_130938_(style -> style.m_131140_(ChatFormatting.BLUE)) : new TranslatableComponent("pedia.fossil.egg.status.warm").m_130938_(style -> style.m_131140_(ChatFormatting.GOLD)));
            status = new TranslatableComponent("pedia.fossil.egg.status", new Object[]{status});
            this.f_96547_.m_92889_(poseStack, (Component)status, this.getScaledX(true, this.f_96547_.m_92852_((FormattedText)status), 1.0f), (float)(this.topPos + 140), 10321511);
            return;
        } else {
            if (!(this.entity instanceof PrehistoricFish) && !(this.entity instanceof Quagga)) return;
            poseStack.m_85836_();
            float scale5 = 1.5f;
            poseStack.m_85841_(scale5, scale5, scale5);
            name = this.entity.m_6095_().m_20676_();
            this.f_96547_.m_92889_(poseStack, name, this.getScaledX(true, this.f_96547_.m_92852_((FormattedText)name), scale5), (float)(this.topPos + 85) / scale5, 4337700);
            poseStack.m_85849_();
        }
    }

    private void renderHoverInfo(PoseStack poseStack, int x, int y, int mouseX, int mouseY, Component text, Component hoverText) {
        this.f_96547_.m_92889_(poseStack, text, (float)x, (float)y, 10321511);
        if (mouseX >= x && mouseY >= y && mouseX < x + this.f_96547_.m_92852_((FormattedText)text)) {
            Objects.requireNonNull(this.f_96547_);
            if (mouseY < y + 9) {
                this.toolTipList.add(hoverText);
            }
        }
    }

    private void renderFirstPageRight(PoseStack poseStack, int mouseX, int mouseY) {
        LivingEntity livingEntity = this.entity;
        if (livingEntity instanceof Prehistoric) {
            Prehistoric dino = (Prehistoric)livingEntity;
            RenderSystem.m_157456_((int)0, (ResourceLocation)MOODS);
            poseStack.m_85836_();
            float scale = 1.75f;
            poseStack.m_85841_(scale, scale, scale);
            int x = (int)this.getScaledX(false, 16, scale);
            int y = (int)((float)(this.topPos + 16) / scale);
            MoodSystem moodSystem = dino.moodSystem;
            this.m_93228_(poseStack, x, y, moodSystem.getMoodFace().uOffset, 10, 16, 15);
            poseStack.m_85849_();
            x = (int)((float)x * scale);
            y = (int)((float)y * scale);
            if (this.toolTipList.isEmpty() && mouseX >= x && mouseY >= y && (float)mouseX < (float)x + 16.0f * scale && (float)mouseY < (float)y + 15.0f * scale) {
                this.toolTipList.add(moodSystem.getMoodFace().getName());
                this.toolTipList.add(moodSystem.getMoodFace().getDescription());
            }
            poseStack.m_85836_();
            scale = 0.75f;
            poseStack.m_85841_(scale, scale, scale);
            x = (int)this.getScaledX(false, 206, scale);
            y = (int)((float)(this.topPos + 49) / scale);
            this.m_93228_(poseStack, x, y, 0, 0, 206, 9);
            poseStack.m_85849_();
            x = (int)((float)x * scale);
            y = (int)((float)y * scale);
            if (this.toolTipList.isEmpty() && mouseX >= x && mouseY >= y && (float)mouseX < (float)x + 206.0f * scale && (float)mouseY < (float)y + 9.0f * scale) {
                MutableComponent mood = new TextComponent(String.valueOf(moodSystem.getMood())).m_130938_(style -> style.m_131140_(moodSystem.getMoodFace().color));
                this.toolTipList.add((Component)new TranslatableComponent("pedia.fossil.mood_status", new Object[]{mood}));
            }
            poseStack.m_85836_();
            x = (int)this.getScaledX(false, 4, 1.0f);
            y = this.topPos + 9 + 38;
            this.m_93228_(poseStack, x - moodSystem.getMoodPosition(), y, 0, 26, 4, 10);
            poseStack.m_85849_();
            TreeSet<Item> foodMap = FoodMappingsManager.INSTANCE.getItemCache().get(dino.data().diet());
            List keys = foodMap.stream().limit(64L).toList();
            int itemCount = 0;
            int renderSize = 16;
            for (ItemLike itemLike : keys) {
                x = this.leftPos + 195 + (195 - renderSize * 8) / 2 + renderSize * (itemCount % 8);
                y = this.topPos + 65 + renderSize * (itemCount / 8);
                ++itemCount;
                ItemStack itemStack = new ItemStack(itemLike);
                this.f_96542_.m_115203_(itemStack, x, y);
                if (!this.toolTipList.isEmpty() || mouseX < x || mouseY < y || mouseX >= x + renderSize || mouseY >= y + renderSize) continue;
                this.toolTipList.addAll(this.m_96555_(itemStack));
            }
            x = this.leftPos + 4 + 195;
            y = this.topPos + 70 + renderSize * (itemCount / 8);
            if (dino.isAgingDisabled()) {
                this.f_96542_.m_115203_(new ItemStack((ItemLike)Items.f_42675_), x += 16, y);
                if (this.toolTipList.isEmpty() && mouseX >= x && mouseY >= y && mouseX < x + renderSize && mouseY < y + renderSize) {
                    this.toolTipList.add(STUNTED_GROWTH);
                }
            }
            if (dino instanceof PrehistoricShearable) {
                PrehistoricShearable shearable = (PrehistoricShearable)((Object)dino);
                this.f_96542_.m_115203_(new ItemStack((ItemLike)Items.f_42574_), x += 16, y);
                if (shearable.isSheared()) {
                    this.f_96542_.m_115203_(new ItemStack((ItemLike)Blocks.f_50375_), x, y);
                }
                if (this.toolTipList.isEmpty() && mouseX >= x && mouseY >= y && mouseX < x + renderSize && mouseY < y + renderSize) {
                    this.toolTipList.add(shearable.isSheared() ? SHEARED : NOT_SHEARED);
                }
            }
            if (Minecraft.m_91087_().f_91074_.m_7500_()) {
                CompoundTag tag = dino.getDebugTag();
                if (dino.m_21525_() || tag.m_128471_("disableGoalAI") || tag.m_128471_("disableMoveAI") || tag.m_128471_("disableLookAI")) {
                    this.f_96542_.m_115203_(new ItemStack((ItemLike)Items.f_42751_), x += 16, y);
                    if (this.toolTipList.isEmpty() && mouseX >= x && mouseY >= y && mouseX < x + renderSize && mouseY < y + renderSize) {
                        this.toolTipList.add((Component)new TextComponent(String.format("Disabled AI: %b, Goal: %b, Move: %b, Look: %b", dino.m_21525_(), tag.m_128471_("disableGoalAI"), tag.m_128471_("disableMoveAI"), tag.m_128471_("disableLookAI"))));
                    }
                }
                if (!dino.getVariantId().isBlank()) {
                    this.f_96542_.m_115203_(new ItemStack((ItemLike)Items.f_42497_), x += 16, y);
                    if (this.toolTipList.isEmpty() && mouseX >= x && mouseY >= y && mouseX < x + renderSize && mouseY < y + renderSize) {
                        this.toolTipList.add((Component)new TextComponent("Variant: " + dino.getVariantId()));
                    }
                }
            }
        }
    }

    private List<String> loadBio(LivingEntity entity) {
        String name;
        if (entity instanceof Prehistoric) {
            name = ((Prehistoric)entity).info().resourceName;
        } else if (entity instanceof PrehistoricFish) {
            name = ((PrehistoricFish)entity).info().resourceName;
        } else if (entity instanceof Quagga) {
            name = "quagga";
        } else {
            return List.of();
        }
        String bio = DinopediaBioLoader.INSTANCE.getDinopediaBio(name);
        StringSplitter stringSplitter = this.f_96547_.m_92865_();
        ArrayList<String> list = new ArrayList<String>();
        stringSplitter.m_92364_(bio, 195, Style.f_131099_, true, (style, i, j) -> {
            String string2 = bio.substring(i, j);
            list.add(StringUtils.stripEnd((String)string2, (String)" \n"));
        });
        return list;
    }

    private void renderPrehistoricBio(PoseStack poseStack) {
        poseStack.m_85836_();
        float scale = 0.75f;
        poseStack.m_85841_(scale, scale, scale);
        int right = 0;
        int left = 0;
        int offset = this.currentPage - 1;
        List currentLines = this.currentBio.stream().skip((long)offset * 42L).limit(42L).toList();
        for (int i = 0; i < currentLines.size(); ++i) {
            if (i <= 20) {
                String string = (String)currentLines.get(i);
                float f = this.getScaledX(true, 195, scale);
                Objects.requireNonNull(this.f_96547_);
                this.f_96547_.m_92883_(poseStack, string, f, (float)(this.topPos + 10 + 9 * ++left) / scale, 10321511);
                continue;
            }
            String string = (String)currentLines.get(i);
            float f = this.getScaledX(false, 195, scale);
            Objects.requireNonNull(this.f_96547_);
            this.f_96547_.m_92883_(poseStack, string, f, (float)(this.topPos + 10 + 9 * ++right) / scale, 10321511);
        }
        poseStack.m_85849_();
    }

    public boolean m_7043_() {
        return false;
    }

    static class DinopediaPageButton
    extends Button {
        private final boolean isForward;

        public DinopediaPageButton(int x, int y, int width, int height, boolean isForward, Button.OnPress onPress) {
            super(x, y, width, height, (Component)new TextComponent(""), onPress);
            this.isForward = isForward;
        }

        public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)DINOPEDIA_BACKGROUND);
            this.m_93228_(poseStack, this.f_93620_, this.f_93621_, this.isForward ? 0 : 34, 223, 34, 30);
        }
    }
}

