/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.DebugCenteredPath;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.DebugLargePath;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PlayerNodeEvaluator;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PlayerPath;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PlayerPathFinder;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.PathNavigationRegion;
import org.jetbrains.annotations.Nullable;

public class DebugPathFinder
extends PlayerPathFinder {
    public boolean useCentered;

    public DebugPathFinder(PlayerNodeEvaluator nodeEvaluator, int maxVisitedNodes, boolean useCentered) {
        super(nodeEvaluator, maxVisitedNodes);
        this.useCentered = useCentered;
    }

    @Override
    @Nullable
    public PlayerPath findPath(PathNavigationRegion region, Player player, Set<BlockPos> targetPositions, float maxRange, int accuracy, float searchDepthMultiplier) {
        PlayerPath path = super.findPath(region, player, targetPositions, maxRange, accuracy, searchDepthMultiplier);
        return path == null ? null : (this.useCentered ? DebugCenteredPath.createFromPath(path) : DebugLargePath.createFromPath(path));
    }
}

