/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation;

import com.github.teamfossilsarcheology.fossil.client.ClientInit;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.PathingScreen;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.instruction.InstructionRenderUtil;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PathingDebug;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PathingRenderUtil;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PlayerPath;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PlayerPathNavigation;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.WaterPathFinder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.util.Color;

public class PathingRenderer {
    public static int pathIndex;

    public static void reverseIndex() {
        if (PathingScreen.currentNav.getPath() != null) {
            int max = PathingScreen.currentNav.getPath().getNodeCount();
            if (pathIndex > 0) {
                --pathIndex;
            } else if (pathIndex == 0) {
                pathIndex = max - 1;
            }
        }
        if (PathingDebug.pathNavigation4 != null && PathingDebug.pathNavigation4.sweepStartPos != null) {
            PathingDebug.pathNavigation4.followThePath();
        }
        if (PathingDebug.pathNavigation5 != null && PathingDebug.pathNavigation5.sweepStartPos != null) {
            PathingDebug.pathNavigation5.followThePath();
        }
    }

    public static void advanceIndex() {
        if (PathingScreen.currentNav.getPath() != null) {
            int max = PathingScreen.currentNav.getPath().getNodeCount();
            if (pathIndex < max - 1) {
                ++pathIndex;
            } else if (pathIndex == max - 1) {
                pathIndex = 0;
            }
        }
        if (PathingDebug.pathNavigation4 != null && PathingDebug.pathNavigation4.sweepStartPos != null) {
            PathingDebug.pathNavigation4.followThePath();
        }
        if (PathingDebug.pathNavigation5 != null && PathingDebug.pathNavigation5.sweepStartPos != null) {
            PathingDebug.pathNavigation5.followThePath();
        }
    }

    public static void render(PoseStack poseStack, MultiBufferSource buffer, float partialTicks, long finishNanoTime) {
        if (PathingDebug.pos1 != null && PathingDebug.pos2 != null) {
            poseStack.m_85836_();
            PathingRenderer.renderPath(PathingScreen.currentNav, poseStack, buffer, partialTicks);
            poseStack.m_85849_();
        }
        if (PathingDebug.pos1 != null) {
            PathingRenderUtil.renderLineBox(poseStack, buffer, PathingDebug.pos1);
        }
        if (PathingDebug.pos2 != null) {
            PathingRenderUtil.renderLineBox(poseStack, buffer, PathingDebug.pos2);
        }
        if (PathingDebug.showHelpMenu) {
            BlockPos targetPos = PathingDebug.getBlockHitResult(Minecraft.m_91087_());
            if (PathingDebug.pos1 != null) {
                InstructionRenderUtil.renderWholeBox(poseStack, targetPos, Color.ofRGBA((float)0.0f, (float)0.0f, (float)1.0f, (float)0.5f), finishNanoTime);
            } else {
                InstructionRenderUtil.renderWholeBox(poseStack, targetPos, Color.ofRGBA((float)0.0f, (float)1.0f, (float)0.0f, (float)0.5f), finishNanoTime);
            }
            InstructionRenderUtil.renderFloatingText(poseStack, Minecraft.m_91087_(), String.valueOf(PathingDebug.pickBlockOffset), Vec3.m_82512_((Vec3i)targetPos).m_82520_(0.0, 0.5, 0.0));
        }
    }

    private static void renderPath(PlayerPathNavigation pathNav, PoseStack poseStack, MultiBufferSource buffer, float partialTicks) {
        PlayerPath path = pathNav.getPath();
        Minecraft mc = Minecraft.m_91087_();
        boolean renderNeigbours = false;
        boolean renderPath = true;
        boolean renderLine = true;
        boolean renderOpenSet = false;
        boolean renderClosedSet = true;
        boolean renderSweep = true;
        boolean renderWantedPos = true;
        if (path != null) {
            int i;
            int n = pathIndex = pathIndex >= path.getNodeCount() ? path.getNodeCount() - 1 : pathIndex;
            if (renderPath) {
                for (i = 0; i < path.nodes.size(); ++i) {
                    Node node = path.getNode(i);
                    AABB targetArea = new AABB(new BlockPos(node.f_77271_, node.f_77272_, node.f_77273_));
                    if (i == pathIndex) {
                        LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)buffer.m_6299_((RenderType)RenderType.f_110371_), (AABB)targetArea, (float)0.0f, (float)((float)i / (float)(path.nodes.size() - 1)), (float)1.0f, (float)0.25f);
                        continue;
                    }
                    LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)buffer.m_6299_((RenderType)RenderType.f_110371_), (AABB)targetArea, (float)1.0f, (float)((float)i / (float)(path.nodes.size() - 1)), (float)1.0f, (float)0.25f);
                }
            }
            if (renderOpenSet) {
                for (Node node : path.getOpenSet()) {
                    double maxDistanceToWaypoint = 0.5;
                    AABB targetArea = new AABB((double)((float)node.f_77271_ + 0.5f) - maxDistanceToWaypoint / 2.0, (double)((float)node.f_77272_ + 0.01f), (double)((float)node.f_77273_ + 0.5f) - maxDistanceToWaypoint / 2.0, (double)((float)node.f_77271_ + 0.5f) + maxDistanceToWaypoint / 2.0, (double)node.f_77272_ + 0.1, (double)((float)node.f_77273_ + 0.5f) + maxDistanceToWaypoint / 2.0);
                    LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)buffer.m_6299_((RenderType)RenderType.f_110371_), (AABB)targetArea, (float)0.8f, (float)1.0f, (float)1.0f, (float)0.5f);
                }
            }
            if (renderLine && path.getNodeCount() == 2) {
                PathingRenderUtil.renderLine(poseStack, path.getNode(0), path.getNode(1));
            }
            if (renderClosedSet && path.getClosedSet().length > 0) {
                if (path.getClosedSet().length != PathingScreen.baseTick) {
                    PathingScreen.baseTick = path.getClosedSet().length;
                    if (PathingScreen.tickSlider != null) {
                        PathingScreen.tickSlider.setMaxValue(PathingScreen.baseTick);
                    }
                    if (PathingScreen.baseTick < PathingScreen.tick) {
                        PathingScreen.tick = PathingScreen.baseTick;
                    }
                }
                for (i = 0; i < PathingScreen.tick; ++i) {
                    Node node2 = path.getClosedSet()[i];
                    AABB targetArea = new AABB((double)node2.f_77271_ + 0.25, (double)node2.f_77272_ + 0.25, (double)node2.f_77273_ + 0.25, (double)node2.f_77271_ + 0.75, (double)node2.f_77272_ + 0.75, (double)node2.f_77273_ + 0.75);
                    LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)buffer.m_6299_((RenderType)RenderType.f_110371_), (AABB)targetArea, (float)1.0f, (float)(i == PathingScreen.tick ? 1.0f : 0.0f), (float)0.0f, (float)0.5f);
                }
                PathingRenderUtil.renderTextBatch(poseStack, mc, path.getClosedSet(), PathingScreen.tick);
            }
            if (renderSweep) {
                if (pathNav.sweepStartPos != null) {
                    Vec3 wantedPos = pathNav.sweepStartPos;
                    AABB targetArea = new AABB(wantedPos.f_82479_ - 0.25, wantedPos.f_82480_ - 0.25, wantedPos.f_82481_ - 0.25, wantedPos.f_82479_ + 0.25, wantedPos.f_82480_ + 0.25, wantedPos.f_82481_ + 0.25);
                    LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)buffer.m_6299_((RenderType)RenderType.f_110371_), (AABB)targetArea, (float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                }
                if (pathNav.sweepWantedPos != null) {
                    Vec3 wantedPos = pathNav.sweepWantedPos;
                    poseStack.m_85836_();
                    poseStack.m_85837_(wantedPos.f_82479_, wantedPos.f_82480_, wantedPos.f_82481_);
                    mc.m_91289_().m_110912_(Blocks.f_50350_.m_49966_(), poseStack, buffer, mc.m_91290_().m_114394_((Entity)mc.f_91074_, partialTicks), OverlayTexture.f_118083_);
                    poseStack.m_85849_();
                }
                if (WaterPathFinder.sweeped != null) {
                    for (BlockPos blockPos : WaterPathFinder.sweeped) {
                        AABB targetArea = new AABB((double)blockPos.m_123341_() - 0.25, (double)blockPos.m_123342_() - 0.25, (double)blockPos.m_123343_() - 0.25, (double)blockPos.m_123341_() + 0.25, (double)blockPos.m_123342_() + 0.25, (double)blockPos.m_123343_() + 0.25);
                        targetArea = targetArea.m_82386_((double)(-PathingDebug.pos1.m_123341_()), (double)(-PathingDebug.pos1.m_123342_()), (double)(-PathingDebug.pos1.m_123343_()));
                        LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)buffer.m_6299_((RenderType)RenderType.f_110371_), (AABB)targetArea, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                    }
                }
            }
            if (renderWantedPos && pathNav.wantedPos != null) {
                Vec3 wantedPos = pathNav.wantedPos.m_82520_(0.0, 1.0, 0.0);
                AABB targetArea = new AABB(wantedPos.f_82479_ - 0.25, wantedPos.f_82480_ - 0.25, wantedPos.f_82481_ - 0.25, wantedPos.f_82479_ + 0.25, wantedPos.f_82480_ + 0.25, wantedPos.f_82481_ + 0.25);
                LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)buffer.m_6299_((RenderType)RenderType.f_110371_), (AABB)targetArea, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            Vec3 pos = path.getEntityPosAtNode(pathIndex);
            AABB aABB = PathingRenderer.getBigHitbox().m_82386_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
            LevelRenderer.m_109646_((PoseStack)poseStack, (VertexConsumer)buffer.m_6299_((RenderType)RenderType.f_110371_), (AABB)aABB, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            if (renderNeigbours) {
                Node[] neighbors = new Node[6400];
                BlockPos[] neighborsX = new BlockPos[6400];
                PathNavigationRegion pathNavigationRegion = new PathNavigationRegion((Level)mc.f_91073_, PathingDebug.pos1.m_142082_(-24, -24, -24), PathingDebug.pos1.m_142082_(24, 24, 24));
                pathNav.nodeEvaluator.prepare(pathNavigationRegion, (Player)mc.f_91074_);
                pathNav.nodeEvaluator.getBlockedNeighbors(neighbors, path.getNode(pathIndex), neighborsX);
                pathNav.nodeEvaluator.done();
                for (Node node : neighbors) {
                    if (node == null) continue;
                    poseStack.m_85836_();
                    poseStack.m_85837_((double)node.f_77271_, (double)node.f_77272_, (double)node.f_77273_);
                    if (node.f_77282_ == BlockPathTypes.BLOCKED) {
                        mc.m_91289_().m_110912_(Blocks.f_50075_.m_49966_(), poseStack, buffer, mc.m_91290_().m_114394_((Entity)mc.f_91074_, partialTicks), OverlayTexture.f_118083_);
                    } else {
                        mc.m_91289_().m_110912_(Blocks.f_50033_.m_49966_(), poseStack, buffer, mc.m_91290_().m_114394_((Entity)mc.f_91074_, partialTicks), OverlayTexture.f_118083_);
                    }
                    poseStack.m_85849_();
                }
                for (Node node : neighborsX) {
                    if (node == null) continue;
                    poseStack.m_85836_();
                    poseStack.m_85837_((double)node.m_123341_(), (double)node.m_123342_(), (double)node.m_123343_());
                    mc.m_91289_().m_110912_(Blocks.f_50058_.m_49966_(), poseStack, buffer, mc.m_91290_().m_114394_((Entity)mc.f_91074_, partialTicks), OverlayTexture.f_118083_);
                    poseStack.m_85849_();
                }
            }
        }
    }

    public static void renderOverlay(PoseStack poseStack) {
        Minecraft mc = Minecraft.m_91087_();
        poseStack.m_85836_();
        float yPosition = (float)(0.2 * (double)mc.m_91268_().m_85446_());
        if (PathingDebug.showHelpMenu) {
            float xPos = (float)(0.7 * (double)mc.m_91268_().m_85445_());
            mc.f_91062_.m_92763_(poseStack, (Component)new TranslatableComponent("Open Screen: %s", new Object[]{ClientInit.pathingScreenKey.m_90863_()}), xPos, yPosition + 120.0f, 15657968);
            mc.f_91062_.m_92763_(poseStack, (Component)new TextComponent("Set pos 1: Left click"), xPos, yPosition + 140.0f, 15657968);
            mc.f_91062_.m_92763_(poseStack, (Component)new TextComponent("Set pos 2: Right click"), xPos, yPosition + 160.0f, 15657968);
            mc.f_91062_.m_92763_(poseStack, (Component)new TextComponent("Set sweep pos: Middle mouse"), xPos, yPosition + 180.0f, 15657968);
            mc.f_91062_.m_92763_(poseStack, (Component)new TranslatableComponent("Repath: %s", new Object[]{ClientInit.debugRepathKey.m_90863_()}), xPos, yPosition + 200.0f, 15657968);
            mc.f_91062_.m_92763_(poseStack, (Component)new TranslatableComponent("Advance: %s", new Object[]{ClientInit.debugAdvanceKey.m_90863_()}), xPos, yPosition + 220.0f, 15657968);
            mc.f_91062_.m_92763_(poseStack, (Component)new TranslatableComponent("Reverse: %s", new Object[]{ClientInit.debugReverseKey.m_90863_()}), xPos, yPosition + 240.0f, 15657968);
        }
        poseStack.m_85849_();
    }

    public static AABB getBigHitbox() {
        float width = PathingRenderer.getBbWidth() / 2.0f;
        float height = PathingRenderer.getBbHeight();
        return new AABB((double)(-width), 0.0, (double)(-width), (double)width, (double)height, (double)width);
    }

    public static float getBbWidth() {
        return (float)PathingScreen.bbWidth;
    }

    public static float getBbHeight() {
        return (float)PathingScreen.bbHeight;
    }
}

