/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.DebugPathFinder;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PathingDebug;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PathingRenderer;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PlayerNodeEvaluator;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PlayerPath;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PlayerPathFinder;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PlayerPathNavigation;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SweepPathNavigation
extends PlayerPathNavigation {
    @Nullable
    private BlockPos pathToPosition;
    static final float EPSILON = 1.0E-8f;

    public SweepPathNavigation(Player player, Level level) {
        super(player, level, "Sweep");
    }

    @Override
    protected PlayerPathFinder createPathFinder(int maxVisitedNodes) {
        this.nodeEvaluator = new PlayerNodeEvaluator();
        return new DebugPathFinder(this.nodeEvaluator, maxVisitedNodes, false);
    }

    @Override
    protected void followThePath() {
        Vec3 max;
        Vec3 base;
        PlayerPath path = Objects.requireNonNull(this.path);
        path.sweepNextNodeIndex = path.getDebugNodeIndex();
        Vec3 entityPos = this.sweepStartPos;
        int pathLength = path.getNodeCount();
        for (int i = path.getDebugNodeIndex(); i < path.getNodeCount(); ++i) {
            if ((double)path.getNode((int)i).f_77272_ == Math.floor(entityPos.f_82480_)) continue;
            pathLength = i;
            break;
        }
        if (this.tryShortcut(path, entityPos, pathLength, base = entityPos.m_82520_((double)(-PathingRenderer.getBbWidth() * 0.5f), 0.0, (double)(-PathingRenderer.getBbWidth() * 0.5f)), max = base.m_82520_((double)PathingRenderer.getBbWidth(), (double)PathingRenderer.getBbHeight(), (double)PathingRenderer.getBbWidth())) && (this.isAt(path, 0.5f) || this.atElevationChange(path) && this.isAt(path, PathingRenderer.getBbWidth() * 0.5f))) {
            path.setSweepNodeIndex(path.sweepNextNodeIndex + 1);
        }
    }

    @Override
    public void setSweepStartPos(Vec3 vec) {
        super.setSweepStartPos(vec);
        if (this.path != null) {
            this.followThePath();
            this.tick();
        }
    }

    @Override
    public PlayerPath createPath(BlockPos blockPos, int i) {
        this.pathToPosition = blockPos;
        return super.createPath(blockPos, i);
    }

    @Override
    public PlayerPath createPath(Entity entity, int i) {
        this.pathToPosition = entity.m_142538_();
        return super.createPath(entity, i);
    }

    @Override
    public void tick() {
        Vec3 vec3 = this.path.getNextEntityPos((Entity)this.player);
        this.setNextWantedPosition(vec3.f_82479_, this.getGroundY(vec3), vec3.f_82481_);
        vec3 = this.path.getSweepEntityPos((Entity)this.player);
        this.setSweepWantedPosition(vec3.f_82479_, this.getGroundY(vec3), vec3.f_82481_);
        if (this.isDone() && this.pathToPosition != null) {
            if (this.pathToPosition.m_203195_((Position)this.player.m_20182_(), (double)PathingRenderer.getBbWidth()) || this.player.m_20186_() > (double)this.pathToPosition.m_123342_() && new BlockPos((double)this.pathToPosition.m_123341_(), this.player.m_20186_(), (double)this.pathToPosition.m_123343_()).m_203195_((Position)this.player.m_20182_(), (double)PathingRenderer.getBbWidth())) {
                this.pathToPosition = null;
            } else {
                this.setNextWantedPosition(this.pathToPosition.m_123341_(), this.pathToPosition.m_123342_(), this.pathToPosition.m_123343_());
                this.setSweepWantedPosition(this.pathToPosition.m_123341_(), this.pathToPosition.m_123342_(), this.pathToPosition.m_123343_());
            }
        }
    }

    private boolean isAt(PlayerPath path, float threshold) {
        Vec3 entityPos = this.sweepStartPos;
        Vec3 pathPos = path.getSweepEntityPos((Entity)this.player);
        return Mth.m_14154_((float)((float)(entityPos.f_82479_ - pathPos.f_82479_))) < threshold && Mth.m_14154_((float)((float)(entityPos.f_82481_ - pathPos.f_82481_))) < threshold && Math.abs(entityPos.f_82480_ - pathPos.f_82480_) <= 1.0;
    }

    private boolean atElevationChange(PlayerPath path) {
        int curr = path.sweepNextNodeIndex;
        int end = Math.min(path.getNodeCount(), curr + Mth.m_14167_((float)(PathingRenderer.getBbWidth() * 0.5f)) + 1);
        int currY = path.getNode((int)curr).f_77272_;
        for (int i = curr + 1; i < end; ++i) {
            if (path.getNode((int)i).f_77272_ == currY) continue;
            return true;
        }
        return false;
    }

    private boolean tryShortcut(PlayerPath path, Vec3 entityPos, int pathLength, Vec3 base, Vec3 max) {
        int i = pathLength;
        while (--i > path.getDebugNodeIndex()) {
            Vec3 vec = path.getEntityPosAtNode(i).m_82546_(entityPos);
            if (this.isCollisionOnPath(vec, base, max)) continue;
            path.setSweepNodeIndex(i);
            return false;
        }
        return true;
    }

    private boolean isCollisionOnPath(Vec3 pathVec, Vec3 minBounds, Vec3 maxBounds) {
        float pathLength = (float)pathVec.m_82553_();
        if (pathLength < 1.0E-8f) {
            return false;
        }
        float[] trailingPositions = new float[3];
        int[] leadingEdges = new int[3];
        int[] trailingEdges = new int[3];
        int[] stepDirections = new int[3];
        float[] stepDelta = new float[3];
        float[] stepLength = new float[3];
        float[] normedAxis = new float[3];
        for (Direction.Axis axis : Direction.Axis.values()) {
            float axisLength = SweepPathNavigation.chooseLengthForAxis(axis, pathVec);
            boolean stepDirection = axisLength >= 0.0f;
            int idx = axis.ordinal();
            stepDirections[idx] = stepDirection ? 1 : -1;
            float lead = SweepPathNavigation.chooseLengthForAxis(axis, stepDirection ? maxBounds : minBounds);
            trailingPositions[idx] = SweepPathNavigation.chooseLengthForAxis(axis, stepDirection ? minBounds : maxBounds);
            leadingEdges[idx] = SweepPathNavigation.leadEdgesToInt(lead, stepDirections[idx]);
            trailingEdges[idx] = SweepPathNavigation.trailEdgeToInt(trailingPositions[idx], stepDirections[idx]);
            normedAxis[idx] = axisLength / pathLength;
            stepDelta[idx] = Mth.m_14154_((float)(pathLength / axisLength));
            float dist = stepDirection ? (float)(leadingEdges[idx] + 1) - lead : lead - (float)leadingEdges[idx];
            stepLength[idx] = stepDelta[idx] < Float.POSITIVE_INFINITY ? stepDelta[idx] * dist : Float.POSITIVE_INFINITY;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        float previousStepLength = 0.0f;
        do {
            Direction.Axis axis = stepLength[0] < stepLength[1] ? (stepLength[0] < stepLength[2] ? Direction.Axis.X : Direction.Axis.Z) : (stepLength[1] < stepLength[2] ? Direction.Axis.Y : Direction.Axis.Z);
            int idx = axis.ordinal();
            float dt = stepLength[idx] - previousStepLength;
            previousStepLength = stepLength[idx];
            int n = idx;
            leadingEdges[n] = leadingEdges[n] + stepDirections[idx];
            int n2 = idx;
            stepLength[n2] = stepLength[n2] + stepDelta[idx];
            for (Direction.Axis axis2 : Direction.Axis.values()) {
                int i;
                int n3 = i = axis2.ordinal();
                trailingPositions[n3] = trailingPositions[n3] + dt * normedAxis[i];
                trailingEdges[i] = SweepPathNavigation.trailEdgeToInt(trailingPositions[i], stepDirections[i]);
            }
            int stepX = stepDirections[0];
            int minX = axis == Direction.Axis.X ? leadingEdges[0] : trailingEdges[0];
            int maxX = leadingEdges[0] + stepX;
            int stepY = stepDirections[1];
            int minY = axis == Direction.Axis.Y ? leadingEdges[1] : trailingEdges[1];
            int maxY = leadingEdges[1] + stepY;
            int stepZ = stepDirections[2];
            int minZ = axis == Direction.Axis.Z ? leadingEdges[2] : trailingEdges[2];
            int maxZ = leadingEdges[2] + stepZ;
            for (int x = minX; x != maxX; x += stepX) {
                for (int z = minZ; z != maxZ; z += stepZ) {
                    if (!this.isCollisionAtColumn(x, minY, z, maxY, stepY, pos)) continue;
                    return true;
                }
            }
        } while (previousStepLength <= pathLength);
        return false;
    }

    private boolean isCollisionAtColumn(int x, int minY, int z, int maxY, int stepY, BlockPos.MutableBlockPos pos) {
        for (int y = minY; y != maxY; y += stepY) {
            BlockState block = this.level.m_8055_((BlockPos)pos.m_122178_(x, y, z));
            if (block.m_60647_((BlockGetter)this.level, (BlockPos)pos, PathComputationType.LAND)) continue;
            return true;
        }
        BlockPathTypes in = this.nodeEvaluator.getBlockPathType((BlockGetter)this.level, x, minY, z);
        float malus = PathingDebug.getPathfindingMalus(in);
        if (malus < 0.0f || malus >= 8.0f) {
            return true;
        }
        BlockPathTypes below = this.nodeEvaluator.getBlockPathType((BlockGetter)this.level, x, minY - 1, z);
        if (below == BlockPathTypes.WATER || below == BlockPathTypes.LAVA || below == BlockPathTypes.OPEN) {
            return true;
        }
        return in == BlockPathTypes.DAMAGE_FIRE || in == BlockPathTypes.DANGER_FIRE || in == BlockPathTypes.DAMAGE_OTHER;
    }

    static float chooseLengthForAxis(Direction.Axis axis, Vec3 vec) {
        return (float)axis.m_6150_(vec.f_82479_, vec.f_82480_, vec.f_82481_);
    }

    static int leadEdgesToInt(float coord, int step) {
        return Mth.m_14143_((float)(coord - (float)step * 1.0E-8f));
    }

    static int trailEdgeToInt(float coord, int step) {
        return Mth.m_14143_((float)(coord + (float)step * 1.0E-8f));
    }
}

