/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation;

import com.github.teamfossilsarcheology.fossil.client.gui.debug.PathingScreen;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.DebugLargePath;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PathingDebug;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PathingRenderer;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PlayerNodeEvaluator;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PlayerPath;
import com.github.teamfossilsarcheology.fossil.client.gui.debug.navigation.PlayerPathFinder;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.Target;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class WaterPathFinder
extends PlayerPathFinder {
    public static List<BlockPos> sweeped;
    static final float EPSILON = 1.0E-8f;

    public WaterPathFinder(PlayerNodeEvaluator nE, int i) {
        super(nE, i);
    }

    @Override
    @Nullable
    public PlayerPath findPath(PathNavigationRegion region, Player player, Set<BlockPos> targetPositions, float maxRange, int accuracy, float searchDepthMultiplier) {
        this.openSet.m_77081_();
        this.closedSet.clear();
        this.nodeEvaluator.prepare(region, player);
        Node node = this.nodeEvaluator.getStart();
        Map<Target, BlockPos> map = targetPositions.stream().collect(Collectors.toMap(blockPos -> this.nodeEvaluator.getGoal(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()), Function.identity()));
        long start = System.nanoTime();
        if (targetPositions.size() == 1 && PathingDebug.pos3 != null) {
            Vec3 max;
            Vec3 base;
            double f;
            double e;
            Map.Entry target = (Map.Entry)map.entrySet().stream().toList().get(0);
            double d = (double)((Target)target.getKey()).f_77271_ + (double)((int)((double)PathingRenderer.getBbWidth() + 1.0)) * 0.5;
            Vec3 vec = new Vec3(d, e = (double)((Target)target.getKey()).f_77272_, f = (double)((Target)target.getKey()).f_77273_ + (double)((int)((double)PathingRenderer.getBbWidth() + 1.0)) * 0.5).m_82546_(PathingDebug.pos3);
            if (this.sweep(vec, base = PathingDebug.pos3.m_82520_((double)(-PathingRenderer.getBbWidth() * 0.5f), 0.0, (double)(-PathingRenderer.getBbWidth() * 0.5f)), max = base.m_82520_((double)PathingRenderer.getBbWidth(), (double)PathingRenderer.getBbHeight(), (double)PathingRenderer.getBbWidth()))) {
                DebugLargePath path = new DebugLargePath(List.of(node, (Node)target.getKey()), (BlockPos)target.getValue(), false);
                path.setDebug(this.openSet.m_164684_(), (Node[])this.closedSet.toArray(Node[]::new), map.keySet());
                return path;
            }
        }
        System.out.println("Sweep time: " + (System.nanoTime() - start));
        start = System.nanoTime();
        PlayerPath path = this.findPath(node, map, maxRange, accuracy, searchDepthMultiplier);
        System.out.println("Path time: " + (System.nanoTime() - start));
        this.nodeEvaluator.done();
        if (path != null) {
            path = DebugLargePath.createFromPath(path);
            path.setDebug(this.openSet.m_164684_(), (Node[])this.closedSet.toArray(Node[]::new), map.keySet());
        }
        return path;
    }

    Direction getDirection(Node pos, Set<Target> targets) {
        for (Target target : targets) {
            int xDiff = target.f_77271_ - pos.f_77271_;
            if (xDiff != 0) {
                return xDiff > 0 ? Direction.EAST : Direction.WEST;
            }
            int zDiff = target.f_77273_ - pos.f_77273_;
            if (zDiff != 0) {
                return zDiff > 0 ? Direction.SOUTH : Direction.NORTH;
            }
            int yDiff = target.f_77272_ - pos.f_77272_;
            if (yDiff == 0) continue;
            return yDiff > 0 ? Direction.UP : Direction.DOWN;
        }
        return Direction.DOWN;
    }

    @Override
    @Nullable
    protected PlayerPath findPath(Node node, Map<Target, BlockPos> targetPos, float maxRange, int accuracy, float searchDepthMultiplier) {
        Set<Target> set = targetPos.keySet();
        node.f_77275_ = 0.0f;
        node.f_77277_ = node.f_77276_ = this.getBestH(node, set);
        this.openSet.m_77081_();
        this.openSet.m_77084_(node);
        Target targetN = (Target)set.stream().findFirst().get();
        System.out.println("Distance " + node.m_77293_((Node)targetN) + " dist: " + this.dist(node, (Node)targetN));
        int i = 1;
        HashSet set3 = Sets.newHashSetWithExpectedSize((int)set.size());
        int j = (int)((float)this.maxVisitedNodes * searchDepthMultiplier);
        while (!this.openSet.m_77092_() && i < j) {
            System.out.println(i);
            Node node2 = this.openSet.m_77091_();
            this.closedSet.add(node2);
            System.out.println(node2 + " f: " + node2.f_77277_ + " g: " + node2.f_77275_ + " h: " + node2.f_77276_ + " walkDistance: " + node2.f_77280_);
            node2.f_77279_ = true;
            for (Target target2 : set) {
                if (node2.m_77304_((Node)target2) > (float)accuracy) continue;
                target2.m_77509_();
                set3.add(target2);
            }
            if (!set3.isEmpty()) break;
            if (node2.m_77293_(node) >= maxRange) continue;
            int k = this.nodeEvaluator.getNeighbors(this.neighbors, node2);
            for (int l = 0; l < k; ++l) {
                Node node3 = this.neighbors[l];
                float f = node2.m_77293_(node3);
                node3.f_77280_ = node2.f_77280_ + f;
                float g = node2.f_77275_ + f + node3.f_77281_;
                if (node3.f_77280_ >= maxRange || node3.m_77303_() && g >= node3.f_77275_) continue;
                node3.f_77278_ = node2;
                node3.f_77275_ = g;
                node3.f_77276_ = this.getBestH(node3, set);
                if (node3.m_77303_()) {
                    this.openSet.m_77086_(node3, node3.f_77275_ + node3.f_77276_);
                    continue;
                }
                node3.f_77277_ = node3.f_77275_ + node3.f_77276_;
                System.out.println("Adding " + node3 + " f: " + node3.f_77277_ + " g: " + node3.f_77275_ + " h: " + node3.f_77276_ + " walkDistance: " + node3.f_77280_);
                this.openSet.m_77084_(node3);
            }
            ++i;
        }
        Optional<PlayerPath> optional = !set3.isEmpty() ? set3.stream().map(target -> this.reconstructPath(target.m_77508_(), (BlockPos)targetPos.get(target), true)).min(Comparator.comparingInt(PlayerPath::getNodeCount)) : set.stream().map(target -> this.reconstructPath(target.m_77508_(), (BlockPos)targetPos.get(target), false)).min(Comparator.comparingDouble(PlayerPath::getDistToTarget).thenComparingInt(PlayerPath::getNodeCount));
        return optional.orElse(null);
    }

    @Override
    public float getBestH(Node node, Set<Target> targets) {
        float f = Float.MAX_VALUE;
        for (Target target : targets) {
            float g = this.dist(node, (Node)target);
            target.m_77503_(g, node);
            f = Math.min(g, f);
        }
        return f;
    }

    public float dist(Node f, Node l) {
        float xDiff = Math.abs(l.f_77271_ - f.f_77271_);
        float yDiff = Math.abs(l.f_77272_ - f.f_77272_);
        float zDiff = Math.abs(l.f_77273_ - f.f_77273_);
        float min = Math.min(Math.min(xDiff, yDiff), zDiff);
        float max = Math.max(Math.max(xDiff, yDiff), zDiff);
        float tripleAxis = min;
        float doubleAxis = xDiff + yDiff + zDiff - max - 2.0f * min;
        float singleAxis = max - doubleAxis - tripleAxis;
        return (float)PathingScreen.face * singleAxis + (float)PathingScreen.edge * doubleAxis + (float)PathingScreen.corner * tripleAxis;
    }

    private boolean sweep(Vec3 vec, Vec3 base, Vec3 max) {
        sweeped = new ArrayList<BlockPos>();
        float t = 0.0f;
        float max_t = (float)vec.m_82553_();
        if (max_t < 1.0E-8f) {
            return true;
        }
        float[] trails = new float[3];
        int[] leadEdge = new int[3];
        int[] tri = new int[3];
        int[] step = new int[3];
        float[] tDelta = new float[3];
        float[] tNext = new float[3];
        float[] normed = new float[3];
        for (Direction.Axis axis : Direction.Axis.values()) {
            float value = (float)axis.m_6150_(vec.f_82479_, vec.f_82480_, vec.f_82481_);
            int dir = value >= 0.0f ? 1 : 0;
            int i = axis.ordinal();
            step[i] = dir != 0 ? 1 : -1;
            float lead = (float)(dir != 0 ? axis.m_6150_(max.f_82479_, max.f_82480_, max.f_82481_) : axis.m_6150_(base.f_82479_, base.f_82480_, base.f_82481_));
            trails[i] = (float)(dir != 0 ? axis.m_6150_(base.f_82479_, base.f_82480_, base.f_82481_) : axis.m_6150_(max.f_82479_, max.f_82480_, max.f_82481_));
            leadEdge[i] = WaterPathFinder.leadEdgeToInt(lead, step[i]);
            tri[i] = WaterPathFinder.trailEdgeToInt(trails[i], step[i]);
            normed[i] = value / max_t;
            tDelta[i] = Mth.m_14154_((float)(max_t / value));
            float dist = dir != 0 ? (float)(leadEdge[i] + 1) - lead : lead - (float)leadEdge[i];
            tNext[i] = tDelta[i] < Float.POSITIVE_INFINITY ? tDelta[i] * dist : Float.POSITIVE_INFINITY;
        }
        for (int i = 0; i < 3; ++i) {
            float value = WaterPathFinder.element(vec, i);
            boolean dir = value >= 0.0f;
            step[i] = dir ? 1 : -1;
            float lead = WaterPathFinder.element(dir ? max : base, i);
            trails[i] = WaterPathFinder.element(dir ? base : max, i);
            leadEdge[i] = WaterPathFinder.leadEdgeToInt(lead, step[i]);
            tri[i] = WaterPathFinder.trailEdgeToInt(trails[i], step[i]);
            normed[i] = value / max_t;
            tDelta[i] = Mth.m_14154_((float)(max_t / value));
            float dist = dir ? (float)(leadEdge[i] + 1) - lead : lead - (float)leadEdge[i];
            tNext[i] = tDelta[i] < Float.POSITIVE_INFINITY ? tDelta[i] * dist : Float.POSITIVE_INFINITY;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        do {
            Direction.Axis axis = tNext[0] < tNext[1] ? (tNext[0] < tNext[2] ? Direction.Axis.X : Direction.Axis.Z) : (tNext[1] < tNext[2] ? Direction.Axis.Y : Direction.Axis.Z);
            int idx = axis.ordinal();
            float dt = tNext[idx] - t;
            t = tNext[idx];
            int n = idx;
            leadEdge[n] = leadEdge[n] + step[idx];
            int n2 = idx;
            tNext[n2] = tNext[n2] + tDelta[idx];
            for (Direction.Axis axis2 : Direction.Axis.values()) {
                int i;
                int n3 = i = axis2.ordinal();
                trails[n3] = trails[n3] + dt * normed[i];
                tri[i] = WaterPathFinder.trailEdgeToInt(trails[i], step[i]);
            }
            int stepx = step[0];
            int x0 = idx == 0 ? leadEdge[0] : tri[0];
            int x1 = leadEdge[0] + stepx;
            int stepy = step[1];
            int y0 = idx == 1 ? leadEdge[1] : tri[1];
            int y1 = leadEdge[1] + stepy;
            int stepz = step[2];
            int z0 = idx == 2 ? leadEdge[2] : tri[2];
            int z1 = leadEdge[2] + stepz;
            for (int x = x0; x != x1; x += stepx) {
                for (int z = z0; z != z1; z += stepz) {
                    for (int y = y0; y != y1; y += stepy) {
                        BlockState block = this.nodeEvaluator.level.m_8055_((BlockPos)pos.m_122178_(x, y, z));
                        sweeped.add(pos.m_7949_());
                        if (block.m_60647_((BlockGetter)this.nodeEvaluator.level, (BlockPos)pos, PathComputationType.WATER)) continue;
                        System.out.format("%s, %s", block.m_60734_(), pos);
                        System.out.println();
                        return false;
                    }
                    BlockPathTypes below = this.nodeEvaluator.getBlockPathType((BlockGetter)this.nodeEvaluator.level, x, y0 - 1, z);
                    if (below == BlockPathTypes.LAVA || below == BlockPathTypes.OPEN) {
                        System.out.format("below: %s", below);
                        System.out.println();
                        return false;
                    }
                    BlockPathTypes in = this.nodeEvaluator.getBlockPathType((BlockGetter)this.nodeEvaluator.level, x, y0, z);
                    float malus = PathingDebug.getPathfindingMalus(in);
                    if (malus < 0.0f || malus > 8.0f) {
                        System.out.format("in: %s, %s", in, Float.valueOf(malus));
                        System.out.println();
                        return false;
                    }
                    if (in != BlockPathTypes.DAMAGE_FIRE && in != BlockPathTypes.DANGER_FIRE && in != BlockPathTypes.DAMAGE_OTHER) continue;
                    return false;
                }
            }
        } while (t <= max_t);
        return true;
    }

    static int leadEdgeToInt(float coord, int step) {
        return Mth.m_14143_((float)(coord - (float)step * 1.0E-8f));
    }

    static int trailEdgeToInt(float coord, int step) {
        return Mth.m_14143_((float)(coord + (float)step * 1.0E-8f));
    }

    static float element(Vec3 v, int i) {
        return switch (i) {
            case 0 -> (float)v.f_82479_;
            case 1 -> (float)v.f_82480_;
            case 2 -> (float)v.f_82481_;
            default -> 0.0f;
        };
    }
}

