/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.client.renderer.entity;

import com.github.teamfossilsarcheology.fossil.client.model.AnuTotemModel;
import com.github.teamfossilsarcheology.fossil.client.renderer.RendererFabricFix;
import com.github.teamfossilsarcheology.fossil.client.renderer.entity.layers.AnuTotemOverlayRenderer;
import com.github.teamfossilsarcheology.fossil.entity.AnuTotem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.Random;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.NotNull;

public class AnuTotemRenderer
extends MobRenderer<AnuTotem, AnuTotemModel>
implements RendererFabricFix {
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);

    public AnuTotemRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnuTotemModel(), 0.5f);
        this.m_115326_(new AnuTotemOverlayRenderer((RenderLayerParent<AnuTotem, AnuTotemModel>)this));
    }

    private static void vertex01(VertexConsumer vertexConsumer, Matrix4f matrix4f, int alpha) {
        vertexConsumer.m_85982_(matrix4f, 0.0f, 0.0f, 0.0f).m_6122_(66, 0, 176, alpha).m_5752_();
    }

    private static void vertex2(VertexConsumer vertexConsumer, Matrix4f matrix4f, float y, float g) {
        vertexConsumer.m_85982_(matrix4f, -HALF_SQRT_3 * g, y, -0.5f * g).m_6122_(255, 0, 0, 0).m_5752_();
    }

    private static void vertex3(VertexConsumer vertexConsumer, Matrix4f matrix4f, float y, float g) {
        vertexConsumer.m_85982_(matrix4f, HALF_SQRT_3 * g, y, -0.5f * g).m_6122_(255, 0, 0, 0).m_5752_();
    }

    private static void vertex4(VertexConsumer vertexConsumer, Matrix4f matrix4f, float y, float g) {
        vertexConsumer.m_85982_(matrix4f, 0.0f, y, g).m_6122_(255, 0, 0, 0).m_5752_();
    }

    @NotNull
    public ResourceLocation getTextureLocation(AnuTotem entity) {
        return AnuTotemModel.TEXTURE;
    }

    @Override
    @NotNull
    public ResourceLocation _getTextureLocation(Entity entity) {
        return this.getTextureLocation((AnuTotem)entity);
    }

    protected void setupRotations(AnuTotem entityLiving, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTicks) {
        super.m_7523_((LivingEntity)entityLiving, poseStack, ageInTicks, rotationYaw, partialTicks);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(ageInTicks * ageInTicks * 0.15f));
    }

    public void render(AnuTotem entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        float i = ((float)entity.f_19797_ + partialTicks) / 200.0f;
        float j = Math.min(i > 0.8f ? (i - 0.8f) / 0.2f : 0.0f, 1.0f);
        Random random = new Random(432L);
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110502_());
        poseStack.m_85836_();
        int passes = 0;
        poseStack.m_85837_(0.0, 1.5, 0.0);
        while ((float)passes < (i + i * i) / 2.0f * 60.0f) {
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(random.nextFloat() * 360.0f));
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(random.nextFloat() * 360.0f));
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(random.nextFloat() * 360.0f));
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(random.nextFloat() * 360.0f));
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(random.nextFloat() * 360.0f));
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(random.nextFloat() * 360.0f + i * 90.0f));
            float y = random.nextFloat() * 20.0f + 5.0f + j * 10.0f;
            float m = random.nextFloat() * 2.0f + 1.0f + j * 2.0f;
            Matrix4f pose = poseStack.m_85850_().m_85861_();
            int alpha = (int)(255.0f * (1.0f - j));
            AnuTotemRenderer.vertex01(vertexConsumer, pose, alpha);
            AnuTotemRenderer.vertex2(vertexConsumer, pose, y, m);
            AnuTotemRenderer.vertex3(vertexConsumer, pose, y, m);
            AnuTotemRenderer.vertex01(vertexConsumer, pose, alpha);
            AnuTotemRenderer.vertex3(vertexConsumer, pose, y, m);
            AnuTotemRenderer.vertex4(vertexConsumer, pose, y, m);
            AnuTotemRenderer.vertex01(vertexConsumer, pose, alpha);
            AnuTotemRenderer.vertex4(vertexConsumer, pose, y, m);
            AnuTotemRenderer.vertex2(vertexConsumer, pose, y, m);
            ++passes;
        }
        poseStack.m_85849_();
    }
}

