/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.compat.geckolib;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import software.bernie.geckolib3.core.builder.Animation;
import software.bernie.geckolib3.core.keyframe.AnimationPoint;
import software.bernie.geckolib3.core.keyframe.BoneAnimationQueue;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.core.snapshot.BoneSnapshot;

public class AnimationControllerOverride {
    public static void fixTransitions(List<IBone> modelRendererList, Animation currentAnimation, Map<String, BoneSnapshot> boneSnapshots, double adjustedTick, boolean firstTick, Map<String, Pair<IBone, BoneSnapshot>> boneSnapshotCollection, double transitionLengthTicks, Map<String, BoneAnimationQueue> boneAnimationQueues) {
        HashSet<String> previousBones = new HashSet<String>(boneSnapshots.keySet());
        Set newBones = currentAnimation.boneAnimations.stream().map(boneAnimation -> boneAnimation.boneName).collect(Collectors.toSet());
        previousBones.removeAll(newBones);
        if (firstTick) {
            for (String previousBone : previousBones) {
                boneSnapshots.put(previousBone, new BoneSnapshot((BoneSnapshot)boneSnapshotCollection.get(previousBone).getRight()));
            }
        }
        for (String boneName : previousBones) {
            BoneSnapshot boneSnapshot = boneSnapshots.get(boneName);
            Optional<Object> first = Optional.empty();
            for (IBone bone : modelRendererList) {
                if (!bone.getName().equals(boneName)) continue;
                first = Optional.of(bone);
                break;
            }
            if (first.isEmpty()) continue;
            BoneSnapshot initialSnapshot = ((IBone)first.get()).getInitialSnapshot();
            assert (boneSnapshot != null) : "Bone snapshot was null";
            BoneAnimationQueue boneAnimationQueue = boneAnimationQueues.get(boneName);
            boneAnimationQueue.positionXQueue().add((Object)new AnimationPoint(null, adjustedTick, transitionLengthTicks, (double)(boneSnapshot.positionOffsetX - initialSnapshot.positionOffsetX), 0.0));
            boneAnimationQueue.positionYQueue().add((Object)new AnimationPoint(null, adjustedTick, transitionLengthTicks, (double)(boneSnapshot.positionOffsetY - initialSnapshot.positionOffsetY), 0.0));
            boneAnimationQueue.positionZQueue().add((Object)new AnimationPoint(null, adjustedTick, transitionLengthTicks, (double)(boneSnapshot.positionOffsetZ - initialSnapshot.positionOffsetZ), 0.0));
            boneAnimationQueue.rotationXQueue().add((Object)new AnimationPoint(null, adjustedTick, transitionLengthTicks, (double)(boneSnapshot.rotationValueX - initialSnapshot.rotationValueX), 0.0));
            boneAnimationQueue.rotationYQueue().add((Object)new AnimationPoint(null, adjustedTick, transitionLengthTicks, (double)(boneSnapshot.rotationValueY - initialSnapshot.rotationValueY), 0.0));
            boneAnimationQueue.rotationZQueue().add((Object)new AnimationPoint(null, adjustedTick, transitionLengthTicks, (double)(boneSnapshot.rotationValueY - initialSnapshot.rotationValueY), 0.0));
            boneAnimationQueue.scaleXQueue().add((Object)new AnimationPoint(null, adjustedTick, transitionLengthTicks, (double)(boneSnapshot.scaleValueX - initialSnapshot.scaleValueX), 1.0));
            boneAnimationQueue.scaleXQueue().add((Object)new AnimationPoint(null, adjustedTick, transitionLengthTicks, (double)(boneSnapshot.scaleValueY - initialSnapshot.scaleValueY), 1.0));
            boneAnimationQueue.scaleXQueue().add((Object)new AnimationPoint(null, adjustedTick, transitionLengthTicks, (double)(boneSnapshot.scaleValueZ - initialSnapshot.scaleValueZ), 1.0));
        }
    }
}

