/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity;

import com.github.darkpred.morehitboxes.api.HitboxData;
import com.github.darkpred.morehitboxes.internal.HitboxDataLoader;
import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.entity.data.EntityDataLoader;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricEntityInfo;
import com.github.teamfossilsarcheology.fossil.entity.util.Util;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import com.github.teamfossilsarcheology.fossil.util.TimePeriod;
import dev.architectury.networking.NetworkManager;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class PrehistoricSkeleton
extends Entity
implements IAnimatable {
    private static final EntityDataAccessor<Integer> AGE = SynchedEntityData.m_135353_(PrehistoricSkeleton.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> TYPE = SynchedEntityData.m_135353_(PrehistoricSkeleton.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private final AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    private boolean droppedBiofossil;
    private float frustumWidthRadius;
    private float frustumHeight;
    private AABB cullingBounds = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public ResourceLocation textureLocation;
    public ResourceLocation modelLocation;

    public PrehistoricSkeleton(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.refreshTexturePath();
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(AGE, (Object)0);
        this.f_19804_.m_135372_(TYPE, (Object)PrehistoricEntityInfo.TRICERATOPS.name());
    }

    protected void m_7378_(CompoundTag compound) {
        this.setAge(compound.m_128451_("Age"));
        this.f_19804_.m_135381_(TYPE, (Object)compound.m_128461_("Type"));
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("Age", this.getAge());
        compound.m_128359_("Type", (String)this.f_19804_.m_135370_(TYPE));
    }

    public float m_6080_() {
        return this.m_146908_();
    }

    public void m_5616_(float yHeadRot) {
        this.m_146922_(yHeadRot);
    }

    @NotNull
    protected AABB m_142242_() {
        return this.info().entityType().m_20680_().m_20388_(this.getScale()).m_20393_(this.m_20182_());
    }

    @NotNull
    public EntityDimensions m_6972_(Pose poseIn) {
        return this.info().entityType().m_20680_().m_20388_(this.getScale());
    }

    @NotNull
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41619_()) {
            if (player.m_6144_()) {
                this.m_6021_(this.m_20185_() + (player.m_20185_() - this.m_20185_()) * 0.01, this.m_20186_(), this.m_20189_() + (player.m_20189_() - this.m_20189_()) * 0.01);
            } else {
                double d0 = player.m_20185_() - this.m_20185_();
                double d2 = player.m_20189_() - this.m_20189_();
                this.m_146922_(Util.yawToYRot(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875));
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        if (stack.m_150930_(Items.f_42500_) && !this.isAdult()) {
            if (!this.f_19853_.f_46443_) {
                this.m_5496_(SoundEvents.f_12423_, 0.8f, 1.0f);
                this.setAge(this.getAge() + 1);
                stack.m_41774_(1);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6096_(player, hand);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (amount > 0.0f) {
            this.f_19853_.m_5594_(null, this.m_142538_(), SoundEvents.f_12381_, SoundSource.NEUTRAL, 1.0f, (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.5f);
            if (!this.f_19853_.f_46443_) {
                if (!this.droppedBiofossil) {
                    if (this.info().timePeriod == TimePeriod.CENOZOIC) {
                        this.m_20000_((ItemLike)ModItems.TAR_FOSSIL.get(), 1);
                    } else if (this.info().timePeriod == TimePeriod.PALEOZOIC) {
                        this.m_20000_((ItemLike)ModItems.SHALE_FOSSIL.get(), 1);
                    } else {
                        this.m_20000_((ItemLike)ModItems.BIO_FOSSIL.get(), 1);
                    }
                    this.m_5552_(new ItemStack((ItemLike)Items.f_42500_, Math.min(this.getAge(), this.data().adultAgeDays())), 1.0f);
                    this.droppedBiofossil = true;
                }
                this.m_146870_();
            }
            return true;
        }
        return super.m_6469_(source, amount);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (AGE.equals(key) || TYPE.equals(key)) {
            this.m_6210_();
            this.refreshTexturePath();
        }
        if (TYPE.equals(key) && this.f_19853_.f_46443_) {
            List hitboxesData = HitboxDataLoader.HITBOX_DATA.getHitboxes(FossilMod.location(this.info().resourceName));
            if (hitboxesData != null) {
                float maxFrustumWidthRadius = 0.0f;
                float maxFrustumHeight = 0.0f;
                for (HitboxData hitboxData : hitboxesData) {
                    float h;
                    float w = hitboxData.getFrustumWidthRadius();
                    if (w > maxFrustumWidthRadius) {
                        maxFrustumWidthRadius = w;
                    }
                    if (!((h = hitboxData.getFrustumHeight()) > maxFrustumHeight)) continue;
                    maxFrustumHeight = h;
                }
                this.frustumWidthRadius = maxFrustumWidthRadius;
                this.frustumHeight = maxFrustumHeight;
            } else {
                this.frustumWidthRadius = this.m_20205_();
                this.frustumHeight = this.m_20206_();
            }
            this.makeBoundingBoxForCulling(this.frustumWidthRadius, this.frustumHeight);
        }
    }

    public void refreshTexturePath() {
        if (!this.f_19853_.f_46443_) {
            return;
        }
        String name = this.info().resourceName;
        this.textureLocation = FossilMod.location("textures/entity/" + name + "/" + name + "_skeleton.png");
        this.modelLocation = this.info() == PrehistoricEntityInfo.DICRANURUS || this.info() == PrehistoricEntityInfo.LONCHODOMAS || this.info() == PrehistoricEntityInfo.SCOTOHARPES || this.info() == PrehistoricEntityInfo.WALLISEROPS ? FossilMod.location("geo/entity/trilobite.geo.json") : FossilMod.location("geo/entity/" + name + ".geo.json");
    }

    private void makeBoundingBoxForCulling(float frustumWidthRadius, float frustumHeight) {
        float x = frustumWidthRadius * this.getScale();
        float y = frustumHeight * this.getScale();
        Vec3 pos = this.m_20182_();
        this.cullingBounds = new AABB(pos.f_82479_ - (double)x, pos.f_82480_, pos.f_82481_ - (double)x, pos.f_82479_ + (double)x, pos.f_82480_ + (double)y, pos.f_82481_ + (double)x);
    }

    @NotNull
    public AABB m_6921_() {
        return this.cullingBounds;
    }

    public void m_6034_(double x, double y, double z) {
        super.m_6034_(x, y, z);
        this.makeBoundingBoxForCulling(this.frustumWidthRadius, this.frustumHeight);
    }

    public boolean m_6087_() {
        return true;
    }

    public float getScale() {
        if (this.isAdult()) {
            return this.data().maxScale();
        }
        float step = (this.data().maxScale() - this.data().minScale()) / (float)this.data().adultAgeDays();
        return this.data().minScale() + step * (float)this.getAge();
    }

    public boolean isAdult() {
        return this.getAge() >= this.data().adultAgeDays();
    }

    public int getAge() {
        return (Integer)this.f_19804_.m_135370_(AGE);
    }

    public void setAge(int age) {
        this.f_19804_.m_135381_(AGE, (Object)age);
    }

    public void setType(PrehistoricEntityInfo info) {
        this.f_19804_.m_135381_(TYPE, (Object)info.name());
    }

    public PrehistoricEntityInfo info() {
        return PrehistoricEntityInfo.valueOf((String)this.f_19804_.m_135370_(TYPE));
    }

    public EntityDataLoader.Data data() {
        return EntityDataLoader.INSTANCE.getData(this.info().resourceName);
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkManager.createAddEntityPacket((Entity)this);
    }

    public void registerControllers(AnimationData data) {
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

