/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity;

import com.github.teamfossilsarcheology.fossil.entity.ToyBase;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import com.github.teamfossilsarcheology.fossil.network.MessageHandler;
import com.github.teamfossilsarcheology.fossil.network.S2CSyncToyAnimationMessage;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ToyTetheredLog
extends ToyBase {
    private static final EntityDataAccessor<String> WOOD_TYPE = SynchedEntityData.m_135353_(ToyTetheredLog.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public int animationTick;
    public boolean animationPlaying;
    public float animationX;
    public float animationZ;

    public ToyTetheredLog(EntityType<ToyTetheredLog> type, Level level) {
        super(type, level, 30, SoundEvents.f_12634_);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(WOOD_TYPE, (Object)WoodType.f_61830_.m_61846_());
    }

    public void startAnimation(float animationX, float animationZ) {
        this.animationTick = 0;
        this.animationPlaying = true;
        this.animationX = animationX;
        this.animationZ = animationZ;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        boolean hurt = super.m_6469_(source, amount);
        if (!hurt && source.m_7640_() != null && !this.f_19853_.f_46443_) {
            Vec3 direction = source.m_7640_().m_20182_().m_82505_(this.m_20182_());
            double dist = direction.m_165924_();
            AABB area = this.m_142469_().m_82377_(16.0, 16.0, 16.0);
            List players = ((ServerLevel)this.f_19853_).m_8795_(serverPlayer -> area.m_82393_(serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_()));
            MessageHandler.SYNC_CHANNEL.sendToPlayers((Iterable)players, (Object)new S2CSyncToyAnimationMessage(this.m_142049_(), (float)(direction.f_82481_ / dist), (float)(direction.f_82479_ / dist)));
        }
        return hurt;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.m_20334_(0.0, 0.0, 0.0);
        if (!this.isAttachedToBlock()) {
            if (!this.f_19853_.f_46443_) {
                Block.m_49840_((Level)this.f_19853_, (BlockPos)this.m_142538_(), (ItemStack)this.m_142340_());
            }
            this.m_146870_();
            this.m_5496_(this.attackNoise, 1.0f, this.getVoicePitch());
        }
        if (this.f_19853_.f_46443_) {
            if (this.animationPlaying) {
                ++this.animationTick;
            }
            if (this.animationTick >= 40) {
                this.animationPlaying = false;
                this.animationTick = 0;
            }
        }
    }

    private boolean isAttachedToBlock() {
        return !this.f_19853_.m_46859_(this.m_142538_().m_6630_(2));
    }

    @Nullable
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)ModItems.TOY_TETHERED_LOGS.get(this.getWoodTypeName()).get());
    }

    public void setWoodType(String woodType) {
        this.f_19804_.m_135381_(WOOD_TYPE, (Object)woodType);
    }

    public String getWoodTypeName() {
        return (String)this.f_19804_.m_135370_(WOOD_TYPE);
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128359_("woodType", this.getWoodTypeName());
    }

    public void m_7378_(CompoundTag compound) {
        String woodType = compound.m_128461_("woodType");
        if (woodType.isBlank()) {
            woodType = WoodType.f_61830_.m_61846_();
        }
        this.setWoodType(woodType);
    }

    @Override
    public float getVoicePitch() {
        return super.getVoicePitch() * 0.2f;
    }
}

