/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai;

import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.OrderType;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricFlying;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class FlyingWanderGoal
extends Goal {
    protected final PrehistoricFlying dino;
    private Vec3 targetPos;
    private boolean shouldLand;
    private boolean isRotating;

    public FlyingWanderGoal(PrehistoricFlying dino) {
        this.dino = dino;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        boolean debug;
        boolean debugLand = false;
        if (this.dino.m_20160_() || this.dino.getCurrentOrder() != OrderType.WANDER || !this.dino.isAdult()) {
            return false;
        }
        if (this.dino.m_142592_()) {
            if (debugLand || this.dino.m_21187_().nextInt(50) == 0) {
                BlockPos landPosition = this.dino.findLandPosition(false);
                if (landPosition != null) {
                    this.shouldLand = true;
                    this.targetPos = Vec3.m_82512_((Vec3i)landPosition);
                    return true;
                }
                return false;
            }
            this.targetPos = this.findAirTarget();
            return this.targetPos != null;
        }
        if (this.dino.m_20096_() && ((debug = false) || this.dino.m_21187_().nextInt(250) == 0)) {
            this.targetPos = this.findAirTarget();
            return this.targetPos != null;
        }
        return false;
    }

    public boolean m_8045_() {
        if (this.dino.m_142592_()) {
            return this.dino.m_21566_().m_24995_();
        }
        return this.isRotating || this.dino.isTakingOff();
    }

    public void m_8056_() {
        this.dino.m_21563_().m_24964_(this.targetPos);
        this.dino.m_21573_().m_26573_();
        if (this.dino.m_142592_()) {
            this.dino.moveTo(this.targetPos, this.shouldLand, true);
        } else {
            this.performTakeOff();
        }
    }

    public void m_8041_() {
        this.shouldLand = false;
        this.isRotating = false;
        this.targetPos = null;
    }

    public void m_8037_() {
        if (!(this.dino.m_142592_() || this.dino.isTakingOff() || this.shouldLand)) {
            this.performTakeOff();
        }
    }

    private void performTakeOff() {
        if (!this.dino.isTakingOff()) {
            Vec3 distance = this.targetPos.m_82546_(this.dino.m_20182_());
            float rot = (float)(Mth.m_14136_((double)distance.f_82481_, (double)distance.f_82479_) * 57.2957763671875 - 90.0);
            float diff = Mth.m_14118_((float)rot, (float)this.dino.f_20883_);
            if (diff > 45.0f) {
                // empty if block
            }
            this.isRotating = false;
            this.dino.moveTo(this.targetPos, false, true);
        }
    }

    private Vec3 findAirTarget() {
        return this.dino.generateAirTarget();
    }
}

