/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai;

import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.PrehistoricFlying;
import com.github.teamfossilsarcheology.fossil.item.ModItems;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec3;

public class WhipSteering {
    private static final int FOLLOW_TIME_WITHOUT_WHIP = 120;
    private final Prehistoric dino;
    private int lastSeenWhipTicks = -1;

    public WhipSteering(Prehistoric dino) {
        this.dino = dino;
    }

    public boolean trySteering(LivingEntity rider) {
        this.lastSeenWhipTicks = rider.m_21120_(InteractionHand.MAIN_HAND).m_150930_((Item)ModItems.WHIP.get()) ? 0 : ++this.lastSeenWhipTicks;
        return this.lastSeenWhipTicks < 120;
    }

    public void airTravel(Vec3 travelVector) {
        Vec3 move = this.dino.m_20184_().m_82490_(0.5);
        PrehistoricFlying flying = (PrehistoricFlying)this.dino;
        if (travelVector.f_82481_ > 0.0) {
            Vec3 look = this.dino.m_20154_();
            move = move.m_82520_((double)this.dino.m_6113_() * look.f_82479_, look.f_82480_ * 0.3, (double)this.dino.m_6113_() * look.f_82481_);
        }
        if (flying.isFlyingUp()) {
            move = new Vec3(move.f_82479_, 0.25 * (double)Math.min(flying.autoPitch, 0.0f) / -70.0, move.f_82481_);
        } else if (flying.isFlyingDown()) {
            move = new Vec3(move.f_82479_, -0.25 * (double)Math.max(flying.autoPitch, 0.0f) / 70.0, move.f_82481_);
        }
        this.dino.m_20256_(move);
        this.dino.m_6478_(MoverType.SELF, move);
    }

    public void slowWaterTravel(Vec3 travelVector) {
        double downwardMovement;
        boolean movement = Math.abs(travelVector.f_82479_) > 0.0 || Math.abs(travelVector.f_82481_) > 0.0;
        double d = downwardMovement = this.dino.m_204036_(FluidTags.f_13131_) > this.dino.m_20204_() * (double)this.dino.m_6134_() ? 0.0 : -0.15;
        if (movement) {
            this.dino.m_20334_(0.0, downwardMovement, 0.0);
        } else {
            this.dino.m_20334_(this.dino.m_20184_().f_82479_ / 2.0, downwardMovement, this.dino.m_20184_().f_82481_ / 2.0);
        }
        double upwardMovement = this.dino.m_204029_(FluidTags.f_13131_) ? 0.15 : 0.0;
        this.dino.m_19920_(this.dino.m_6113_(), new Vec3(travelVector.f_82479_, upwardMovement += this.dino.f_19862_ ? 0.55 : 0.0, travelVector.f_82481_));
        if (this.dino.f_19862_) {
            this.dino.m_20256_(this.dino.m_20184_().m_82520_(0.0, 0.1, 0.0));
        }
        this.dino.m_6478_(MoverType.SELF, this.dino.m_20184_());
    }

    public void waterTravel(Vec3 travelVector, Player rider) {
        double downwardMovement;
        Vec3 look = rider.m_20154_();
        boolean movement = Math.abs(travelVector.f_82479_) > 0.0 || Math.abs(travelVector.f_82481_) > 0.0;
        double d = downwardMovement = look.f_82480_ < -0.4 ? -0.3 : 0.0;
        if (movement) {
            this.dino.m_20334_(0.0, 0.0, 0.0);
        } else {
            this.dino.m_20334_(this.dino.m_20184_().f_82479_ / 2.0, 0.0, this.dino.m_20184_().f_82481_ / 2.0);
        }
        double upwardMovement = look.f_82480_ > 0.0 ? 0.3 : 0.0;
        this.dino.m_19920_(this.dino.m_6113_(), new Vec3(travelVector.f_82479_, upwardMovement + downwardMovement, travelVector.f_82481_));
        this.dino.m_6478_(MoverType.SELF, this.dino.m_20184_());
    }
}

