/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.entity.ai.navigation;

import com.github.teamfossilsarcheology.fossil.entity.ai.navigation.NavUtil;
import com.github.teamfossilsarcheology.fossil.entity.ai.navigation.PrehistoricAmphibiousNodeEvaluator;
import com.github.teamfossilsarcheology.fossil.entity.ai.navigation.WaterPathFinder;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.Prehistoric;
import com.github.teamfossilsarcheology.fossil.entity.prehistoric.base.SwimmingAnimal;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class AmphibiousPathNavigation<T extends Prehistoric>
extends WaterBoundPathNavigation {
    public AmphibiousPathNavigation(T mob, Level level) {
        super(mob, level);
    }

    @NotNull
    protected PathFinder m_5532_(int maxVisitedNodes) {
        this.f_26508_ = new PrehistoricAmphibiousNodeEvaluator();
        return new WaterPathFinder(this.f_26508_, maxVisitedNodes, this.f_26494_);
    }

    protected boolean m_7632_() {
        return ((SwimmingAnimal)((Object)((Prehistoric)this.f_26494_))).isAmphibious() || super.m_7632_();
    }

    protected void m_7636_() {
        Path path = Objects.requireNonNull(this.f_26496_);
        Vec3 entityPos = this.m_7475_();
        int pathLength = path.m_77398_();
        Vec3 base = entityPos.m_82520_((double)(-this.f_26494_.m_20205_() * 0.5f), 0.0, (double)(-this.f_26494_.m_20205_() * 0.5f));
        Vec3 max = base.m_82520_((double)this.f_26494_.m_20205_(), (double)this.f_26494_.m_20206_(), (double)this.f_26494_.m_20205_());
        if (!this.tryShortcut(path, new Vec3(this.f_26494_.m_20185_(), this.f_26494_.m_20186_(), this.f_26494_.m_20189_()), pathLength, base, max) && (this.f_26494_.m_20069_() || NavUtil.isAt((Entity)this.f_26494_, path, Math.min(this.f_26494_.m_20205_() * 0.75f, 0.5f), 0.5f)) && (NavUtil.isAt((Entity)this.f_26494_, path, Math.min(this.f_26494_.m_20205_() * 0.75f, 0.5f), 1.0f) || NavUtil.atElevationChange((Entity)this.f_26494_, path) && NavUtil.isAt((Entity)this.f_26494_, path, this.f_26494_.m_20205_() * 0.75f, 1.0f))) {
            path.m_77374_();
            if (!path.m_77392_()) {
                this.f_26494_.m_21563_().m_24964_(path.m_77380_((Entity)this.f_26494_));
            }
        }
        this.m_6481_(entityPos);
    }

    private boolean tryShortcut(Path path, Vec3 entityPos, int pathLength, Vec3 base, Vec3 max) {
        int i = pathLength;
        while (--i > path.m_77399_()) {
            Vec3 vec = path.m_77382_((Entity)this.f_26494_, i).m_82546_(entityPos);
            if (this.f_26494_.m_20069_()) {
                if (!NavUtil.isNoCollisionOnPath(vec, base, max, PathComputationType.WATER, this.f_26494_, this.f_26508_)) continue;
                path.m_77393_(i);
                return true;
            }
            if (!NavUtil.isNoCollisionOnPath(vec, base, max, PathComputationType.LAND, this.f_26494_, this.f_26508_)) continue;
            path.m_77393_(i);
            return true;
        }
        return false;
    }

    public boolean m_6342_(BlockPos pos) {
        if (((SwimmingAnimal)((Object)((Prehistoric)this.f_26494_))).isAmphibious()) {
            return !this.f_26495_.m_46859_(pos.m_7495_());
        }
        return super.m_6342_(pos);
    }
}

